/* gtkDPSpaintsel.h --- DPS paint selection widget
 * Copyright (C) 1999 Masatake YAMATO
 * 
 * Author: Masatake YAMATO<masata-y@is.aist-nara.ac.jp>
 * Created: Sun Oct  3 00:00:21 1999
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTK_DPS_PAINTSEL_H
#define GTK_DPS_PAINTSEL_H 

#include <glib.h>
#include <gtk/gtk.h>
#include <gtkDPS/gdkDPS.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_DPS_PAINT_SELECTION (gtk_dps_paint_selection_get_type ())
#define GTK_DPS_PAINT_SELECTION(obj) (GTK_CHECK_CAST ((obj), GTK_TYPE_DPS_PAINT_SELECTION, GtkDPSPaintSelection))
#define GTK_DPS_PAINT_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_DPS_PAINT_SELECTION, GtkDPSPaintSelectionClass))
#define GTK_IS_DPS_PAINT_SELECTION(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_DPS_PAINT_SELECTION))
#define GTK_IS_DPS_PAINT_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DPS_PAINT_SELECTION))

typedef struct _GtkDPSPaintSelection GtkDPSPaintSelection;
typedef struct _GtkDPSPaintSelectionClass GtkDPSPaintSelectionClass;

struct _GtkDPSPaintSelectionEntries
{
  gchar * name;
  GSList * paints;
  gint n_paints;
};
typedef struct _GtkDPSPaintSelectionEntries GtkDPSPaintSelectionEntries;

struct _GtkDPSPaintSelectionEntry 
{
  gpointer data;
  gchar * name;
  gint position;
  gboolean g_free_data;
};
typedef struct _GtkDPSPaintSelectionEntry GtkDPSPaintSelectionEntry;

struct _GtkDPSPaintSelection
{
  GtkScrolledWindow scrolled_window;
  GtkWidget * alignment;
  GtkWidget * dps_area;
  GtkDPSPaintSelectionEntries * entries;
  gint paint;
  gint columns;
  gint rows;
  gint x_entry_width;
  gint x_entry_height;
  gint spacing;
  gfloat line_width;
};

struct _GtkDPSPaintSelectionClass
{
  GtkScrolledWindowClass parent_class;

  void (*paint_changed) (GtkDPSPaintSelection *paintsel,
			 gint old,
			 gint new);
  
  void (*draw_entry) (GtkDPSPaintSelection *paintsel,
		      DPSContext raw_ctxt,
		      GdkDPSRectangle * rect,
		      GtkDPSPaintSelectionEntry * entry);
  
  void (*add_entry) (GtkDPSPaintSelection * paintsel,
		     GtkDPSPaintSelectionEntry * entry,
		     gint position);
  void (*remove_entry) (GtkDPSPaintSelection * paintsel,
			GtkDPSPaintSelectionEntry * entry,
			gint position);
  void (*reposit_entry) (GtkDPSPaintSelection * paintsel,
			GtkDPSPaintSelectionEntry * entry,
			 gint old,
			 gint new);
};

/* if columns == 0, use the default value */
GtkWidget * gtk_dps_paint_selection_new (gint columns);
GtkType gtk_dps_paint_selection_get_type (void);

void gtk_dps_paint_selection_set_paint (GtkDPSPaintSelection * paintsel,
					gint paint);
gint gtk_dps_paint_selection_get_paint (GtkDPSPaintSelection * paintsel);

gint gtk_dps_paint_selection_get_paint_at(GtkDPSPaintSelection * paintsel,
					  GdkDPSPoint * point);

/*
 * Entries manipulation
 */
void gtk_dps_paint_selection_add_entry (GtkDPSPaintSelection * paintsel,
					gpointer data,
					gboolean g_free_data,
					gchar * name);
GtkDPSPaintSelectionEntry* gtk_dps_paint_selection_get_entry (GtkDPSPaintSelection * paintsel,
							      gint position);
/* Removed entry is freed */
void gtk_dps_paint_selection_remove_entry (GtkDPSPaintSelection * paintsel,
					   gint position);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* Not def: GTK_DPS_PAINTSEL_H */
