/* gtkDPScontext.h
 * Copyright (C) 1997, 1998 GYVE Development Team
 *
 * Author: Terumoto 'tel' HAYAKAWA <hayakawa@cv.cs.ritsumei.ac.jp>
 * Created: 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTK__DPS_CONTEXT_H
#define GTK__DPS_CONTEXT_H 


#include <gdk/gdk.h>
#include <gtk/gtkdata.h>
#include <gtkDPS/gdkDPS.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_DPS_CONTEXT (gtk_dps_context_get_type())
#define GTK_DPS_CONTEXT(obj) (GTK_CHECK_CAST ((obj), GTK_TYPE_DPS_CONTEXT, GtkDPSContext))
#define GTK_DPS_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_DPS_CONTEXT, GtkDPSContextClass))
#define GTK_IS_DPS_CONTEXT(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_DPS_CONTEXT))
#define GTK_IS_DPS_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DPS_CONTEXT))


typedef struct _GtkDPSContext       GtkDPSContext;
typedef struct _GtkDPSContextClass  GtkDPSContextClass;

struct _GtkDPSContext
{
  GtkData data;
  GdkDPSContext *gdk_dps_context;
  gboolean entered;
};

struct _GtkDPSContextClass
{
  GtkDataClass parent_class;

  void (* enter_context) (GtkDPSContext *gtk_dps_context,
			  DPSContext raw_context);
  void (* leave_context) (GtkDPSContext *gtk_dps_context,
			  DPSContext raw_context);
};


guint      gtk_dps_context_get_type      (void);
GtkObject* gtk_dps_context_new           (GdkDrawable *);
GtkObject* gtk_dps_context_get_shared (void);

GdkGC*     gtk_dps_context_get_gc (GtkDPSContext *);
void gtk_dps_context_update_coordtr(GtkDPSContext * , 
				    GdkDPSCoordtr * );
gboolean gtk_dps_context_try_update_coordtr(GtkDPSContext * , 
					    GdkDPSCoordtr *);

DPSContext gtk_dps_context_enter_context (GtkDPSContext *);
void       gtk_dps_context_leave_context (GtkDPSContext *);

/* TODO: Handle set and get args */
void gtk_dps_context_set_drawable(GtkDPSContext *, GdkDrawable *);
GdkDrawable * gtk_dps_context_get_drawable(GtkDPSContext *);

void gtk_dps_context_flush(GtkDPSContext *);

/* Block */
#define gtk_dps_context_begin(ctxt)			\
{							\
  DPSContext raw_ctxt = gtk_dps_context_enter_context(ctxt);	
#define  gtk_dps_context_end(ctxt)			\
  gtk_dps_context_leave_context(ctxt);				\
}

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK__DPS_CONTEXT_H */
