/* gtkDPSfontsel.h --- File renamed from gtkDPSfontpanel.h by 
   Masatake YAMATO <masata-y@is.aist-nara.ac.jp> */

/* gtkDPSfontpanel.c --- DPS font panel widget
 * Copyright (C) 1998 Hideki FUJIMOTO
 *
 * Author: Hideki FUJIMOTO <hideki70@osk2.3web.ne.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTK_DPS_FONTSEL_H
#define GTK_DPS_FONTSEL_H

/* #include <gtk/gtkvbox.h> */
#include <gtk/gtkwindow.h>
#include <gtk/gtkvpaned.h>

#include <DPS/dpsfriends.h>	/* DPSContext */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_DPS_FONT_SELECTION (gtk_dps_font_selection_get_type())
#define GTK_DPS_FONT_SELECTION(obj) (GTK_CHECK_CAST((obj), GTK_TYPE_DPS_FONT_SELECTION, GtkDPSFontSelection)) 
#define GTK_DPS_FONT_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_DPS_FONT_SELECTION, GtkDPSFontSelectionClass))
#define GTK_IS_DPS_FONT_SELECTION(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_DPS_FONT_SELECTION))
#define GTK_IS_DPS_FONT_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DPS_FONT_SELECTION))

#define GTK_TYPE_DPS_FONT_SELECTION_DIALOG (gtk_dps_font_selection_dialog_get_type())
#define GTK_DPS_FONT_SELECTION_DIALOG(obj) (GTK_CHECK_CAST((obj), GTK_TYPE_DPS_FONT_SELECTION_DIALOG, GtkDPSFontSelectionDialog)) 
#define GTK_DPS_FONT_SELECTION_DIALOG_CLASS(klass)  (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_DPS_FONT_SELECTION_DIALOG, GtkDPSFontSelectionDialogClass))
#define GTK_IS_DPS_FONT_SELECTION_DIALOG(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_DPS_FONT_SELECTION_DIALOG))
#define GTK_IS_DPS_FONT_SELECTION_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DPS_FONT_SELECTION_DIALOG))

typedef struct _GtkDPSFontSelection	     GtkDPSFontSelection;
typedef struct _GtkDPSFontSelectionClass	     GtkDPSFontSelectionClass;

typedef struct _GtkDPSFontSelectionDialog	     GtkDPSFontSelectionDialog;
typedef struct _GtkDPSFontSelectionDialogClass  GtkDPSFontSelectionDialogClass;

struct _GtkDPSFontSelection
{
  /* Parent */
  GtkVPaned vpaned;

  /* GUI */
  GtkWidget  *dps_area;

  GtkWidget  *family_box;
  GtkWidget  *face_box;
  GtkWidget  *size_box;
  GtkWidget  *size_entry;
  
  GtkWidget  *input_entry;
  
  /* Current selection */
  gchar      *font_name;
  gchar      *type_face;
  GtkWidget  *type_face_list_item;
  gint       font_size;

  GtkWidget  *size_list_item;

  /* Misc data */
  gchar * preview_text;
  GSList     * fonts_data;
  gboolean disable_default_previewer;
};

struct _GtkDPSFontSelectionClass
{
  GtkVPanedClass parent_class;
  void (* font_changed) (GtkDPSFontSelection *fontsel,
			 const gchar * font_name,
			 const gint font_size);
  void (* preview_text_changed) (GtkDPSFontSelection *fontsel,
				 const gchar * preview_text);
  
  /* If return value is TRUE stop emission propagation and don't use
   default preview text function */
  gboolean (* draw_preview_text) (GtkDPSFontSelection * fontsel,
				 DPSContext raw_ctxt,
				 const gchar * font_name,
				 const gint font_size,
				 const gchar * preview_text);
};

struct _GtkDPSFontSelectionDialog
{
  GtkWindow window;

  GtkWidget  *fontsel;
  GtkWidget  *main_vbox;
  GtkWidget  *ok_button;
  GtkWidget  *cancel_button;
  GtkWidget  *help_button;
};


struct _GtkDPSFontSelectionDialogClass
{
  GtkWindowClass parent_class;
};

/* FontSelection */
GtkType gtk_dps_font_selection_get_type (void);
GtkWidget *gtk_dps_font_selection_new (void);

gchar *gtk_dps_font_selection_get_font_name (GtkDPSFontSelection *fontsel);
gint gtk_dps_font_selection_get_font_size (GtkDPSFontSelection *fontsel);

void gtk_dps_font_selection_set_font_name (GtkDPSFontSelection *fontsel, 
					   gchar *fontname);
void gtk_dps_font_selection_set_font_size (GtkDPSFontSelection *fontsel, 
					   gint fontsize);
/* Don't free return value */
gchar* gtk_dps_font_selection_get_preview_text (GtkDPSFontSelection *fontsel);
void gtk_dps_font_selection_set_preview_text (GtkDPSFontSelection *fontsel,
					  const gchar	  *text);

/* FontSelectionDialog */
guint      gtk_dps_font_selection_dialog_get_type   (void);
GtkWidget* gtk_dps_font_selection_dialog_new (const gchar *title);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* Not def: GTK_DPS_FONTSEL_H */
