
#include <stdlib.h>

#include "ming.h"

SWFFont f;
SWFMovie m;

struct spinner
{
  SWFDisplayItem i;
  int x;
  int y;
  double rot;
  double scale;
};

/* functions with huge numbers of arbitrary
   arguments are always a good idea!  Really! */

struct spinner *makeSpinner(int r, int g, int b, int a, float rot, int x, int y, float scale, char *string)
{
  SWFText t;
  struct spinner *this = malloc(sizeof(struct spinner));

  t = newSWFText2();
  SWFText_setFont(t, f);
  SWFText_setColor(t, r, g, b, a);
  SWFText_setHeight(t, 960);
  SWFText_moveTo(t, -(SWFText_getWidth(t, string))/2, 220);
  SWFText_addString(t, string, NULL);

  this->x = x;
  this->y = y;
  this->rot = rot;
  this->scale = scale;

  this->i = SWFMovie_add(m, t);
  SWFDisplayItem_rotateTo(this->i, rot);
  SWFDisplayItem_scaleTo(this->i, scale, scale);
  
  return this;
}

void step(struct spinner *s)
{
  s->rot = 19*s->rot/20;
  s->x = (19*s->x + 1200)/20;
  s->y = (19*s->y + 800)/20;
  s->scale = (19*s->scale + 1.0)/20;

  SWFDisplayItem_rotateTo(s->i, s->rot);
  SWFDisplayItem_scaleTo(s->i, s->scale, s->scale);
  SWFDisplayItem_moveTo(s->i, s->x, s->y);
}

int main()
{
  struct spinner *i1, *i2, *i3;
  char *string = "ming!";
  int i;

  Ming_init();
  Ming_setScale(1.0);

  f = loadSWFFontFromFile(fopen("../common/test.fdb", "rb"));

  m = newSWFMovie();
  SWFMovie_setRate(m, 24.0);
  SWFMovie_setDimension(m, 2400, 1600);
  SWFMovie_setBackground(m, 0xff, 0xff, 0xff);

  /* see?  it sure paid off in legibility: */

  i1 = makeSpinner(0xff, 0x33, 0x33, 0xff, 900, 1200, 800, 0.03, string);
  i2 = makeSpinner(0x00, 0x33, 0xff, 0x7f, -560, 1200, 800, 0.04, string);
  i3 = makeSpinner(0xff, 0xff, 0xff, 0x9f, 180, 1200, 800, 0.001, string);

  for(i=1; i<=100; ++i)
  {
    step(i1);
    step(i2);
    step(i3);

    SWFMovie_nextFrame(m);
  }

  SWFMovie_save(m, "test.swf");

  exit(0);
}
