
#include "ming.h"

int main()
{
  SWFMovie m;
  SWFShape s;
  SWFGradient g;
  SWFFill f;

  Ming_init();
  Ming_setScale(1.0);

  m = newSWFMovie();
  SWFMovie_setDimension(m, 320, 240);

  s = newSWFShape();

  /* first gradient- black to white */
  g = newSWFGradient();
  SWFGradient_addEntry(g, 0.0, 0, 0, 0, 0xff);
  SWFGradient_addEntry(g, 1.0, 0xff, 0xff, 0xff, 0xff);

  f = SWFShape_addGradientFill(s, g, SWFFILL_LINEAR_GRADIENT);
  SWFFill_scaleTo(f, 0.01, 0.01);
  SWFFill_moveTo(f, 160, 120);

  SWFShape_setRightFill(s, f);
  SWFShape_drawLine(s, 320, 0);
  SWFShape_drawLine(s, 0, 240);
  SWFShape_drawLine(s, -320, 0);
  SWFShape_drawLine(s, 0, -240);

  SWFMovie_add(m, s);

  s = newSWFShape();

  /* second gradient- radial gradient from white to red to transparent */
  g = newSWFGradient();
  SWFGradient_addEntry(g, 0.0, 0xff, 0, 0, 0xff);
  SWFGradient_addEntry(g, 1.0, 0xff, 0, 0, 0);

  f = SWFShape_addGradientFill(s, g, SWFFILL_RADIAL_GRADIENT);
  SWFFill_scaleTo(f, 0.005, 0.005);
  SWFFill_moveTo(f, 160, 120);

  SWFShape_setRightFill(s, f);
  SWFShape_drawLine(s, 320, 0);
  SWFShape_drawLine(s, 0, 240);
  SWFShape_drawLine(s, -320, 0);
  SWFShape_drawLine(s, 0, -240);

  SWFMovie_add(m, s);

  SWFMovie_save(m, "test.swf");

  exit(0);
}
