
#include "ming.h"

int main()
{
  SWFMovie m;
  SWFDisplayItem i;
  SWFMorph r;
  SWFShape s;
  SWFMovieClip box, cell;

  int n, x, y;

  Ming_init();
  Ming_setScale(1.0);

  m = newSWFMovie();
  SWFMovie_setRate(m, 36.0);
  SWFMovie_setDimension(m, 1200, 800);
  SWFMovie_setBackground(m, 0, 0, 0);

  /* mouse tracking sprite - empty, but follows mouse so we can
     get its x and y coordinates */

  i = SWFMovie_add(m, newSWFSprite());
  SWFDisplayItem_setName(i, "mouse");

  SWFMovie_add(m, compileSWFActionCode("
    startDrag('/mouse', 1); /* '1' means lock sprite to the mouse */
  "));


  /* might as well turn off antialiasing, since these are just squares. */

  SWFMovie_add(m, compileSWFActionCode("
    this.quality = 0;
  "));

  /* morphing box */
  r = newSWFMorphShape();

  s = SWFMorph_getShape1(r);

  SWFShape_setLeftFill(s, SWFShape_addSolidFill(s, 0xff, 0xff, 0xff, 0xff));
  SWFShape_movePenTo(s, -40, -40);
  SWFShape_drawLine(s, 80, 0);
  SWFShape_drawLine(s, 0, 80);
  SWFShape_drawLine(s, -80, 0);
  SWFShape_drawLine(s, 0, -80);

  s = SWFMorph_getShape2(r);

  SWFShape_setLeftFill(s, SWFShape_addSolidFill(s, 0x00, 0x00, 0x00, 0xff));
  SWFShape_movePenTo(s, -1, -1);
  SWFShape_drawLine(s, 2, 0);
  SWFShape_drawLine(s, 0, 2);
  SWFShape_drawLine(s, -2, 0);
  SWFShape_drawLine(s, 0, -2);


  /* sprite container for morphing box -
     this is just a timeline w/ the box morphing */

  box = newSWFMovieClip();
  SWFMovieClip_add(box, compileSWFActionCode("
    stop();
  "));
  i = SWFMovieClip_add(box, r);

  for(n=0; n<=20; ++n)
  {
    SWFDisplayItem_setRatio(i, n/20.0);
    SWFMovieClip_nextFrame(box);
  }


  /* this container sprite allows us to use the same action code many times */

  cell = newSWFMovieClip();
  i = SWFMovieClip_add(cell, box);
  SWFDisplayItem_setName(i, "box");

  SWFMovieClip_add(cell, compileSWFActionCode("

    setTarget('box');

    /* ...x means the x coordinate of the parent, i.e. (..).x */
    dx = (/mouse.x + random(6)-3 - ...x)/5;
    dy = (/mouse.y + random(6)-3 - ...y)/5;
    gotoFrame(int(dx*dx + dy*dy));

  "));

  SWFMovieClip_nextFrame(cell);
  SWFMovieClip_add(cell, compileSWFActionCode("

    gotoFrame(0);
    play();

  "));

  SWFMovieClip_nextFrame(cell);


  /* finally, add a bunch of the cells to the movie */

  for(x=0; x<12; ++x)
  {
    for(y=0; y<8; ++y)
    {
      i = SWFMovie_add(m, cell);
      SWFDisplayItem_moveTo(i, 100*x+50, 100*y+50);
    }
  }

  SWFMovie_nextFrame(m);

  SWFMovie_add(m, compileSWFActionCode("

    gotoFrame(1);
    play();

  "));

  SWFMovie_save(m, "test.swf");

  exit(0);
}
