
#include "ming.h"

SWFFont f;
SWFMovieClip p;

SWFTextField label(char *string)
{
  SWFTextField t = newSWFTextField();
  SWFTextField_setFont(t, f);
  SWFTextField_addString(t, string);
  SWFTextField_setHeight(t, 200);
  SWFTextField_setBounds(t, 3200, 200);
  return t;
}

void addLabel(char *string)
{
  SWFDisplayItem i = SWFMovieClip_add(p, label(string));
  SWFMovieClip_nextFrame(p);
  SWFMovieClip_remove(p, i);
}

SWFShape rect(int r, int g, int b)
{
  SWFShape s = newSWFShape();
  SWFShape_setRightFill(s, SWFShape_addSolidFill(s, r, g, b, 0xff));
  SWFShape_drawLine(s, 600, 0);
  SWFShape_drawLine(s, 0, 600);
  SWFShape_drawLine(s, -600, 0);
  SWFShape_drawLine(s, 0, -600);

  return s;
}

int main()
{
  SWFButton b;
  SWFMovie m;
  SWFDisplayItem i;

  Ming_init();
  Ming_setScale(1.0);

  f = newSWFBrowserFont("_serif");
  p = newSWFMovieClip();

  SWFMovieClip_add(p, compileSWFActionCode("stop();"));
  addLabel("NO ACTION");
  addLabel("SWFBUTTON_MOUSEUP");
  addLabel("SWFBUTTON_MOUSEDOWN");
  addLabel("SWFBUTTON_MOUSEOVER");
  addLabel("SWFBUTTON_MOUSEOUT");
  addLabel("SWFBUTTON_MOUSEUPOUTSIDE");
  addLabel("SWFBUTTON_DRAGOVER");
  addLabel("SWFBUTTON_DRAGOUT");

  b = newSWFButton();
  SWFButton_addShape(b, rect(0xff, 0, 0), SWFBUTTON_UP | SWFBUTTON_HIT);
  SWFButton_addShape(b, rect(0, 0xff, 0), SWFBUTTON_OVER);
  SWFButton_addShape(b, rect(0, 0, 0xff), SWFBUTTON_DOWN);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(1);"),
	        SWFBUTTON_MOUSEUP);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(2);"),
		SWFBUTTON_MOUSEDOWN);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(3);"),
		SWFBUTTON_MOUSEOVER);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(4);"),
		SWFBUTTON_MOUSEOUT);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(5);"),
		SWFBUTTON_MOUSEUPOUTSIDE);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(6);"),
		SWFBUTTON_DRAGOVER);

  SWFButton_addAction(b, compileSWFActionCode("setTarget('/label'); gotoFrame(7);"),
		SWFBUTTON_DRAGOUT);

  m = newSWFMovie();
  SWFMovie_setDimension(m, 4000, 3000);

  i = SWFMovie_add(m, p);
  SWFDisplayItem_setName(i, "label");
  SWFDisplayItem_moveTo(i, 400, 1900);

  i = SWFMovie_add(m, b);
  SWFDisplayItem_moveTo(i, 400,900);

  SWFMovie_save(m, "test.swf");

  exit(0);
}
