=begin
= Search::Namazu 0.1

[ ((<English|URL:search-namazu.en>)) | ((<Japanese|URL:search-namazu.ja>)) ]

== What is Search::Namazu?

This is an extension library for Ruby to use libnmz which is C library of ((<Namazu|URL:http://www.namazu.org/>)).

This supports Ruby 1.6/1.7, Namazu 2.0.x.


== Download

* ((<URL:http://www.tietew.jp/ruby/search-namazu-0.1.tar.gz>))
* ((<URL:ftp://ftp.tietew.jp/pub/ruby/search-namazu-0.1.tar.gz>))


== Install

Extract to some directory and do:

    $ ruby extconf.rb
    $ make
    # make site-install


== Bug

(1) Interfaces may be changed.
(2) Please correct my poor English.


== License

Search::Namazu is copyrighted free software by Tietew.
You can use/redistribute/modify it under the terms of Ruby or Namazu.

Tietew ((<URL:mailto:tietew@tietew.net>))


= Reference

== module Search::Namazu

    require 'search/namazu'
    result = Search::Namazu::search(
        "foo and bar or baz not hoge",
        ['/var/namazu/index/1', '/var/namazu/index/2'])
    p result

=== Module functions:

--- search(query, indices, options = {})
    Search using Namazu, and returns result as Search::Namazu::Result.
    ((|query|)): Query string, ((|indices|)): Array of index directory, ((|options|)): Hash of options.
    
    * ((%"sort"%)) =>
      Sorting method and order (same as CGI parameter)
    * ((%"lang"%)) =>
      Language
    * ((%"fields"%)) =>
      Array of field name to get. ((%uri%)) field will be got any time.
    
    If fail to search, Search::Namazu::Error will be raised.

=== Module constants:

--- SUCCESS
--- ERR_*
    Searching status. For more detail, see libnamazu.h.


== class Search::Namazu::Result

=== Superclass:

Data

=== Methods:

--- hlist
--- results
    Array of Search::Namazu::ResultData of hit document.

--- hitnumlist
    Array of Search::Namazu::HirnumData of hit num.
    Each element of the array matches element of ((|indices|)) when ((%search%)) method is called.


== class Search::Namazu::ResultData

=== Superclass:

Data

=== Methods:

--- score
    Score
--- fields
    Hash of fields
--- date
    Date of document (Time object)
--- rank
    Rank
--- method_missing(key)
    Same as ((%fields[key.to_s]%))


== class Search::Namazu::HitnumData

=== Superclass:

Data

=== Methods:

--- word
    Search word
--- hitnum
    The number of document hit by the word
--- stat
    Searching status
--- phrase
    When phrase search, array of Search::Namazu::HitnumData of each word.


== class Search::Namazu::Error

=== Superclass:

RuntimeError

=== Methods:

--- stat
    Searching status


=end
