/* 
 * ΥץIPAΤǤǤޤ
 * see doc/ILIB
 */

#ifndef INPUT_H_INCLUDE
#define INPUT_H_INCLUDE

extern int anthy_input_errno;
#define AIE_NOMEM 1
#define AIE_INVAL 2
#define AIE_NOIMPL 3

#define ST_OFF  0  /* ̵ */ /* anthy agent does not use this state */
#define ST_NONE 1  /* Ե */
#define ST_EDIT 2  /* Խ */
#define ST_CONV 3  /* Ѵ */
#define ST_CSEG 4  /* ʸ῭̾ */

#define MAP_ALPHABET  0
#define MAP_WALPHABET 1
#define MAP_HIRAGANA  2
#define MAP_KATAKANA  3

#define SF_CURSOR       0x00000001
#define SF_ENUM         0x00000002
#define SF_ENUM_REVERSE 0x00000004
#define SF_EDITTING     0x00000008
#define SF_PENDING      0x00000010
#define SF_FOLLOWING    0x00000020

struct anthy_input_config {
  struct rk_option* rk_option;
//  struct rk_map*   rk_map[NR_RKMAP];
  struct rk_map*   rk_map[5];
};

struct anthy_input_context {
  int no;

  int state;

  /* always allocated */
  struct rk_conv_context* rkctx;
  int map_no;
  char* hbuf;
  int n_hbuf;
  int s_hbuf;
  char* hbuf_follow;
  int n_hbuf_follow;
  int s_hbuf_follow;

  /* allocated only in conv state */
  anthy_context_t actx;
  struct a_segment* segment;
  struct a_segment* cur_segment;
  int enum_cand_count;
  int enum_cand_limit;
  int enum_reverse;
  int last_gotten_cand;

  /* always allocated */
  char* commit;
  int n_commit;
  int s_commit;

  /* always allocated */
  char* cut;
  int n_cut;
  int s_cut;

  struct anthy_input_config* cfg;
};

struct anthy_input_preedit {
  int state;

  char* commit;
  char* cut_buf;

  struct anthy_input_segment* segment;
  struct anthy_input_segment* cur_segment;
};

struct anthy_input_segment {
  char* str;
  int cand_no;
  int noconv_len;
  int nr_cand;
  int flag;

  struct anthy_input_segment* next;
};

/* initialize ... */
int anthy_input_init(void);
struct anthy_input_config* anthy_input_create_config(void);
struct anthy_input_context* 
anthy_input_create_context(struct anthy_input_config* cfg);
void anthy_input_free_context(struct anthy_input_context* ictx);
void anthy_input_free_preedit(struct anthy_input_preedit* pedit);
void anthy_input_free_segment(struct anthy_input_segment* cand);
/*
 * for backward compatibility
 *
struct anthy_input_config* create_anthy_input_config(void);
struct anthy_input_context* 
create_anthy_input_context(struct anthy_input_config* cfg);
void free_anthy_input_context(struct anthy_input_context* ictx);
void free_anthy_input_preedit(struct anthy_input_preedit* pedit);
void free_anthy_input_segment(struct anthy_input_segment* cand);
 *
 */

/* pure function command */
void anthy_input_str(struct anthy_input_context* ictx, char* str);
void anthy_input_next_candidate(struct anthy_input_context* ictx);
void anthy_input_prev_candidate(struct anthy_input_context* ictx);
void anthy_input_quit(struct anthy_input_context* ictx);
void anthy_input_erase_prev(struct anthy_input_context* ictx);
void anthy_input_erase_next(struct anthy_input_context* ictx);
void anthy_input_commit(struct anthy_input_context* ictx);
void anthy_input_move(struct anthy_input_context* ictx, int lr);
void anthy_input_resize(struct anthy_input_context* ictx, int lr);
void anthy_input_beginning_of_line(struct anthy_input_context* ictx);
void anthy_input_end_of_line(struct anthy_input_context* ictx);
void anthy_input_cut(struct anthy_input_context* ictx);

/* key oriented command */
void anthy_input_key(struct anthy_input_context* ictx, int c);
void anthy_input_space(struct anthy_input_context* ictx);

/* meta command */
struct anthy_input_preedit*
anthy_input_get_preedit(struct anthy_input_context* ictx);
int anthy_input_map_select(struct anthy_input_context* ictx, int map);
struct anthy_input_segment* 
anthy_input_get_candidate(struct anthy_input_context* ictx, int cand_no);
int anthy_input_select_candidate(struct anthy_input_context* ictx, int cand);

/* config */
int anthy_input_map_edit(struct anthy_input_context* ictx, 
			  char* from, char* to);

#endif /* INPUT_H_INCLUDE */
