#!/usr/bin/env ruby
# namazu.rb - Namazu search client
# $Id: namazu.rb,v 1.3 2000/12/03 16:21:27 ryu Exp $
#
# namazu.rb is copyrighted free software by OHSHIMA Ryunosuke.
# You can use/redistribute/modify it under the terms of Namazu or Ruby.

require 'rbnamazu'

if ENV['GATEWAY_INTERFACE']

  require 'cgi'
  cgi = CGI.new()
  params = cgi.params()
  params.each() do |key, value|
    params[key] = value.join(' ')
  end
  options = {
    'max' => 20,
    'html' => true,
    'references' => true,
    'page' => true,
    'form' => true,
    'replace' => true,
    'decode-uri' => true,
  }
  options.update(cgi.params())

  $0 = (ENV['PATH_TRANSLATED'] or ENV['SCRIPT_FILENAME'] or $0)
  options['config'] = File.dirname($0) + File::Separator + '.namazurc'

  require 'nkf'
  querystring = NKF.nkf('-emXZ1', (options['query'] or ''))

  nmz = Namazu.new([], options, Namazu::CGIFormatter)
  puts nmz.query_and_format(querystring)

elsif (__FILE__ == $0)

  require 'optparse'
  
  options = {}
  ARGV.options do |opts|
    opts.banner = 'Usage: ' + File.basename($0) + ' [options] <query> [index]...' + "\n"

    opts.on('-n', '--max=NUM', Integer,
	    'set number of documents shown to NUM.') {|options['max']|}
    opts.on('-w', '--whence=NUM', Integer,
	    'set first number of documents shown to NUM.') {|options['whence']|}
    opts.on('-l', '--list',
	    'print results by listing format.') {|options['list']|}
    opts.on('-s', '--short',
	    'print results by short format.'){|options['short']|}
    opts.on('--result=EXT', String,
	    'set NMZ.result.EXT for printing results.') {|options['result']|}
    opts.on('--late',
	    'sort documents in late order.') {|options['late']|}
    opts.on('--early',
	    'sort documents in early order.') {|options['early']|}
    opts.on('--sort=METHOD', String,
	    'set a sort METHOD (score, date, field:name)') {|options['sort']|}
    opts.on('--ascending',
	    'sort in ascending order (default: descending)') {|options['ascending']|}
    #    opts.on('-a','--all',
    #	    'print all results.') {|options['all']|}
    opts.on('-c','--count',
	    'print only number of hits.') {|options['count']|}
    opts.on('-h','--html',
	    'print in HTML format.') {|options['html']|}
    options['references'] = true
    opts.on('-r','--no-references',
	    'do not display reference hit counts.') {|options['references']|}
    opts.on('-H','--page',
	    'print further result links. (nearly meaningless)') {|options['page']|}
    opts.on('-F','--form',
	    'force to print <form> ... </form> region.') {|options['form']|}
    options['replace'] = true
    opts.on('-R','--no-replace',
	    'do not replace URI string.') {|options['replace']|}
    options['decode-uri'] = true
    opts.on('-U','--no-decode-uri',
	    'do not decode URI when printing in a plain format.') {|options['decode-uri']|}
    #    opts.on('-o','--output=FILE', String,
    #	    'set the output file name to FILE.') {|options['output']|}
    opts.on('-f','--config=FILE', String,
	    'set the config file name to FILE.') {|options['config']|}
    opts.on('-C','--show-config',
	    'print current configuration.') {|options['show-config']|}
    #    opts.on('-q','--quiet',
    #	    'do not display extra messages except search results.') {|options['quiet']|}
    #    opts.on('-d','--debug',
    #	    'be debug mode.') {|options['debug']|}
    opts.on('-v','--version',
	    'show the version of namazu and exit.') {puts File.basename($0) + '-0.3'; exit}
    opts.on('--help',
	    'show this help and exit') {puts opts; exit}

    opts.parse!
  end

  querystring, *dirnames = ARGV
  if querystring
    nmz = Namazu.new(dirnames, options)
    puts nmz.query_and_format(querystring)
  else
    puts 'Usage: ' + File.basename($0) + ' [options] <query> [index]...'
    puts 'Try `' + File.basename($0) + ' --help\' for more information.'
  end
end
