/*
 * tkWStr.h --
 *
 *	Declarations for the wide strings.
 *
 * Copyright 1988,1993 Software Research Associates, Inc.
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * $Header: /ext/cvsroot/tk/generic/tkWStr.h,v 1.1 1995/12/21 08:31:46 hoshi Exp $
 */

#ifndef _TKWSTR
#define _TKWSTR

#ifdef KANJI

#ifndef _TK
#include "tk.h"
#endif

/*
 * 
 */

typedef struct {
    XFontStruct *asciiFont;
    XFontStruct *kanjiFont;
    XCharStruct min_bounds;
    XCharStruct max_bounds;
    int ascent;
    int descent;
} XWSFontSet;

typedef struct {
    GC		gc;
    XFontStruct	*font;
    int		flag;
} FontEnt;

typedef struct {
    FontEnt	fe[4];
} XWSGCSet;

typedef XWSGCSet *XWSGC;

/*
 *
 */
#define TK_TWOB		1	/* 2-byte character set */
#define TK_FONTQUERY	2	/* XQueryFont()'ed by this library */
#define TK_GCCREAT	4	/* XtGetGC()'ed by this library */
#define TK_GRMAPPING	8	/* the character codes are mapped to GR
				 * (i.e. their MSBs are 1) */

#define G0MASK	0x0000
#define G1MASK	0x8080
#define G2MASK	0x0080
#define G3MASK	0x8000

#define IS2B(f)	(((f)->max_byte1 > 0) || ((f)->max_char_or_byte2 > 255))

#endif /* KANJI */

#endif /* _TKWSTR */
