
#==============================================================================#
# example/morpheme.rb
#==============================================================================#

require 'gyokuro/gyokuro'

#==============================================================================#

gyokuro = Gyokuro.new(gets.chomp)

gyokuro.each { |m|
  puts("Ф(и)     : #{m.origin}")
  puts("Фɤ(и) : #{m.origin_yomi}")
  puts("Ф(ܷ)     : #{m.basis}")
  puts("Фɤ(ܷ) : #{m.basis_yomi}")
  puts("ʻ쥳         : #{m.part_of_speech_code}")
  puts("ʻ               : #{m.part_of_speech}")
  puts("ѷ       : #{m.conjugated_type_code}")
  puts("ѷ             : #{m.conjugated_type}")
  puts("ѷ       : #{m.conjugated_form_code}")
  puts("ѷ             : #{m.conjugated_form}")
  puts
}

#==============================================================================#
#==============================================================================#
