/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.lax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LAX {
    public static final String PROPERTYPREFIX = "lax.";
    public static final String VERSION = "lax.version";
    public static final String APP_NAME = "lax.application.name";
    public static final String MAIN_CLASS = "lax.main.class";
    public static final String MAIN_METHOD = "lax.main.method";
    public static final String CMD_LINE_ARGS = "lax.command.line.args";
    public static final String USER_DIR = "lax.user.dir";
    public static final String INSTALL_DIRECTORY = "lax.root.install.dir";
    public static final String NATIVE_LAUNCHER_INSTALL_DIRECTORY = "lax.dir";
    public static final String LAX_MAIN_CLASS = "lax.nl.java.launcher.main.class";
    public static final String LAX_MAIN_METHOD = "lax.nl.java.launcher.main.method";
    public static final String CLASS_PATH = "lax.class.path";
    public static final String CURRENT_VM = "lax.nl.current.vm";
    public static final String STDOUT = "lax.stdout.redirect";
    public static final String STDERR = "lax.stderr.redirect";
    private Thread waitThread;
    private String[] nativeArgs;
    private Properties props;

    public LAX() {
        this.printTextSplash();
    }

    public LAX(String[] stringArray) throws Throwable {
        this.printTextSplash();
        this.nativeArgs = stringArray;
        if (stringArray != null && stringArray.length > 0) {
            File file;
            if (stringArray[0].toUpperCase().endsWith(".LAX")) {
                this.getProperties(stringArray[0]);
            }
            if (stringArray.length > 1 && !stringArray[1].equals("lax_no_temp_file") && (file = new File(stringArray[1])) != null && file.exists()) {
                this.getProperties(file.getPath());
                file.delete();
            }
        } else {
            System.out.println("Path not supplied to properties file");
        }
        this.launch();
    }

    public void getProperties(String string) {
        block14: {
            this.props = new Properties(System.getProperties());
            try {
                PrintStream printStream;
                String string2;
                String string3;
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                this.props.load(fileInputStream);
                ((InputStream)fileInputStream).close();
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    string3 = ((String)enumeration.nextElement()).toLowerCase();
                    if (!string3.startsWith(PROPERTYPREFIX)) continue;
                    ((Hashtable)this.props).remove(string3);
                }
                enumeration = this.props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith("LAX.")) continue;
                    string2 = this.props.getProperty(string3);
                    ((Hashtable)this.props).put(string3.toLowerCase(), string2);
                }
                System.setProperties(this.props);
                string3 = System.getProperty("os.name").toLowerCase();
                if (string3.indexOf("unix") != -1 || string3.indexOf("irix") != -1 || string3.indexOf("netbsd") != -1 || string3.indexOf("freebsd") != -1 || string3.indexOf("bsdi") != -1 || string3.indexOf("bsd") != -1 || string3.indexOf("unixware") != -1 || string3.indexOf("aix") != -1 || string3.indexOf("dg/ux") != -1 || string3.indexOf("dgux") != -1 || string3.indexOf("linux") != -1 || string3.indexOf("machten") != -1 || string3.indexOf("nextstep") != -1 || string3.indexOf("rhapsody") != -1 || string3.indexOf("hp-ux") != -1 || string3.indexOf("hpux") != -1 || string3.indexOf("sunos") != -1 || string3.indexOf("solaris") != -1 || string3.indexOf("windows") != -1) {
                    this.setStdOutStdErr();
                }
                if ((string2 = System.getProperty("LISTARGS")) != null) {
                    printStream = System.out;
                    if (string2.length() != 0) {
                        try {
                            printStream = new PrintStream(new FileOutputStream(new File(string2)));
                        }
                        catch (IOException iOException) {}
                    }
                    printStream.println("Args");
                    printStream.println("----");
                    int n = 0;
                    while (n < this.nativeArgs.length) {
                        printStream.println("arg[" + n + "]= '" + this.nativeArgs[n] + "'");
                        ++n;
                    }
                    printStream.println("");
                }
                if ((string2 = System.getProperty("LISTPROPS")) == null) break block14;
                printStream = System.out;
                if (string2.length() != 0) {
                    try {
                        printStream = new PrintStream(new FileOutputStream(new File(string2)));
                    }
                    catch (IOException iOException) {}
                }
                printStream.println("Properties");
                printStream.println("----------");
                Enumeration<?> enumeration2 = this.props.propertyNames();
                while (enumeration2.hasMoreElements()) {
                    String string4 = (String)enumeration2.nextElement();
                    printStream.println(String.valueOf(string4) + " = " + this.props.getProperty(string4));
                }
                printStream.println("");
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setStdOutStdErr() {
        String string;
        String string2 = System.getProperty(STDOUT);
        if (string2 != null && string2.length() > 0 && !string2.toLowerCase().trim().equals("console") && !string2.toLowerCase().trim().equals("")) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(string2, true)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if ((string = System.getProperty(STDERR)) != null && string.length() > 0 && !string.toLowerCase().trim().equals("console") && !string.toLowerCase().trim().equals("")) {
            if (string.equals(string2)) {
                System.setErr(System.out);
                return;
            }
            try {
                System.setErr(new PrintStream(new FileOutputStream(string, true)));
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
    }

    private void launch() throws Throwable {
        Object[] objectArray;
        Class<?> clazz = null;
        String string = this.props.getProperty(MAIN_CLASS);
        if (string == null) {
            throw new RuntimeException("lax.main.class was not found in the properties file.");
        }
        if (string.equals("com.zerog.ia.installer.Main")) {
            this.win98Workaround();
        }
        Method method = null;
        String string2 = this.props.getProperty(MAIN_METHOD);
        if (string2 == null) {
            throw new RuntimeException("lax.main.method was not found in class " + string);
        }
        String string3 = this.props.getProperty(CMD_LINE_ARGS);
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        try {
            objectArray = new Class[]{new String[0].getClass()};
            method = clazz.getMethod(string2, (Class<?>[])objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        try {
            objectArray = new Object[]{this.parseArgs(string3)};
            method.invoke(null, objectArray);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("LAX: Method is inaccessible.");
            System.err.println("The class " + string + " must be public and");
            System.err.println("have a public static void " + string2 + "(String[]) method.");
            System.exit(-1);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("LAX: Method is inaccessible.");
            System.err.println("The class " + string + " must be public and");
            System.err.println("have a public static void " + string2 + "(String[]) method.");
            System.exit(-1);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("LAX: Method.invoke() threw NullPointerException:");
            Thread.dumpStack();
            nullPointerException.printStackTrace(System.err);
            System.err.println("LAX: exiting.");
            System.exit(-1);
            return;
        }
        catch (Exception exception) {
            System.err.println("LAX: Method.invoke() threw Exception:");
            Thread.dumpStack();
            exception.printStackTrace(System.err);
            System.err.println("LAX: exiting.");
            System.exit(-1);
            return;
        }
    }

    private String[] parseArgs(String string) {
        int n;
        Object object;
        if (string == null || string.length() <= 0) {
            return new String[0];
        }
        QuotedStreamTokenizer quotedStreamTokenizer = new QuotedStreamTokenizer(new StringReader(string));
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            while ((string2 = quotedStreamTokenizer.getNextToken()) != null) {
                if (quotedStreamTokenizer.getType() == -10) {
                    vector.addElement(string2);
                    continue;
                }
                if (quotedStreamTokenizer.getType() == -11) {
                    vector.addElement(string2);
                    continue;
                }
                if (quotedStreamTokenizer.getType() != -12) continue;
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (vector.size() <= 0) {
            return new String[0];
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = vector.elementAt(n2);
            if (((String)object).equals("$CMD_LINE_ARGUMENTS$")) {
                n = this.nativeArgs.length - 1;
                while (n > 1) {
                    vector.insertElementAt(this.nativeArgs[n], n2);
                    --n;
                }
                vector.removeElement(object);
            }
            ++n2;
        }
        object = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            object[n] = (String)vector.elementAt(n);
            ++n;
        }
        return object;
    }

    private void printTextSplash() {
        System.out.println("\nLaunchAnywhere(tm) - The Universal Java Application Launcher");
        System.out.println("       Version 2.5 - Copyright 1998 Zero G Software, Inc.\n");
    }

    public static void main(String[] stringArray) throws Throwable {
        new LAX(stringArray);
    }

    private void win98Workaround() {
        String string = System.getProperty("os.name");
        if (string.equals("Windows 98")) {
            Properties properties = System.getProperties();
            ((Hashtable)properties).put(new String("os.name"), new String("Windows 95"));
        }
    }

    public static class QuotedStreamTokenizer {
        private Reader in;
        private char quoteChar = (char)34;
        private char delimiter = (char)32;
        private boolean delimiting = true;
        private int type = -1;
        public static final int NOTHING = -1;
        public static final int WORDS = -10;
        public static final int FULL_QUOTED = -11;
        public static final int HALF_QUOTED = -12;
        private boolean drained = false;
        private boolean quoting = false;

        public QuotedStreamTokenizer(Reader reader) {
            this.in = reader;
        }

        public int getType() {
            return this.type;
        }

        public void setQuoteChar(char c) {
            this.quoteChar = c;
        }

        public char getQuoteChar() {
            return this.quoteChar;
        }

        public void setDelimiter(char c) {
            this.delimiter = c;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public boolean isDelimiting() {
            return this.delimiting;
        }

        public void setDelimiting(boolean bl) {
            this.delimiting = bl;
        }

        public String getNextToken() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (this.drained) {
                this.type = -1;
                return null;
            }
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    if (n == 92) {
                        if (bl) {
                            stringBuffer.append("\\");
                            bl = false;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    if (n == this.quoteChar) {
                        if (bl) {
                            stringBuffer.append("\"");
                            bl = false;
                            continue;
                        }
                        if (this.quoting) {
                            this.type = -11;
                            this.quoting = false;
                            return stringBuffer.toString();
                        }
                        this.quoting = true;
                        if (stringBuffer.length() <= 0) continue;
                        this.type = -10;
                        return stringBuffer.toString();
                    }
                    if (this.isDelimiting() && n == this.delimiter && !this.quoting) {
                        if (bl) {
                            stringBuffer.append("\\");
                            bl = false;
                        }
                        if (stringBuffer.length() <= 0) continue;
                        this.type = -10;
                        return stringBuffer.toString();
                    }
                    if (bl) {
                        stringBuffer.append("\\");
                        bl = false;
                    }
                    stringBuffer.append(String.valueOf((char)n));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.drained = true;
            this.type = this.quoting ? -12 : -10;
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            return null;
        }

        public void close() {
            if (this.in != null) {
                try {
                    this.in.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        }
    }
}

