/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.pdf.Bookmark;
import com.adobe.acrobat.pdf.VBookmark;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import java.util.Dictionary;
import java.util.Vector;

public class PDFBookmark {
    private PDFReference pdfRef;
    private PDFObjStore store;
    private boolean root = false;

    private PDFBookmark() {
    }

    PDFBookmark(PDFObjStore pDFObjStore) {
        this.store = pDFObjStore;
        this.root = true;
    }

    PDFBookmark(PDFReference pDFReference) {
        this.pdfRef = pDFReference;
        this.root = false;
    }

    static Vector PDFBookmarkValue(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<PDFBookmark> vector2 = new Vector<PDFBookmark>();
        int n = 0;
        while (n < vector.size()) {
            Bookmark bookmark = (Bookmark)vector.elementAt(n);
            PDFBookmark pDFBookmark = new PDFBookmark(bookmark.pdfReferenceValue());
            vector2.addElement(pDFBookmark);
            ++n;
        }
        return vector2;
    }

    private Bookmark getBookmark() throws Exception {
        Requester requester = new Requester();
        try {
            Bookmark bookmark = this.getBookmark(requester);
            Object var4_3 = null;
            requester.releaseRequestees();
            return bookmark;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            requester.releaseRequestees();
            throw throwable;
        }
    }

    private Bookmark getBookmark(Requester requester) throws Exception {
        if (this.root) {
            VBookmark vBookmark = VBookmark.getVBookmarkRoot(this.store);
            return vBookmark.bookmarkValue(requester);
        }
        VBookmark vBookmark = VBookmark.getVBookmark(this.pdfRef);
        return vBookmark.bookmarkValue(requester);
    }

    public Vector getBookmarks() throws Exception {
        Requester requester = new Requester();
        try {
            Vector vector = this.getBookmark().getBookmarks(requester);
            Vector vector2 = PDFBookmark.PDFBookmarkValue(vector);
            Object var4_4 = null;
            requester.releaseRequestees();
            return vector2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            requester.releaseRequestees();
            throw throwable;
        }
    }

    public String getTitle() throws Exception {
        return this.getBookmark().getTitle();
    }

    public boolean isLeaf() throws Exception {
        return this.getBookmark().isLeaf();
    }

    public boolean isOpen() throws Exception {
        return this.getBookmark().isOpen();
    }

    public boolean isRoot() throws Exception {
        return this.getBookmark().isRoot();
    }

    public void performAction(Viewer viewer) throws Exception {
        final AcroViewContext acroViewContext = viewer.getContext();
        Transactor transactor = new Transactor(){

            public void buildChanges(Transaction transaction) throws Exception {
                Bookmark bookmark = this.getBookmark(transaction);
                PDFReference pDFReference = bookmark.getActionRef();
                Dictionary dictionary = acroViewContext.getPageView().createActionParamsDictionary(transaction);
                ActionHandler.performAction(transaction, pDFReference, dictionary);
            }
        };
        transactor.commit(acroViewContext);
    }
}

