/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat;

import com.adobe.acrobat.PDFBookmark;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.FileByteArraySourceSpace;
import com.adobe.acrobat.file.URLByteArraySourceSpace;
import com.adobe.acrobat.file.VByteArraySource;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.VPageContentArray;
import com.adobe.acrobat.pdf.Document;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdf.PDFUtil;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdf.VPageRefByNum;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.FontCache;
import com.adobe.acrobat.util.SidecarPainting;
import com.adobe.pe.notify.Requester;
import com.adobe.util.ImageUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.util.Calendar;

public class PDFDocument {
    public static final String Author_K = "Author";
    public static final String CreationDate_K = "CreationDate";
    public static final String ModDate_K = "ModDate";
    public static final String Creator_K = "Creator";
    public static final String Producer_K = "Producer";
    public static final String Title_K = "Title";
    public static final String Subject_K = "Subject";
    public static final String Keywords_K = "Keywords";
    private static final String Info_K = "Info";
    PDFObjStore store;

    static {
        try {
            PDFFont.initPDFFont();
            FontCache fontCache = FontCache.getTheFontCache();
            fontCache.buildCache(false);
            fontCache.setReporterFrame(null);
        }
        catch (Exception exception) {}
    }

    public PDFDocument(ByteArraySource byteArraySource) throws Exception {
        this(new VByteArraySource(byteArraySource));
    }

    private PDFDocument(VByteArraySource vByteArraySource) throws Exception {
        this(new PDFObjStore(vByteArraySource.getVByteArray()));
    }

    private PDFDocument(PDFObjStore pDFObjStore) {
        this.store = pDFObjStore;
    }

    public PDFDocument(File file) throws Exception {
        this(FileByteArraySourceSpace.createFileByteArraySource(file));
    }

    public PDFDocument(URL uRL) throws Exception {
        this(URLByteArraySourceSpace.createURLByteArraySource(uRL));
    }

    public void drawPage(int n, Image image, AffineTransform affineTransform, Rectangle rectangle, Component component) throws Exception {
        ImageUtil.registerRootComponent(component);
        Requester requester = new Requester();
        try {
            PDFReference pDFReference = VPageRefByNum.getVPageRefByNum(this.store, n).pdfReferenceValue(requester);
            ContentArray contentArray = VPageContentArray.getVPageContentArray(pDFReference).contentArrayValue(requester);
            AffineTransform affineTransform2 = VPageProps.getDefaultTransform(pDFReference).affineTransformValue(requester);
            AffineTransform affineTransform3 = affineTransform2.appendTransform(affineTransform);
            FloatRect floatRect = VPageProps.getCropBox(pDFReference).floatRectValue(requester);
            SidecarPainting sidecarPainting = contentArray.createPainting(affineTransform3, floatRect);
            AWTGraphics aWTGraphics = new AWTGraphics(image);
            sidecarPainting.draw(aWTGraphics);
        }
        finally {
            Object var8_14 = null;
            requester.releaseRequestees();
            ImageUtil.unregisterRootComponent(component);
        }
    }

    public String getDocumentInfo(String string) throws Exception {
        String string2;
        Requester requester = new Requester();
        try {
            PDFDict pDFDict = this.store.getTrailer().pdfReferenceValue(requester).dictValue(requester);
            PDFDict pDFDict2 = pDFDict.get(Info_K).dictValue(requester);
            if (pDFDict2.hasKey(string)) {
                String string3 = pDFDict2.get(string).stringValue(requester);
                Object var5_7 = null;
                requester.releaseRequestees();
                return string3;
            }
            string2 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            requester.releaseRequestees();
            throw throwable;
        }
        Object var5_8 = null;
        requester.releaseRequestees();
        return string2;
    }

    public Calendar getDocumentInfoDate(String string) throws Exception {
        Calendar calendar;
        Requester requester = new Requester();
        try {
            PDFDict pDFDict = this.store.getTrailer().pdfReferenceValue(requester).dictValue(requester);
            PDFDict pDFDict2 = pDFDict.get(Info_K).dictValue(requester);
            if (pDFDict2.hasKey(string)) {
                Calendar calendar2 = PDFUtil.parseDate(pDFDict2.get(string).stringValue(requester));
                Object var5_7 = null;
                requester.releaseRequestees();
                return calendar2;
            }
            calendar = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            requester.releaseRequestees();
            throw throwable;
        }
        Object var5_8 = null;
        requester.releaseRequestees();
        return calendar;
    }

    public int getNumPages() throws Exception {
        return Document.getNumPages(this.store).intValue(null);
    }

    public FloatPoint getPageSize(int n) throws Exception {
        Requester requester = new Requester();
        try {
            VPDFReference vPDFReference = VPageRefByNum.getVPageRefByNum(this.store, n);
            FloatRect floatRect = VPageProps.getCropBox(vPDFReference).floatRectValue(requester);
            AffineTransform affineTransform = VPageProps.getDefaultTransform(vPDFReference).affineTransformValue(requester);
            FloatRect floatRect2 = floatRect.transformRect(affineTransform);
            FloatPoint floatPoint = new FloatPoint(floatRect2.width(), floatRect2.height());
            Object var5_8 = null;
            requester.releaseRequestees();
            return floatPoint;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            requester.releaseRequestees();
            throw throwable;
        }
    }

    public PDFBookmark getRootBookmark() throws Exception {
        return new PDFBookmark(this.store);
    }

    public PDFObjStore getStore() {
        return this.store;
    }
}

