/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.acrobat.bytearray.CachingByteArray;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.util.Assert;
import java.io.IOException;
import java.io.InputStream;

class CachingByteArrayInputStream
extends InputStream {
    private boolean closed = false;
    private CachingByteArray cba;
    private ContiguousByteRange br;
    private ContiguousByteRange ubr;
    private int byteIndex = 0;
    private int markedByteIndex = 0;

    CachingByteArrayInputStream(CachingByteArray cachingByteArray, ContiguousByteRange contiguousByteRange) {
        this.cba = cachingByteArray;
        this.br = contiguousByteRange;
        this.byteIndex = contiguousByteRange.getStart();
        int n = contiguousByteRange.getEnd();
        int n2 = cachingByteArray.getByteCache().getBlocksize();
        int n3 = n2 - n % n2 - 1;
        if (n3 > 2048) {
            n3 = 2048;
        }
        int n4 = 0x7FFFFFFE - n;
        this.ubr = new ContiguousByteRange(this.byteIndex, n += Math.min(n3, n4));
    }

    public int available() throws IOException {
        Assert.notFalse(this.closed ^ true);
        ByteRange byteRange = this.cba.getByteCache().getCachedByteRange().decapitate(this.byteIndex);
        ContiguousByteRange contiguousByteRange = byteRange.getNthContiguousByteRange(0);
        if (contiguousByteRange.getStart() != this.byteIndex) {
            return 0;
        }
        return contiguousByteRange.getLength();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.cba.unregisterStream(this);
        }
        this.closed = true;
    }

    ContiguousByteRange getUnconsumedByteRange() {
        return this.ubr.decapitate(this.byteIndex);
    }

    public void mark(int n) {
        Assert.notFalse(this.closed ^ true);
        this.markedByteIndex = this.byteIndex;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n < 0) {
            return n;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        Assert.notFalse(this.closed ^ true);
        n2 = Math.min(byArray.length - n, n2);
        if (n2 <= 0) {
            return -1;
        }
        ContiguousByteRange contiguousByteRange = this.br.intersection(new ContiguousByteRange(this.byteIndex, this.byteIndex + n2 - 1));
        int n3 = this.cba.read(contiguousByteRange, byArray, n);
        if (n3 > 0) {
            this.byteIndex += n3;
        }
        return n3;
    }

    public void reset() throws IOException {
        Assert.notFalse(this.closed ^ true);
        this.byteIndex = this.markedByteIndex;
    }

    public long skip(long l) throws IOException {
        Assert.notFalse(this.closed ^ true);
        long l2 = this.br.getEnd() + 1 - this.byteIndex;
        if (l > l2) {
            l = l2;
        }
        this.byteIndex = (int)((long)this.byteIndex + l);
        return l;
    }
}

