/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.BrowserColumn;
import com.adobe.acrobat.debug.VPDFObjStoreInspectorChain;
import com.adobe.acrobat.debug.VResolvedChain;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.ScrollerLogic;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.StrobeUtils;
import com.adobe.pe.awt.VDimension;
import com.adobe.pe.awt.VScrollPane;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VInt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;

class PDFObjStoreInspectorBrowser
extends Panel
implements VObserver,
StrobeContainer {
    private Vector scrollers = new Vector();
    private Vector columns = new Vector();
    private int numCols;
    private Scrollbar hScroller;
    private Panel galley;
    static final int kBrowserColumnWidth = 200;
    VResolvedChain vChain;
    VPDFObjStoreInspectorChain vInChain;
    VInt vWidth;
    private VStrobe strobe;
    VInt hScrollValue;

    public PDFObjStoreInspectorBrowser(VPDFObjStoreInspectorChain vPDFObjStoreInspectorChain, VResolvedChain vResolvedChain) throws Exception {
        this.vChain = vResolvedChain;
        this.vInChain = vPDFObjStoreInspectorChain;
        this.setLayout(new BrowserLayout());
        this.vWidth = new VBrowserWidth(vResolvedChain);
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            try {
                this.numCols = this.vChain.getNumContainers(requester);
                int n = 0;
                while (n < this.numCols) {
                    VScrollPane vScrollPane = this.getNthScroller(n);
                    if (vScrollPane.getParent() == null) {
                        this.add(vScrollPane);
                        StrobeUtils.setAllStrobesActive(this.strobe.getLastOwnerTransaction(), vScrollPane, true);
                    }
                    ++n;
                }
                int n2 = this.numCols;
                while (n2 < this.columns.size()) {
                    VScrollPane vScrollPane = this.getNthScroller(n2);
                    if (vScrollPane.getParent() != null) {
                        StrobeUtils.setAllStrobesActive(this.strobe.getLastOwnerTransaction(), vScrollPane, false);
                        this.remove(vScrollPane);
                    }
                    ++n2;
                }
                this.columns.setSize(this.numCols);
                this.scrollers.setSize(this.numCols);
            }
            catch (WriteLockException writeLockException) {
                throw writeLockException;
            }
            catch (Exception exception) {
                Log.clog("PDFObjStoreInspectorBrowser.change: " + exception.toString());
            }
            Object var3_8 = null;
            this.invalidate();
            this.validate();
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.invalidate();
            this.validate();
            throw throwable;
        }
    }

    private VScrollPane getNthScroller(int n) throws Exception {
        if (this.columns.size() <= n) {
            int n2 = this.columns.size();
            while (n2 < n + 1) {
                BrowserColumn browserColumn = new BrowserColumn(this, n2);
                this.columns.addElement(browserColumn);
                VDimension vDimension = new VDimension(0, 0);
                ScrollerLogic scrollerLogic = new ScrollerLogic(null, browserColumn.vHeight, -1, -1);
                VScrollPane vScrollPane = new VScrollPane(scrollerLogic);
                vScrollPane.setBackground(Color.lightGray);
                this.scrollers.addElement(vScrollPane);
                this.add(vScrollPane);
                vScrollPane.setContainee(browserColumn);
                StrobeUtils.setAllStrobesActive(this.strobe.getLastOwnerTransaction(), vScrollPane, true);
                ++n2;
            }
        }
        return (VScrollPane)this.scrollers.elementAt(n);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    class BrowserLayout
    implements LayoutManager {
        BrowserLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n = PDFObjStoreInspectorBrowser.this.getSize().height;
            int n2 = 0;
            while (n2 < PDFObjStoreInspectorBrowser.this.numCols) {
                Component component = (Component)PDFObjStoreInspectorBrowser.this.scrollers.elementAt(n2);
                component.setBounds(n2 * 200, 0, 200, n);
                ++n2;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(PDFObjStoreInspectorBrowser.this.numCols * 200, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    class VBrowserWidth
    extends VInt {
        private VResolvedChain chain;

        public VBrowserWidth(VResolvedChain vResolvedChain) {
            this.chain = vResolvedChain;
        }

        protected final int computeInt(Requester requester) throws Exception {
            int n = this.chain.getNumContainers(requester);
            return n * 200;
        }
    }
}

