/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.gui.PageView;
import com.adobe.pe.awt.PEFrame;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.InterruptedIOException;

public class PageViewInspector
extends Panel
implements VObserver,
StrobeContainer {
    private PageView pv;
    private VStrobe strobe;
    private TextArea textArea;

    public PageViewInspector(PageView pageView) {
        this.pv = pageView;
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea("", 0, 0, 1);
        this.textArea.setEditable(false);
        this.add((Component)this.textArea, "Center");
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            String string = this.pv.dumpState(requester);
            this.textArea.setText(string);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception exception) {
            this.textArea.setText(PEUtil.getThrowableMessage(exception, false));
        }
    }

    public static Frame createPageViewInspector(PageView pageView) {
        PEFrame pEFrame = new PEFrame("Page View Inspector", true);
        ((Component)pEFrame).setBounds(600, 100, 300, 300);
        pEFrame.setLayout(new BorderLayout());
        PageViewInspector pageViewInspector = new PageViewInspector(pageView);
        pEFrame.add((Component)pageViewInspector, "Center");
        return pEFrame;
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

