/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.PDFReferenceInfoPanel;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

class ScalarValuePanel
extends Panel
implements VObserver,
StrobeContainer {
    private Label valLabel;
    private VPDFObj vObj;
    private VStrobe strobe;

    ScalarValuePanel(VPDFObj vPDFObj) throws Exception {
        this.vObj = vPDFObj;
        this.setLayout(new BorderLayout());
        this.valLabel = new Label();
        this.valLabel.setAlignment(1);
        this.add((Component)this.valLabel, "Center");
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) {
        try {
            String string;
            PDFObj pDFObj = this.vObj.pdfObjValue(requester);
            int n = pDFObj.type(requester);
            switch (n) {
                case 1: {
                    string = pDFObj.booleanValue(requester) ? "true" : "false";
                    break;
                }
                case 2: {
                    string = String.valueOf(pDFObj.integerValue(requester));
                    break;
                }
                case 3: {
                    string = String.valueOf(pDFObj.floatValue(requester));
                    break;
                }
                case 4: {
                    string = pDFObj.stringValue(requester);
                    break;
                }
                case 5: {
                    string = pDFObj.nameValue(requester);
                    break;
                }
                default: {
                    string = PDFReferenceInfoPanel.typeToString(n);
                }
            }
            this.valLabel.setText("Value: " + string);
        }
        catch (Exception exception) {
            Log.clog("ScalarValuePanel.change " + exception.toString());
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

