/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.VPopupMenuObserver;
import com.adobe.acrobat.gui.VViewerMenus;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.VPopupMenu;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.notify.Transaction;
import java.awt.Component;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class BasicPanel
extends LightWeightPanel
implements StrobeContainer,
MouseListener,
KeyListener {
    private PopupMenu popup;
    private AcroViewContext context;
    VPopupMenuObserver vViewerPopupMenuObserver;
    private boolean ignoreEscAndEnter = false;

    public BasicPanel(AcroViewContext acroViewContext) {
        VUIElement vUIElement = VViewerMenus.getVViewerMenus(acroViewContext);
        VPopupMenu vPopupMenu = new VPopupMenu(vUIElement, acroViewContext);
        this.vViewerPopupMenuObserver = new VPopupMenuObserver(this, vPopupMenu);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.context = acroViewContext;
    }

    PopupMenu getPopupMenu() {
        return this.popup;
    }

    void ignoreEscAndEnter() {
        this.ignoreEscAndEnter = true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public static boolean isPopupEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return mouseEvent.isPopupTrigger() || (4 & n) != 0 || (0x10 & n) != 0 && mouseEvent.isControlDown();
    }

    private boolean isPopupTrigger(MouseEvent mouseEvent) {
        if (this.popup == null) {
            return false;
        }
        return BasicPanel.isPopupEvent(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Component component;
        Log.clog(keyEvent.toString());
        int n = keyEvent.getKeyCode();
        if (this.ignoreEscAndEnter && (n == 10 || n == 27)) {
            this.ignoreEscAndEnter = false;
            keyEvent.consume();
            return;
        }
        if (n == 93 && keyEvent.getKeyChar() == '\u0000') {
            component = keyEvent.getComponent();
            Point point = component.getLocation();
            this.popup.show(component, point.x, point.y);
            keyEvent.consume();
        } else {
            CommandRegistry.executeKeymap(this.context, keyEvent);
        }
        if (n == 9) {
            component = this.getParent();
            if (component != null) {
                component.transferFocus();
            }
        } else {
            this.requestFocus();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isPopupTrigger(mouseEvent)) {
            this.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
        this.requestFocus();
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    synchronized void setPopupMenu(PopupMenu popupMenu) {
        if (this.popup != null) {
            this.remove(this.popup);
        }
        this.popup = popupMenu;
        this.add(popupMenu);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.vViewerPopupMenuObserver.setStrobeActive(transaction, bl);
    }

    public void showPopup(Component component, int n, int n2) {
        Point point = component.getLocationOnScreen();
        this.popup.show(component, n, n2);
    }
}

