/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.EditVerb;
import com.adobe.acrobat.gui.KeyBindings;
import com.adobe.acrobat.gui.PVNavigation;
import com.adobe.acrobat.gui.PrintUI;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.VTocUIElements;
import com.adobe.acrobat.gui.ViewModes;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.util.Assert;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CommandRegistry
implements ExtensionDataProvider,
ViewerCommand {
    private static Properties keymaps;
    private static Properties disallowedCommands;
    private static final String CommandRegistry_K;

    static {
        CommandRegistry_K = "CommandRegistry".intern();
        Extension.registerProvider(CommandRegistry_K, new CommandRegistry());
    }

    public static void addCommand(UIVerb uIVerb, AcroViewContext acroViewContext, String string) {
        if (CommandRegistry.isCommandAllowed(string)) {
            Hashtable hashtable = (Hashtable)acroViewContext.getExtensionData(CommandRegistry_K);
            hashtable.put(string, uIVerb);
        }
    }

    private static Exception buildMissingCommandException(String string) {
        String string2 = Util.getErrorString("Error:CommandNotFound", string);
        return new Exception(string2);
    }

    public static void executeCommand(AcroViewContext acroViewContext, String string) throws Exception {
        CommandRegistry.executeCommand(acroViewContext, acroViewContext, string);
    }

    public static void executeCommand(Transaction transaction, AcroViewContext acroViewContext, String string) throws Exception {
        Hashtable hashtable = (Hashtable)acroViewContext.getExtensionData(CommandRegistry_K);
        UIVerb uIVerb = (UIVerb)hashtable.get(string);
        if (uIVerb == null) {
            throw CommandRegistry.buildMissingCommandException(string);
        }
        uIVerb.invoke(transaction);
    }

    public static void executeCommand(TransactionExecutionContext transactionExecutionContext, AcroViewContext acroViewContext, String string) throws Exception {
        Hashtable hashtable = (Hashtable)acroViewContext.getExtensionData(CommandRegistry_K);
        UIVerb uIVerb = (UIVerb)hashtable.get(string);
        if (uIVerb == null) {
            throw CommandRegistry.buildMissingCommandException(string);
        }
        uIVerb.invoke(transactionExecutionContext);
    }

    public static void executeKeymap(AcroViewContext acroViewContext, KeyEvent keyEvent) {
        Hashtable hashtable = (Hashtable)acroViewContext.getExtensionData(CommandRegistry_K);
        UIVerb uIVerb = CommandRegistry.findCommand(hashtable, keyEvent);
        try {
            if (uIVerb != null) {
                uIVerb.invoke(acroViewContext);
            }
        }
        catch (Exception exception) {}
    }

    protected static UIVerb findCommand(Hashtable hashtable, KeyEvent keyEvent) {
        Enumeration enumeration = ((Hashtable)keymaps).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!CommandRegistry.matches(string, keyEvent)) continue;
            String string2 = keymaps.getProperty(string);
            return (UIVerb)hashtable.get(string2);
        }
        return null;
    }

    public static Properties getKeymaps() {
        return keymaps;
    }

    public static boolean isCommandAllowed(String string) {
        return CommandRegistry.isCommandDisallowed(string) ^ true;
    }

    public static boolean isCommandDisallowed(String string) {
        return disallowedCommands != null && disallowedCommands.getProperty(string) != null;
    }

    public static KeyEvent makeKeyEvent(Component component, String string) {
        KeyEvent keyEvent = null;
        Enumeration enumeration = ((Hashtable)keymaps).keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            String string4 = keymaps.getProperty(string3);
            if (!keymaps.getProperty(string3).equals(string) || (string2 = KeyBindings.getMainKeyText(string3)) == null) continue;
            int n = KeyBindings.getModifiers(string3);
            char c = KeyBindings.getKeyCode(string3);
            if (c == '\u0000') continue;
            keyEvent = new KeyEvent(component, 402, System.currentTimeMillis(), n, 0, c);
            break;
        }
        return keyEvent;
    }

    protected static boolean matches(String string, KeyEvent keyEvent) {
        return string.equals(KeyBindings.getKeybindingText(keyEvent));
    }

    public Object provide(String string, Extensible extensible) {
        if (string == CommandRegistry_K) {
            Assert.notFalse(extensible instanceof AcroViewContext);
            AcroViewContext acroViewContext = (AcroViewContext)extensible;
            return new Hashtable();
        }
        throw new ProviderNotFoundException(string);
    }

    public static void refresh() {
        keymaps = ReaderPrefs.getKeymaps();
    }

    public static void registerAllCommands(AcroViewContext acroViewContext) {
        CommandRegistry.refresh();
        SimpleUIVerb.registerCommands(acroViewContext);
        EditVerb.registerCommands(acroViewContext);
        PVNavigation.registerCommands(acroViewContext);
        ViewModes.registerCommands(acroViewContext);
        PrintUI.registerCommands(acroViewContext);
        VTocUIElements.registerCommands(acroViewContext);
    }

    public static void setDisallowedCommands(String[] stringArray) throws Exception {
        disallowedCommands = new Properties();
        int n = 0;
        while (n < stringArray.length) {
            ((Hashtable)disallowedCommands).put(stringArray[n], "");
            ++n;
        }
    }
}

