/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AnnotView;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VString;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.Dictionary;

class FileAnnotView
extends AnnotView
implements MouseTransactionClient {
    private VString statusVString;
    private static final String FS_K = "FS";
    private static final String F_K = "F";
    private VPainting vPainting = null;
    VBoolean vHilite = new VBoolean(false);

    FileAnnotView(VisiblePage visiblePage, String string, PDFReference pDFReference, Requester requester) throws Exception {
        super(visiblePage, string, pDFReference, requester);
    }

    public Cursor getCursor(Requester requester) throws Exception {
        return Cursor.getPredefinedCursor(0);
    }

    public VString getStatusVString() {
        if (this.statusVString != null) {
            try {
                String string = this.statusVString.stringValue(null);
                if (string == null) {
                    this.statusVString = null;
                }
            }
            catch (Exception exception) {
                this.statusVString = null;
            }
        }
        if (this.statusVString == null) {
            this.statusVString = new VFileAnnotStatusString();
        }
        return this.statusVString;
    }

    public VPainting getVPainting() {
        if (this.vPainting == null) {
            this.vPainting = new VFileAnnotPainting();
        }
        return this.vPainting;
    }

    public void mouseAborted(Transaction transaction) throws Exception {
        this.vHilite.setBooleanValue(transaction, false);
    }

    public void mouseDragged(Transaction transaction, Point point) throws Exception {
        Rectangle rectangle = this.getVBounds().rectangleValue(transaction);
        this.vHilite.setBooleanValue(transaction, rectangle.contains(point));
        transaction.notifyStrobes();
    }

    public boolean mouseHover(Requester requester, Point point) throws Exception {
        return true;
    }

    public void mousePressed(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        this.vHilite.setBooleanValue(transaction, true);
    }

    public void mouseReleased(Transaction transaction, Point point) throws Exception {
        this.vHilite.setBooleanValue(transaction, false);
        Rectangle rectangle = this.getVBounds().rectangleValue(transaction);
        if (rectangle.contains(point)) {
            this.perform(transaction);
        }
    }

    private void perform(Transaction transaction) throws Exception {
        PDFDict pDFDict = this.annotRef.dictValue(transaction);
        PDFDict pDFDict2 = pDFDict.get(FS_K).dictValue(transaction);
        PDFDict pDFDict3 = pDFDict2.get("EF").dictValue(transaction);
        PDFDict pDFDict4 = pDFDict3.get(F_K).dictValue(transaction);
        String string = pDFDict4.get("Subtype").stringValue(transaction);
        String string2 = pDFDict2.get(F_K).stringValue(transaction);
        StreamFactory streamFactory = pDFDict.get(FS_K).pdfReferenceValue(transaction).getFilteredVStreamFactory().streamFactoryValue(transaction);
        if (streamFactory == null) {
            throw new Exception("Unable to create a filtered stream");
        }
        InputStream inputStream = streamFactory.getInputStream();
        string.equals("application/pdf");
    }

    public MouseTransactionClient wantsMouseTransactionControl(Transaction transaction, MouseEvent mouseEvent) {
        return this;
    }

    class VFileAnnotStatusString
    extends VString {
        VFileAnnotStatusString() {
        }

        protected final String computeString(Requester requester) throws Exception {
            PDFDict pDFDict = FileAnnotView.this.annotRef.dictValue(requester);
            Dictionary dictionary = FileAnnotView.this.createActionParamsDictionary(requester);
            if (pDFDict.hasKey(FileAnnotView.FS_K)) {
                PDFDict pDFDict2 = pDFDict.get(FileAnnotView.FS_K).dictValue(requester);
                return "Open file: " + pDFDict2.get(FileAnnotView.F_K).stringValue(requester);
            }
            return "";
        }
    }

    class VFileAnnotPainting
    extends VPainting {
        VFileAnnotPainting() {
        }

        public Painting computePainting(Requester requester) throws Exception {
            boolean bl = FileAnnotView.this.vHilite.booleanValue(requester);
            return FileAnnotView.this.createPainting(requester, bl);
        }
    }
}

