/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.util.Util;
import com.adobe.util.MemUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class FontsPanel
extends Panel
implements ActionListener {
    private AcroViewContext context;
    private List list;
    private Button allFonts;
    private Label fontHeading;
    private int[] tab;
    private Vector fonts;
    private int maxLine = 0;
    protected Panel okCancelPanel;
    protected Panel buttons;
    private static int MAX = 22;
    private static int GAP = 2;

    public FontsPanel(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        this.setLayout(new BorderLayout());
        this.allFonts = new Button(Util.getDialogString("DocInfo:AllFonts"));
        this.allFonts.addActionListener(this);
        this.allFonts.setEnabled(false);
        this.buttons = new Panel();
        this.buttons.setLayout(new FlowLayout());
        this.fonts = new Vector();
        Font font = new Font("Monospaced", 0, 12);
        this.list = new List(20, false);
        this.list.setFont(font);
        this.fontHeading = new Label();
        this.fontHeading.setFont(font);
        this.add((Component)this.fontHeading, "North");
        this.add((Component)this.list, "Center");
        this.add((Component)this.buttons, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.allFonts) {
            this.getAllFonts();
        }
    }

    private String align(String[] stringArray) {
        StringBuffer stringBuffer = MemUtil.allocStringBuffer(this.maxLine);
        int n = 0;
        while (n < this.maxLine) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.insert(0, this.getString(stringArray[0]));
        if (this.tab.length > 1 && this.tab[1] < stringBuffer.length()) {
            stringBuffer.insert(this.tab[0], this.getString(stringArray[1]));
        }
        if (this.tab.length > 2 && this.tab[2] < stringBuffer.length()) {
            stringBuffer.insert(this.tab[1], this.getString(stringArray[2]));
        }
        if (this.tab.length > 3 && this.tab[3] < stringBuffer.length()) {
            stringBuffer.insert(this.tab[2], this.getString(stringArray[3]));
        }
        if (this.tab.length > 4 && this.tab[4] < stringBuffer.length()) {
            stringBuffer.insert(this.tab[3], this.getString(stringArray[4]));
        }
        return String.valueOf(stringBuffer.toString().trim()) + " ";
    }

    private void computeTabs() {
        this.initTabs();
        int n = 0;
        while (n < this.fonts.size()) {
            String[] stringArray = (String[])this.fonts.elementAt(n);
            int n2 = 0;
            while (n2 < 5) {
                this.tab[n2] = Math.max(this.tab[n2], stringArray[n2].length());
                ++n2;
            }
            ++n;
        }
        this.tab[0] = this.tab[0] + GAP;
        this.tab[1] = this.tab[1] + (this.tab[0] + GAP);
        this.tab[2] = this.tab[2] + (this.tab[1] + GAP);
        this.tab[3] = this.tab[3] + (this.tab[2] + GAP);
        this.maxLine = this.tab[4] + this.tab[3];
    }

    private void displayFonts() {
        this.list.removeAll();
        this.computeTabs();
        int n = 0;
        while (n < this.fonts.size()) {
            String[] stringArray = (String[])this.fonts.elementAt(n);
            this.list.add(this.align(stringArray));
            ++n;
        }
    }

    private void getAllFonts() {
        this.getFonts();
        this.displayFonts();
        this.allFonts.setEnabled(false);
    }

    private void getFonts() {
        this.fonts.removeAllElements();
        try {
            PDFObjStore pDFObjStore = this.context.getPDFObjStore(null);
            Vector vector = pDFObjStore.getFontInfo();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = this.makeReadable((String)enumeration.nextElement());
                String[] stringArray = new String[5];
                int n = 0;
                while (n < 5) {
                    int n2 = string.indexOf(9);
                    if (n2 > 0) {
                        stringArray[n] = string.substring(0, n2);
                        string = string.substring(n2 + 1);
                    } else {
                        stringArray[n] = string;
                        string = "";
                    }
                    ++n;
                }
                this.fonts.addElement(stringArray);
            }
        }
        catch (Exception exception) {}
    }

    private int getLength(String string) {
        return Math.min(string.length(), MAX);
    }

    private String getString(String string) {
        return string.length() > MAX ? string.substring(0, MAX) : string;
    }

    private void initTabs() {
        this.tab = new int[5];
        this.tab[0] = Util.getDialogString("DocInfo:FontOriginalFont").length();
        this.tab[1] = Util.getDialogString("DocInfo:FontType").length();
        this.tab[2] = Util.getDialogString("DocInfo:FontEncoding").length();
        this.tab[3] = Util.getDialogString("DocInfo:FontUsedFont").length();
        this.tab[4] = Util.getDialogString("DocInfo:FontType").length();
    }

    private String makeReadable(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            int n2 = stringBuffer.charAt(n);
            if (!(n2 == 9 || n2 >= 32 && n2 <= 126 || n2 >= 160 && n2 <= 223)) {
                n2 = n2 >= 224 && n2 <= 254 ? (int)((char)(n2 & 0x7F)) : 63;
                stringBuffer.setCharAt(n, '?');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void populate() {
        this.getFonts();
        this.displayFonts();
        this.setHeading();
    }

    private void setHeading() {
        String string = Util.getDialogString("DocInfo:FontOriginalFont");
        String string2 = Util.getDialogString("DocInfo:FontType");
        String string3 = Util.getDialogString("DocInfo:FontEncoding");
        String string4 = Util.getDialogString("DocInfo:FontUsedFont");
        String string5 = Util.getDialogString("DocInfo:FontType");
        String string6 = this.align(new String[]{string, string2, string3, string4, string5});
        this.fontHeading.setText(string6);
    }
}

