/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PrintProgressDialog;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.VPageContentArray;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdf.VPageRefByNum;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.pe.notify.Transaction;
import com.adobe.util.ImageMonitor;
import com.adobe.util.ImageUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;

class LocalPrintTask
implements Runnable {
    private Transaction tc;
    private PrintProgressDialog ppdg;
    private PrintJob printJob;
    private PDFObjStore objStore;
    private boolean shrinkToFit;
    private int fromPage;
    private int toPage;

    public LocalPrintTask(Transaction transaction, PrintProgressDialog printProgressDialog, PrintJob printJob, PDFObjStore pDFObjStore, boolean bl, int n, int n2) {
        this.tc = transaction;
        this.ppdg = printProgressDialog;
        this.printJob = printJob;
        this.objStore = pDFObjStore;
        this.shrinkToFit = bl;
        this.fromPage = n;
        this.toPage = n2;
    }

    private static int gcd(int n, int n2) {
        int n3;
        int n4;
        while ((n4 = n - (n3 = n / n2) * n2) != 0) {
            n = n2;
            n2 = n4;
        }
        return n2;
    }

    private static void printPage(Transaction transaction, Graphics graphics, Dimension dimension, int n, PDFObjStore pDFObjStore, boolean bl, int n2) throws Exception {
        boolean bl2;
        AffineTransform affineTransform;
        int n3 = 0x100000;
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        if (bl) {
            rectangle.grow(-n / 4, -n / 4);
        }
        int n4 = n < 150 ? 300 : n;
        int n5 = LocalPrintTask.gcd(n4, n);
        Rectangle rectangle2 = new Rectangle((n4 /= n5) * rectangle.x / (n /= n5), n4 * rectangle.y / n, n4 * rectangle.width / n, n4 * rectangle.height / n);
        int n6 = n3 / rectangle2.width;
        if ((n6 -= n6 % n4) <= 0) {
            n6 = n4;
        }
        int n7 = (rectangle2.height + n6 - 1) / n6;
        n6 = (rectangle2.height + n7 - 1) / n7;
        n6 = n4 * ((n6 + n4 - 1) / n4);
        int n8 = n6 * n / n4;
        PDFReference pDFReference = VPageRefByNum.getVPageRefByNum(pDFObjStore, n2).pdfReferenceValue(transaction);
        ContentArray contentArray = VPageContentArray.getVPageContentArray(pDFReference).contentArrayValue(transaction);
        FloatRect floatRect = VPageProps.getCropBox(pDFReference).floatRectValue(transaction);
        FloatRect floatRect2 = floatRect.transformRect(affineTransform = VPageProps.getDefaultTransform(pDFReference).affineTransformValue(transaction));
        boolean bl3 = bl2 = floatRect2.width() < floatRect2.height() != rectangle2.width < rectangle2.height;
        if (bl2) {
            affineTransform = affineTransform.appendTransform(new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, 0.0));
            floatRect2 = floatRect.transformRect(affineTransform);
        }
        double d = (double)rectangle2.width / floatRect2.width();
        double d2 = (double)rectangle2.height / floatRect2.height();
        double d3 = Math.min(d, d2);
        if (!bl) {
            d3 = (double)n4 / (double)n;
        }
        affineTransform = affineTransform.preScale(d3);
        Rectangle rectangle3 = !bl ? floatRect.transformRect(affineTransform).toRect() : floatRect.transformRect(affineTransform).toEnclosingRect();
        int n9 = (rectangle2.width - rectangle3.width) / 2;
        int n10 = (rectangle2.height - rectangle3.height) / 2;
        if (!bl) {
            if (n9 < 0) {
                n9 = 0;
            }
            if (n10 < 0) {
                n10 = 0;
            }
        }
        affineTransform = affineTransform.translate(n9 - rectangle3.x, n10 - rectangle3.y);
        Rectangle rectangle4 = new Rectangle(0, 0, rectangle2.width, n6);
        AWTGraphics aWTGraphics = new AWTGraphics(rectangle2.width, n6);
        try {
            int n11 = 0;
            while (n11 < n7) {
                Graphics graphics2 = aWTGraphics.getGraphics();
                graphics2.setColor(Color.white);
                graphics2.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                DrawContext drawContext = new DrawContext(aWTGraphics, affineTransform, rectangle4, true);
                contentArray.draw(drawContext);
                Toolkit.getDefaultToolkit().sync();
                SidecarImage sidecarImage = (SidecarImage)aWTGraphics.getImage();
                sidecarImage.sendJavaColorModel(true);
                Image image = ImageUtil.createImage(sidecarImage.getSource());
                ImageMonitor imageMonitor = new ImageMonitor(image);
                if (!graphics.drawImage(image, rectangle.x, rectangle.y + n11 * n8, rectangle.x + rectangle.width, rectangle.y + (n11 + 1) * n8, 0, 0, rectangle4.width, rectangle4.height, Color.white, imageMonitor)) {
                    imageMonitor.waitForFrame();
                }
                image.flush();
                sidecarImage.sendJavaColorModel(false);
                affineTransform = affineTransform.translate(0.0, -rectangle4.height);
                ++n11;
            }
        }
        finally {
            Object var33_35 = null;
            aWTGraphics.dispose();
        }
    }

    public void run() {
        Dimension dimension = this.printJob.getPageDimension();
        int n = this.printJob.getPageResolution();
        boolean bl = this.printJob.lastPageFirst();
        int n2 = this.toPage - this.fromPage + 1;
        int n3 = 0;
        while (n3 < n2) {
            Object var9_8;
            int n4;
            int n5 = n4 = bl ? this.toPage - n3 : this.fromPage + n3;
            if (this.ppdg != null) {
                if (this.ppdg.didUserCancel()) break;
                this.ppdg.setPageNumber(n4);
            }
            Graphics graphics = this.printJob.getGraphics();
            try {
                try {
                    LocalPrintTask.printPage(this.tc, graphics, dimension, n, this.objStore, this.shrinkToFit, n4 - 1);
                }
                catch (Exception exception) {
                    this.tc.getExecutionContext().reportError(this.tc, exception, false);
                }
                var9_8 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                graphics.dispose();
                throw throwable;
            }
            ++n3;
        }
        this.printJob.end();
        if (this.ppdg != null) {
            this.ppdg.dispose();
        }
    }
}

