/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.ComboBox;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.io.Serializable;

class ZoomToDialog {
    private Frame fParent;
    private AcroViewContext context;
    PageView pv;
    private ZoomFactorDialog fZoomDialog;

    public ZoomToDialog(AcroViewContext acroViewContext) throws Exception {
        this.fParent = PEUtil.getFrame(acroViewContext.getRootComponent());
        this.context = acroViewContext;
        this.pv = acroViewContext.getPageView();
        this.showZoomFactorDialog();
    }

    private void showZoomFactorDialog() {
        float f = 1.0f;
        try {
            f = this.pv.getScale(null);
        }
        catch (Exception exception) {}
        this.fZoomDialog = new ZoomFactorDialog(PEUtil.getFrame(this.fParent), f);
        this.fZoomDialog.setVisible(true);
        if (!this.fZoomDialog.didUserCancel()) {
            try {
                Transactor transactor = new Transactor(){

                    public void buildChanges(Transaction transaction) throws Exception {
                        ZoomValueSpec zoomValueSpec = ZoomToDialog.this.fZoomDialog.getZoomSpec();
                        ZoomToDialog.this.pv.setZoomValueSpec(transaction, zoomValueSpec);
                    }
                };
                transactor.commit(this.context);
            }
            catch (Exception exception) {
                Log.clog("ZoomLevelButton.dialogDismissed: " + exception.toString());
            }
            PEUtil.getFrame(this.fParent).toFront();
        }
    }

    class ZoomFactorDialog
    extends BasicDialog {
        private ComboBox fCombo;
        private ZoomValueSpec fZoomSpec = null;

        public ZoomFactorDialog(Frame frame, double d) {
            super(frame, Util.getDialogString("Zoom:ZoomTo"), true);
            Serializable serializable;
            this.setLayout(new BorderLayout(5, 5));
            this.fCombo = new ComboBox(this);
            int n = 0;
            while (n < ZoomValueSpec.zoomValuesTable.length) {
                serializable = ZoomValueSpec.zoomValuesTable[n];
                if (serializable == null) {
                    this.fCombo.addSeparator();
                } else {
                    this.fCombo.addItem(((ZoomValueSpec)serializable).getUIString(true));
                }
                ++n;
            }
            this.fCombo.select(ZoomValueSpec.formatZoomLevel((float)d, true));
            this.fCombo.requestFocus();
            serializable = new Panel();
            ((Container)serializable).setLayout(new FlowLayout(0, 5, 5));
            ((Container)serializable).add(new Label(String.valueOf(Util.getDialogString("Zoom:Magnification")) + ":"));
            ((Container)serializable).add(this.fCombo);
            this.add((Component)serializable, "North");
            this.add((Component)this.okCancelPanel, "South");
            this.pack();
            this.setResizable(false);
        }

        public ZoomValueSpec checkZoomSpec() {
            String string = this.removePercent(this.fCombo.getSelectedItem());
            ZoomValueSpec zoomValueSpec = null;
            try {
                zoomValueSpec = ZoomValueSpec.validateSpec(string, false);
            }
            catch (Exception exception) {
                this.doErrorDialog(string);
                this.fCombo.requestFocus();
            }
            return zoomValueSpec;
        }

        public void doErrorDialog(String string) {
            MessageDialog messageDialog = new MessageDialog(PEUtil.getFrame(this), Util.getDialogString("Dialog:InvalidEntry"), Util.getDialogString("Dialog:NotValidFromTo", string, new Integer((int)(PageView.kMinimumZoom * 100.0f)), new Integer((int)(PageView.kMaximumZoom * 100.0f))));
            messageDialog.runDialog();
        }

        public ZoomValueSpec getZoomSpec() {
            return this.fZoomSpec;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getComponent().getParent() == this.fCombo && keyEvent.getKeyCode() == 10) {
                this.ok();
            } else {
                super.keyReleased(keyEvent);
            }
        }

        public void ok() {
            this.fZoomSpec = this.checkZoomSpec();
            if (this.fZoomSpec == null) {
                return;
            }
            super.ok();
        }

        private String removePercent(String string) {
            if (string.charAt(string.length() - 1) == '%') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
    }
}

