/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui.tree;

import com.adobe.acrobat.gui.tree.Icon;
import com.adobe.acrobat.gui.tree.Tree;
import com.adobe.acrobat.util.Session;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class TreeNode
extends Component
implements MouseListener,
MouseMotionListener {
    public static final int OPEN_CLOSE_CONTROL_WIDTH = 18;
    protected Vector children;
    private TreeNode parent;
    protected Icon icon;
    protected String text;
    private Dimension prefSize;
    private boolean inFocus;
    private boolean isSelected;
    private boolean frameit;
    private boolean isCollapsed;
    private boolean isSingletonChild;
    private boolean isFirstChild;
    private boolean isLastChild;
    private boolean isChildrenKnown = false;
    private Rectangle openCloseControlBounds;
    private Rectangle textBounds;
    private Rectangle textAndIconBounds;
    protected Color textSelectionColor = SystemColor.textHighlightText;
    protected Color textNonSelectionColor = SystemColor.textText;
    protected Color backgroundSelectionColor = SystemColor.textHighlight;
    protected Color backgroundNonSelectionColor = SystemColor.textInactiveText;
    private Insets textInsets;
    private int textHeight;
    private int textWidth;
    private int textLeftMargin;
    private Tip tip;
    private Tree tree;

    protected TreeNode(Icon icon, String string) {
        this.children = new Vector();
        this.icon = icon;
        this.text = string;
        this.inFocus = false;
        this.isSelected = false;
        this.frameit = false;
        this.isCollapsed = true;
        this.openCloseControlBounds = new Rectangle();
        this.textBounds = new Rectangle();
        this.textAndIconBounds = new Rectangle();
        this.isSingletonChild = false;
        this.isFirstChild = false;
        this.isLastChild = false;
        this.textInsets = new Insets(0, 5, 5, 5);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public TreeNode(TreeNode treeNode, Icon icon, String string) {
        this(icon, string);
        this.parent = treeNode;
        if (treeNode != null) {
            treeNode.setChildrenKnown();
            this.tree = treeNode.getTree();
        }
    }

    public void addChildNode(TreeNode treeNode) {
        this.children.addElement(treeNode);
    }

    public void collapseNode() {
        if (this.isLeaf()) {
            return;
        }
        if (!this.isCollapsed) {
            this.tree.removeChildren(this);
            this.isCollapsed = true;
        }
    }

    private void drawConnections(Graphics graphics) {
        graphics.setColor(this.getBackground().darker());
        int n = this.getLevel();
        TreeNode treeNode = this.getParentNode();
        int n2 = n;
        while (n2 >= 2) {
            if (!treeNode.isLastChild()) {
                int n3 = 18 * n2 - 9;
                graphics.drawLine(n3, 0, n3, this.getSize().height);
            }
            treeNode = treeNode.getParentNode();
            --n2;
        }
    }

    private void drawOpenCloseControl(Graphics graphics) {
        int n = this.getLevel();
        int n2 = 8;
        int n3 = 4;
        int n4 = 4;
        int n5 = 5 + n * 18;
        int n6 = this.getSize().height;
        int n7 = n6 / 2 - n3;
        graphics.setColor(this.getBackground().darker());
        if (this.isLeaf()) {
            int n8 = n2 / 2;
            if (this.isLastChild()) {
                graphics.drawLine(n5 + 4, 0, n5 + 4, n7 - 1 + n3);
            } else {
                graphics.drawLine(n5 + 4, 0, n5 + 4, n7 - 1 + n3);
                graphics.drawLine(n5 + 4, n7 + n3, n5 + 4, n6);
            }
            graphics.drawLine(n5 + n8, n7 + 4, this.getAnnotationWidth(), n7 + 4);
        } else {
            this.openCloseControlBounds.setBounds(n5, n7, n2, n2);
            if (this.isChildrenKnown()) {
                graphics.drawRect(n5, n7, n2, n2);
                graphics.setColor(this.textNonSelectionColor);
                if (this.isExpanded()) {
                    graphics.drawLine(n5 + 2, n7 + 4, n5 + 2 + n3, n7 + 4);
                } else {
                    graphics.drawLine(n5 + 2, n7 + 4, n5 + 2 + n3, n7 + 4);
                    graphics.drawLine(n5 + 4, n7 + 2, n5 + 4, n7 + 2 + n4);
                }
            } else {
                graphics.fillRect(n5, n7, n2, n2);
            }
            graphics.setColor(this.textNonSelectionColor);
            if (!this.isRoot()) {
                graphics.setColor(this.getBackground().darker());
                if (this.isLastChild()) {
                    graphics.drawLine(n5 + 4, 0, n5 + 4, n7 - 1);
                } else {
                    graphics.drawLine(n5 + 4, 0, n5 + 4, n7 - 1);
                    graphics.drawLine(n5 + 4, n6 - n2 + 2, n5 + 4, n6);
                }
            }
            graphics.drawLine(n5 + n2 + 1, n7 + 4, this.getAnnotationWidth(), n7 + 4);
        }
    }

    private void drawTreeAnnotation(Graphics graphics) {
        if (this.isRoot() && this.isLeaf()) {
            return;
        }
        this.drawConnections(graphics);
        this.drawOpenCloseControl(graphics);
    }

    public void expandNode() {
        if (!this.isChildrenKnown()) {
            this.tree.expandNode(this);
            return;
        }
        if (this.isLeaf()) {
            this.repaint();
        } else if (this.isCollapsed) {
            this.tree.insertChildren(this);
            this.isCollapsed = false;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isSelected) {
            this.repaint(this.textBounds.x - 1, this.textBounds.y - 1, this.textBounds.width + 2, this.textBounds.height + 2);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.isSelected) {
            this.repaint(this.textBounds.x - 1, this.textBounds.y - 1, this.textBounds.width + 2, this.textBounds.height + 2);
        }
    }

    public int getAnnotationWidth() {
        return (this.getLevel() + 1) * 18;
    }

    public Vector getChildren() {
        return this.children;
    }

    private Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) break;
            container = container.getParent();
        }
        return (Frame)container;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getIconTextGap() {
        return this.icon.isNull() ? 0 : 4;
    }

    public int getLevel() {
        TreeNode treeNode = this.parent;
        int n = 0;
        while (treeNode != null) {
            treeNode = treeNode.getParentNode();
            ++n;
        }
        return n;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public TreeNode getParentNode() {
        return this.parent;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            this.textWidth = fontMetrics.stringWidth(this.text);
            this.textHeight = fontMetrics.getHeight();
            int n = this.icon.getIconWidth() + this.getIconTextGap() + this.textWidth + this.textInsets.left + this.textInsets.right + 18 * (this.getLevel() + 1);
            int n2 = Math.max(this.icon.getIconHeight(), this.textHeight + this.textInsets.top + this.textInsets.bottom);
            this.prefSize = new Dimension(n, n2);
        }
        return this.prefSize;
    }

    public String getText() {
        return this.text;
    }

    private Color getTextBackground() {
        if (this.isSelected && this.hasLostFocus()) {
            return this.backgroundNonSelectionColor;
        }
        if (this.isSelected) {
            return this.backgroundSelectionColor;
        }
        return this.getBackground();
    }

    private Color getTextColor() {
        if (this.isSelected) {
            return this.textSelectionColor;
        }
        return this.textNonSelectionColor;
    }

    Tree getTree() {
        return this.tree;
    }

    private boolean hasLostFocus() {
        return this.tree.hasFocus() ^ true;
    }

    private void highlightNode(MouseEvent mouseEvent, boolean bl) {
        if (!this.textBounds.contains(mouseEvent.getPoint())) {
            return;
        }
        this.inFocus = true;
        if (this.isTextPartlyHidden()) {
            Frame frame = this.getFrame();
            if (frame != null) {
                if (this.tip == null) {
                    this.tip = new Tip(this.text, frame);
                }
                Point point = this.getLocationOnScreen();
                this.tip.setLocation(point.x + this.textBounds.x, point.y);
                this.tip.setVisible(true);
            }
        } else if (bl) {
            this.repaint(this.textBounds.x, this.textBounds.y, this.textBounds.width, this.textBounds.height);
        }
    }

    public void invalidate() {
        this.prefSize = null;
        super.invalidate();
    }

    public boolean isChildrenKnown() {
        return this.isChildrenKnown;
    }

    public boolean isExpanded() {
        return this.isCollapsed ^ true;
    }

    public boolean isLastChild() {
        return this.isLastChild || this.isSingletonChild;
    }

    public boolean isLeaf() {
        return this.children.size() == 0 && this.isChildrenKnown();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    private boolean isTextPartlyHidden() {
        return this.tree.getScrollPane().getViewportSize().width < this.getSize().width;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.onOpenCloseControl(mouseEvent.getPoint())) {
            this.openClose();
        } else {
            this.tree.selectNode(this);
        }
        mouseEvent.consume();
        this.tree.requestFocus();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.tip != null && this.tip.isVisible()) {
            return;
        }
        if (this.onOpenCloseControl(mouseEvent.getPoint())) {
            return;
        }
        this.highlightNode(mouseEvent, true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        this.inFocus = false;
        if (this.textBounds.contains(mouseEvent.getPoint())) {
            return;
        }
        if (this.tip != null && this.tip.isVisible()) {
            this.tip.setVisible(false);
        }
        this.repaint(this.textBounds.x, this.textBounds.y, this.textBounds.width, this.textBounds.height);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private boolean onOpenCloseControl(Point point) {
        return this.openCloseControlBounds.contains(point);
    }

    private void openClose() {
        if (this.isCollapsed) {
            this.expandNode();
        } else {
            this.collapseNode();
        }
    }

    public void paint(Graphics graphics) {
        this.drawTreeAnnotation(graphics);
        this.icon.paintIcon(graphics, this.getAnnotationWidth(), (this.textInsets.top + this.textInsets.bottom) / 2);
        int n = this.textHeight + this.textInsets.top + this.textInsets.bottom;
        int n2 = this.textWidth + this.textInsets.left + this.textInsets.right;
        int n3 = this.getAnnotationWidth();
        int n4 = this.icon.getIconWidth() + this.getIconTextGap();
        int n5 = n3 + n4;
        int n6 = Math.max(this.icon.getIconHeight(), n);
        if (this.isSelected) {
            graphics.setColor(this.getTextBackground());
            graphics.fillRect(n5, 0, n2, n6);
        }
        graphics.setColor(this.getTextColor());
        if (this.frameit) {
            graphics.drawRect(n5, 0, n2 - 1, n - 1);
        }
        this.textBounds.setBounds(n5, 0, n2, n6);
        this.textAndIconBounds.setBounds(n3, 0, n4 + n2 - 1, n6);
        this.textLeftMargin = n5 + this.textInsets.left;
        graphics.drawString(this.text, this.textLeftMargin, n6 - this.textInsets.bottom - 1);
        if (this.inFocus) {
            graphics.drawLine(n5 + this.textInsets.left, n6 - this.textInsets.bottom, n5 + this.textInsets.left + this.textWidth, n6 - this.textInsets.bottom);
        }
    }

    public void removeChildNode(TreeNode treeNode) {
        this.children.removeElement(treeNode);
    }

    public void selectNode(boolean bl) {
        this.isSelected = bl;
        this.repaint(this.textBounds.x - 1, this.textBounds.y - 1, this.textBounds.width + 2, this.textBounds.height + 2);
    }

    public void setChildrenKnown() {
        this.isChildrenKnown = true;
    }

    public void setFrameit(boolean bl) {
        this.frameit = bl;
    }

    public void setIsFirstChild(boolean bl) {
        this.isFirstChild = bl;
    }

    public void setIsLastChild(boolean bl) {
        this.isLastChild = bl;
    }

    public void setIsLeaf() {
        this.isChildrenKnown = true;
        this.children.removeAllElements();
    }

    public void setIsSingletonChild(boolean bl) {
        this.isSingletonChild = bl;
    }

    public void setText(String string) {
        this.text = string;
        this.invalidate();
        this.validate();
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public class Tip
    extends Window
    implements MouseListener {
        private Font font;
        private Dimension dim;
        private String tip;
        private int y;

        public Tip(String string, Frame frame) {
            super(frame);
            this.setText(string);
            ((Component)this).setBackground(SystemColor.info);
            this.addMouseListener(this);
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TreeNode.this.mouseClicked(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((Component)this).setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            this.setVisible(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void paint(Graphics graphics) {
            graphics.setFont(this.font);
            graphics.setColor(SystemColor.infoText);
            graphics.drawString(this.tip, ((TreeNode)TreeNode.this).textInsets.left, this.y);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }

        public void setLocation(int n, int n2) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = this.getSize().width;
            if (n + n3 > dimension.width) {
                n -= n + n3 - dimension.width;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > dimension.height) {
                n2 = dimension.height - this.getSize().height;
            }
            super.setLocation(n, n2);
        }

        public void setText(String string) {
            this.tip = string;
            this.font = TreeNode.this.tree.getFont();
            if (this.font == null) {
                this.font = new Font("SanSerif", 0, 12);
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.y = fontMetrics.getHeight();
            this.dim = new Dimension(fontMetrics.stringWidth(this.tip) + ((TreeNode)TreeNode.this).textInsets.left + ((TreeNode)TreeNode.this).textInsets.right, this.y + ((TreeNode)TreeNode.this).textInsets.top + ((TreeNode)TreeNode.this).textInsets.bottom);
            ((Component)this).setBounds(0, 0, this.dim.width, this.dim.height + 2);
            this.repaint();
        }

        public void setVisible(boolean bl) {
            if (bl) {
                try {
                    Session session = Session.getTheSession();
                    if (session.isIE()) {
                        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                    } else if (session.isNetscape()) {
                        PrivilegeManager.enablePrivilege((String)"UniversalTopLevelWindow");
                    }
                }
                catch (Exception exception) {}
            }
            super.setVisible(bl);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

