/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.VBookmark;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.notify.Requester;
import java.util.Vector;

public class Bookmark {
    private String title;
    private int count;
    private PDFReference bookmarkRef;
    private PDFObj destObj;
    private PDFReference actionRef;
    private boolean root;

    public Bookmark(PDFObjStore pDFObjStore, Requester requester) throws Exception {
        this.bookmarkRef = pDFObjStore.getRootDict().pdfReferenceValue(requester);
        this.root = true;
        this.count = 0;
        PDFDict pDFDict = this.bookmarkRef.dictValue(requester);
        this.count = pDFDict.hasKey("Count") ? pDFDict.get("Count").integerValue(requester) : 0;
    }

    protected Bookmark(PDFReference pDFReference, Requester requester) throws Exception {
        this.root = false;
        this.bookmarkRef = pDFReference;
        PDFDict pDFDict = pDFReference.dictValue(requester);
        this.count = 0;
        this.count = pDFDict.hasKey("Count") ? pDFDict.get("Count").integerValue(requester) : 0;
        this.title = pDFDict.get("Title").stringValue(requester);
        if (pDFDict.hasKey("Dest")) {
            this.destObj = pDFDict.get("Dest");
        } else if (pDFDict.hasKey("A")) {
            this.actionRef = pDFDict.get("A").pdfReferenceValue(requester);
        }
    }

    public PDFReference getActionRef() {
        return this.actionRef;
    }

    public PDFReference getBookmarkRef() {
        return this.bookmarkRef;
    }

    public Vector getBookmarks(Requester requester) throws Exception {
        return this.isRoot() ? this.getRootBookmarks(requester) : this.getNodeBookmarks(requester);
    }

    public PDFObj getDestObj() {
        return this.destObj;
    }

    private Vector getNodeBookmarks(Requester requester) throws Exception {
        PDFDict pDFDict = this.bookmarkRef.dictValue(requester);
        if (pDFDict.hasKey("Outlines")) {
            return this.getRootBookmarks(requester);
        }
        if (this.isLeaf()) {
            return null;
        }
        PDFReference pDFReference = pDFDict.get("First").pdfReferenceValue(requester);
        Vector vector = new Vector();
        this.traverseList(vector, requester, pDFReference);
        return vector;
    }

    private Vector getRootBookmarks(Requester requester) throws Exception {
        PDFDict pDFDict = this.bookmarkRef.dictValue(requester);
        PDFDict pDFDict2 = pDFDict.get("Outlines").dictValue(requester);
        this.count = pDFDict2.get("Count").integerValue(requester);
        PDFReference pDFReference = pDFDict2.get("First").pdfReferenceValue(requester);
        Vector vector = new Vector();
        this.traverseList(vector, requester, pDFReference);
        return vector;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLeaf() {
        return this.count == 0;
    }

    public boolean isOpen() {
        return this.count > 0;
    }

    public boolean isRoot() {
        return this.root;
    }

    public PDFReference pdfReferenceValue() {
        return this.bookmarkRef;
    }

    private void traverseList(Vector vector, Requester requester, PDFReference pDFReference) throws Exception {
        vector.addElement(VBookmark.getVBookmark(pDFReference).bookmarkValue(requester));
        PDFDict pDFDict = pDFReference.dictValue(requester);
        if (pDFDict.hasKey("Next")) {
            PDFReference pDFReference2 = pDFDict.get("Next").pdfReferenceValue(requester);
            this.traverseList(vector, requester, pDFReference2);
        }
    }
}

