/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.VPDFObjNamed;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.util.Assert;
import java.util.Hashtable;

public class NameTree {
    private static final String NameTree_K = "NameTree";
    private static ExtensionDataProvider provider = null;
    private PDFReference rootRef;
    private Hashtable vPDFObjTable = new Hashtable();

    NameTree(PDFReference pDFReference) {
        this.rootRef = pDFReference;
    }

    public static NameTree getNameTree(PDFReference pDFReference) throws Exception {
        NameTree.initProvider();
        return (NameTree)pDFReference.getExtensionData(NameTree_K);
    }

    public VPDFObj getVPDFObjNamed(String string) {
        VPDFObj vPDFObj = (VPDFObj)this.vPDFObjTable.get(string);
        if (vPDFObj == null) {
            vPDFObj = new VPDFObjNamed(this.rootRef, string);
            this.vPDFObjTable.put(string, vPDFObj);
        }
        return vPDFObj;
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFReference);
                    PDFReference pDFReference = (PDFReference)extensible;
                    if (string.equals(NameTree.NameTree_K)) {
                        return new NameTree(pDFReference);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(NameTree_K, provider);
        }
    }

    public boolean knowsVPDFObjNamed(String string) {
        return this.vPDFObjTable.containsKey(string);
    }
}

