/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.vtypes.VColorValue;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.util.Assert;

public class VPDFColorValue
extends VColorValue {
    static final String VPDFColorValue_K = "VPDFColorValue";
    private static ExtensionDataProvider provider = null;
    private PDFReference pdfRef;

    VPDFColorValue(PDFReference pDFReference) {
        this.pdfRef = pDFReference;
    }

    protected ColorValue computeColorValue(Requester requester) throws Exception {
        PDFArray pDFArray = this.pdfRef.arrayValue(requester);
        float[] fArray = new float[3];
        if (pDFArray.size() != 3) {
            throw new Exception("Color object must be an array of exactly 3 elements");
        }
        int n = 0;
        while (n < 3) {
            fArray[n] = pDFArray.get(n).floatValue(requester);
            ++n;
        }
        ColorValue colorValue = new ColorValue(DeviceRGBColorModel.DefaultColorModel, fArray);
        return colorValue;
    }

    public static VColorValue getVPDFColorValue(PDFReference pDFReference) throws Exception {
        VPDFColorValue.initProvider();
        return (VColorValue)pDFReference.getExtensionData(VPDFColorValue_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    if (string.equals(VPDFColorValue.VPDFColorValue_K)) {
                        Assert.notFalse(extensible instanceof PDFReference);
                        return new VPDFColorValue((PDFReference)extensible);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPDFColorValue_K, provider);
        }
    }
}

