/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.VPDFTransformProvider;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.notify.Requester;

public class VPDFTransform
extends VAffineTransform {
    static final String VPDFTransform_K = "VPDFTransform";
    private static VPDFTransformProvider provider = null;
    PDFReference arrayRef;

    public VPDFTransform(PDFReference pDFReference) {
        this.arrayRef = pDFReference;
    }

    protected AffineTransform computeAffineTransform(Requester requester) throws Exception {
        PDFArray pDFArray = this.arrayRef.arrayValue(requester);
        if (pDFArray.size() != 6) {
            throw new Exception("Malformed Rectangle");
        }
        AffineTransform affineTransform = new AffineTransform(this.extractOneFloatValue(pDFArray, 0, requester), this.extractOneFloatValue(pDFArray, 1, requester), this.extractOneFloatValue(pDFArray, 2, requester), this.extractOneFloatValue(pDFArray, 3, requester), this.extractOneFloatValue(pDFArray, 4, requester), this.extractOneFloatValue(pDFArray, 5, requester));
        return affineTransform;
    }

    private double extractOneFloatValue(PDFArray pDFArray, int n, Requester requester) throws Exception {
        return pDFArray.get(n).doubleValue(requester);
    }

    public static VAffineTransform getVPDFTransform(PDFReference pDFReference) throws Exception {
        VPDFTransform.initProvider();
        return (VAffineTransform)pDFReference.getExtensionData(VPDFTransform_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new VPDFTransformProvider();
            Extension.registerProvider(VPDFTransform_K, provider);
        }
    }
}

