/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.VFunction;
import com.adobe.acrobat.pdf.VPDFColorModel;
import com.adobe.acrobat.pdf.VPDFFloatRect;
import com.adobe.acrobat.pdf.VPDFTransform;
import com.adobe.acrobat.pdf.VShading;
import com.adobe.acrobat.pdf.image.BlendShading;
import com.adobe.acrobat.pdf.image.MeshShading;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.Shading;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;
import com.adobe.util.MemUtil;

class VShadingByRef
extends VShading {
    static final String ShadingType_K = "ShadingType";
    static final String ColorSpace_K = "ColorSpace";
    static final String Background_K = "Background";
    static final String BBox_K = "BBox";
    static final String AntiAlias_K = "AntiAlias";
    static final String Domain_K = "Domain";
    static final String Matrix_K = "Matrix";
    static final String Function_K = "Function";
    static final String Coords_K = "Coords";
    static final String Extend_K = "Extend";
    static final String BitsPerCoordinate_K = "BitsPerCoordinate";
    static final String BitsPerComponent_K = "BitsPerComponent";
    static final String BitsPerFlag_K = "BitsPerFlag";
    static final String Decode_K = "Decode";
    static final String VerticesPerRow_K = "VerticesPerRow";
    private PDFReference shadeRef;

    VShadingByRef(PDFReference pDFReference, PDFReference pDFReference2) {
        super(pDFReference2);
        this.shadeRef = pDFReference;
    }

    private void checkFunctions(Function[] functionArray, int n, int n2) throws Exception {
        int n3;
        if (functionArray.length == 1) {
            if (functionArray[0] != null && functionArray[0].getFunctionType() != -1) {
                if (functionArray[0].getDomainSize() != n) {
                    throw new Exception("Shading Function Domain has wrong cardinality");
                }
                if (functionArray[0].getRangeSize() != n2) {
                    throw new Exception("Shading Function Range has wrong cardinality");
                }
            }
        } else if (functionArray.length == n2) {
            n3 = 0;
            while (n3 < n2) {
                if (functionArray[0].getDomainSize() != n) {
                    throw new Exception("Shading Function Domain has wrong cardinality");
                }
                if (functionArray[0].getRangeSize() != 1) {
                    throw new Exception("Shading Function Range has wrong cardinality");
                }
                ++n3;
            }
        } else {
            throw new Exception("Function array has wrong number of components");
        }
        n3 = functionArray.length;
        while (n3-- > 0) {
            if (functionArray[n3] == null || functionArray[n3].getFunctionType() == -1) continue;
            return;
        }
        functionArray = null;
    }

    protected Shading computeShading(Requester requester) throws Exception {
        Shading shading = null;
        PDFDict pDFDict = this.shadeRef.dictValue(requester);
        int n = pDFDict.get(ShadingType_K).integerValue(requester);
        PDFColorModel pDFColorModel = VPDFColorModel.getVPDFColorModel(this.shadeRef, this.pageResources).colorModel(requester);
        int n2 = pDFColorModel.getNumComponents();
        float[] fArray = null;
        FloatRect floatRect = null;
        boolean bl = false;
        int n3 = 0;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        boolean[] blArray = new boolean[2];
        Function[] functionArray = null;
        AffineTransform affineTransform = null;
        StreamFactory streamFactory = this.shadeRef.getFilteredVStreamFactory().streamFactoryValue(requester);
        if (pDFDict.hasKey(Background_K) && (fArray = this.getFloatVector(pDFDict.get(Background_K), requester)).length != n2) {
            throw new Exception("Background color has wrong number of components");
        }
        if (pDFDict.hasKey(BBox_K)) {
            floatRect = VPDFFloatRect.getVPDFFloatRect(pDFDict.get(BBox_K).pdfReferenceValue(requester)).floatRectValue(requester);
        }
        if (pDFDict.hasKey(AntiAlias_K)) {
            bl = pDFDict.get(AntiAlias_K).booleanValue(requester);
        }
        switch (n) {
            case 1: {
                if (pDFDict.hasKey(Domain_K) && (fArray4 = this.getFloatVector(pDFDict.get(Domain_K), requester)).length != 4) {
                    throw new Exception("Shading Domain array has wrong number of components");
                }
                if (pDFDict.hasKey(Matrix_K)) {
                    affineTransform = VPDFTransform.getVPDFTransform((PDFReference)pDFDict.get(Matrix_K)).affineTransformValue(requester);
                }
                functionArray = this.getFuncVector(pDFDict.get(Function_K), requester);
                this.checkFunctions(functionArray, 2, n2);
                shading = new BlendShading(n, pDFColorModel, fArray, floatRect, bl, fArray4, affineTransform, functionArray);
                break;
            }
            case 2: 
            case 3: {
                fArray2 = this.getFloatVector(pDFDict.get(Coords_K), requester);
                if (fArray2.length != (n == 2 ? 4 : 6)) {
                    throw new Exception("Shading Coords array has wrong number of components");
                }
                functionArray = this.getFuncVector(pDFDict.get(Function_K), requester);
                this.checkFunctions(functionArray, 1, n2);
                if (pDFDict.hasKey(Domain_K) && (fArray4 = this.getFloatVector(pDFDict.get(Domain_K), requester)).length != 2) {
                    throw new Exception("Shading Domain array has wrong number of components");
                }
                if (pDFDict.hasKey(Extend_K)) {
                    PDFArray pDFArray = pDFDict.get(Extend_K).arrayValue(requester);
                    if (pDFArray.size() != 2) {
                        throw new Exception("Shading Extend array has wrong number of components");
                    }
                    blArray[0] = pDFArray.get(0).booleanValue(requester);
                    blArray[1] = pDFArray.get(1).booleanValue(requester);
                }
                shading = new BlendShading(n, pDFColorModel, fArray, floatRect, bl, fArray2, fArray4, functionArray, blArray);
                break;
            }
            case 5: {
                n3 = pDFDict.get(VerticesPerRow_K).integerValue(requester);
            }
            case 4: 
            case 6: 
            case 7: {
                int n4 = pDFDict.get(BitsPerCoordinate_K).integerValue(requester);
                int n5 = pDFDict.get(BitsPerComponent_K).integerValue(requester);
                int n6 = n != 5 ? pDFDict.get(BitsPerFlag_K).integerValue(requester) : 0;
                fArray3 = this.getFloatVector(pDFDict.get(Decode_K), requester);
                if (fArray3.length != 2 * n2 + 4) {
                    throw new Exception("Shading Decode vector has wrong number of components");
                }
                if (pDFDict.hasKey(Function_K)) {
                    functionArray = this.getFuncVector(pDFDict.get(Function_K), requester);
                    this.checkFunctions(functionArray, 1, n2);
                }
                streamFactory = this.shadeRef.getFilteredVStreamFactory().streamFactoryValue(requester);
                shading = new MeshShading(n, pDFColorModel, fArray, floatRect, bl, n4, n5, n6, n3, fArray3, functionArray, streamFactory);
                break;
            }
            default: {
                throw new Exception("Unknown shading type: " + n);
            }
        }
        return shading;
    }

    private float[] getFloatVector(PDFObj pDFObj, Requester requester) throws Exception {
        float[] fArray = null;
        if (pDFObj != null) {
            if (pDFObj.type(requester) == 7) {
                PDFArray pDFArray = pDFObj.arrayValue(requester);
                int n = pDFArray.size();
                fArray = MemUtil.allocFloat(n);
                int n2 = 0;
                while (n2 < n) {
                    fArray[n2] = pDFArray.get(n2).floatValue(requester);
                    ++n2;
                }
            } else {
                fArray = new float[]{pDFObj.floatValue(requester)};
            }
        }
        return fArray;
    }

    private Function[] getFuncVector(PDFObj pDFObj, Requester requester) throws Exception {
        Function[] functionArray = null;
        if (pDFObj != null) {
            if (pDFObj.type(requester) == 7) {
                PDFArray pDFArray = pDFObj.arrayValue(requester);
                int n = pDFArray.size();
                functionArray = new Function[n];
                int n2 = 0;
                while (n2 < n) {
                    functionArray[n2] = VFunction.function(pDFArray.get(n2), requester);
                    ++n2;
                }
            } else {
                functionArray = new Function[]{VFunction.function(pDFObj, requester)};
            }
        }
        return functionArray;
    }
}

