/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;

public class CalRGBColorModel
extends PDFColorModel {
    private float[] matrix;
    private float[] gammaR;
    private float[] gammaG;
    private float[] gammaB;

    public CalRGBColorModel() {
        this(new PDFColorParams(1));
    }

    public CalRGBColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float[] fArray = pDFColorParams.getDecode();
        float[] fArray2 = pDFColorParams.getMatrix();
        float[] fArray3 = pDFColorParams.getGamma();
        this.matrix = new float[9];
        this.gammaR = MemUtil.allocFloat(256);
        this.gammaG = MemUtil.allocFloat(256);
        this.gammaB = MemUtil.allocFloat(256);
        int n = 0;
        while (n < 256) {
            double d;
            double d2 = d = (double)n / 255.0;
            double d3 = d;
            if (fArray != null) {
                d3 = (double)fArray[0] + d3 * (double)(fArray[1] - fArray[0]);
                d2 = (double)fArray[2] + d2 * (double)(fArray[3] - fArray[2]);
                d = (double)fArray[4] + d * (double)(fArray[5] - fArray[4]);
            }
            if (fArray3 != null) {
                d3 = Math.pow(d3, fArray3[0]);
                d2 = Math.pow(d2, fArray3[1]);
                d = Math.pow(d, fArray3[2]);
            }
            this.gammaR[n] = (float)d3;
            this.gammaG[n] = (float)d2;
            this.gammaB[n] = (float)d;
            ++n;
        }
        n = 0;
        while (n < 3) {
            float f = fArray2[n] * PDFColorModel.xyz2sRGB[0];
            f += fArray2[n + 3] * PDFColorModel.xyz2sRGB[1];
            this.matrix[n] = f += fArray2[n + 6] * PDFColorModel.xyz2sRGB[2];
            f = fArray2[n] * PDFColorModel.xyz2sRGB[3];
            f += fArray2[n + 3] * PDFColorModel.xyz2sRGB[4];
            this.matrix[n + 3] = f += fArray2[n + 6] * PDFColorModel.xyz2sRGB[5];
            f = fArray2[n] * PDFColorModel.xyz2sRGB[6];
            f += fArray2[n + 3] * PDFColorModel.xyz2sRGB[7];
            this.matrix[n + 6] = f += fArray2[n + 6] * PDFColorModel.xyz2sRGB[8];
            ++n;
        }
    }

    public float[] getBlack() {
        float[] fArray = new float[3];
        fArray[2] = 0.0f;
        fArray[1] = 0.0f;
        fArray[0] = 0.0f;
        return fArray;
    }

    public ColorModel getJavaColorModel() {
        return this;
    }

    public int getRGB(float f, float f2, float f3) {
        float[] fArray = this.params.getMatrix();
        float[] fArray2 = this.params.getGamma();
        if (fArray2 != null) {
            f = (float)Math.pow(f, fArray2[0]);
            f2 = (float)Math.pow(f2, fArray2[1]);
            f3 = (float)Math.pow(f3, fArray2[2]);
        }
        float f4 = f * fArray[0] + f2 * fArray[3] + f3 * fArray[6];
        float f5 = f * fArray[1] + f2 * fArray[4] + f3 * fArray[7];
        float f6 = f * fArray[2] + f2 * fArray[5] + f3 * fArray[8];
        return PDFColorModel.XYZtoRGB(f4, f5, f6);
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 3) {
            return this.getRGB(fArray[0], fArray[1], fArray[2]);
        }
        throw new RuntimeException("CalRGBColorModel.getRGB(c[]) -- arrayToShort");
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int[] nArray2 = this.params.getAlphaMask();
        int n11 = 0;
        while (n11 < n3) {
            n4 = byArray[n] & 0xFF;
            n5 = byArray[n + 1] & 0xFF;
            n6 = byArray[n + 2] & 0xFF;
            n += 3;
            if (n4 == n8 && n5 == n9 && n6 == n10) {
                nArray[n2 + n11] = n7;
            } else if (nArray2 != null && nArray2[0] <= n4 && n4 <= nArray2[1] && nArray2[2] <= n5 && n5 <= nArray2[3] && nArray2[4] <= n6 && n6 <= nArray2[5]) {
                n8 = n4;
                n9 = n5;
                n10 = n6;
                n7 = 0;
                nArray[n2 + n11] = 0;
            } else {
                n8 = n4;
                n9 = n5;
                n10 = n6;
                float f = this.gammaR[n4];
                float f2 = this.gammaG[n5];
                float f3 = this.gammaB[n6];
                float f4 = f * this.matrix[0] + f2 * this.matrix[3] + f3 * this.matrix[6];
                float f5 = f * this.matrix[1] + f2 * this.matrix[4] + f3 * this.matrix[7];
                float f6 = f * this.matrix[2] + f2 * this.matrix[5] + f3 * this.matrix[8];
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                } else if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                } else if (f5 > 1.0f) {
                    f5 = 1.0f;
                }
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                } else if (f6 > 1.0f) {
                    f6 = 1.0f;
                }
                int n12 = Math.round(255.0f * (float)Math.pow(f4, 0.45454545454545453));
                int n13 = Math.round(255.0f * (float)Math.pow(f5, 0.45454545454545453));
                int n14 = Math.round(255.0f * (float)Math.pow(f6, 0.45454545454545453));
                nArray[n2 + n11] = n7 = -16777216 + (n12 << 16) + (n13 << 8) + n14;
            }
            ++n11;
        }
    }

    public String toString() {
        return "CalRGB";
    }
}

