/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class DeviceGrayColorModel
extends PDFColorModel {
    private byte[] alpha;
    private byte[] gray;
    private boolean isOrdered;
    public static final PDFColorModel DefaultColorModel = new DeviceGrayColorModel();
    private ColorModel javaColorModel;

    public DeviceGrayColorModel() {
        this(new PDFColorParams(5));
    }

    public DeviceGrayColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float f;
        float f2;
        float[] fArray = pDFColorParams.getDecode();
        int[] nArray = pDFColorParams.getAlphaMask();
        this.alpha = MemUtil.allocByte(256);
        this.gray = MemUtil.allocByte(256);
        int n = 0;
        if (fArray != null && fArray.length >= 2) {
            f2 = fArray[0];
            f = fArray[1] - fArray[0];
        } else {
            f2 = 0.0f;
            f = 1.0f;
        }
        f2 *= 255.0f;
        this.isOrdered = true;
        int n2 = 0;
        while (n2 < 256) {
            if (nArray != null && nArray[0] <= n2 && n2 <= nArray[1]) {
                this.gray[n2] = 0;
                this.alpha[n2] = 0;
                this.isOrdered = false;
            } else {
                n = Math.max(0, Math.min(255, Math.round(f2 + (float)n2 * f)));
                this.gray[n2] = (byte)n;
                this.alpha[n2] = -1;
                if (n2 != n) {
                    this.isOrdered = false;
                }
            }
            ++n2;
        }
    }

    public boolean canBlend() {
        return true;
    }

    public int getAlpha(int n) {
        return this.alpha[n & 0xFF] & 0xFF;
    }

    public float[] getBlack() {
        float[] fArray = new float[]{0.0f};
        return fArray;
    }

    public PDFColorModel getBlendModel() {
        return DefaultColorModel;
    }

    public int getBlue(int n) {
        return this.gray[n & 0xFF] & 0xFF;
    }

    public int getGreen(int n) {
        return this.gray[n & 0xFF] & 0xFF;
    }

    public ColorModel getJavaColorModel() {
        if (this.javaColorModel == null) {
            this.javaColorModel = new IndexColorModel(8, 256, this.gray, this.gray, this.gray, this.alpha);
        }
        return this.javaColorModel;
    }

    public int getRGB(float f) {
        int n = Math.max(0, Math.min(255, Math.round(255.0f * f)));
        return -16777216 + (n << 16) + (n << 8) + n;
    }

    public int getRGB(int n) {
        int n2 = n & 0xFF;
        int n3 = this.gray[n2] & 0xFF;
        return (this.alpha[n2] << 24) + (n3 << 16) + (n3 << 8) + n3;
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 1) {
            return this.getRGB(fArray[0]);
        }
        throw new RuntimeException("DeviceGrayColorModel.getRGB(c[]) -- arrayToShort");
    }

    public int getRed(int n) {
        return this.gray[n & 0xFF] & 0xFF;
    }

    public void toBlend(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!this.isOrdered) {
            while (n3-- > 0) {
                byArray2[n2++] = this.gray[byArray[n++] & 0xFF];
            }
        } else if (byArray != byArray2 || n != n2) {
            System.arraycopy(byArray, n, byArray2, n2, n3);
        }
    }

    public String toString() {
        return "DeviceGray";
    }
}

