/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class SeparationColorModel
extends PDFColorModel {
    private int map_size;
    private byte[] alpha;
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private ColorModel javaColorModel;

    public SeparationColorModel() {
        this(new PDFColorParams(10));
    }

    public SeparationColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        int n = pDFColorParams.getNumComponents();
        if (n == 1) {
            int n2 = pDFColorParams.getBitsPerComponent();
            float[] fArray = pDFColorParams.getDecode();
            int[] nArray = pDFColorParams.getAlphaMask();
            if (nArray != null && n2 != 8) {
                int n3 = 0;
                while (n3 < 2) {
                    int n4 = n3++;
                    nArray[n4] = nArray[n4] >>> 8 - n2;
                }
            }
            this.map_size = n2 < 8 ? 1 << n2 : 256;
            this.red = MemUtil.allocByte(this.map_size);
            this.green = MemUtil.allocByte(this.map_size);
            this.blue = MemUtil.allocByte(this.map_size);
            this.alpha = MemUtil.allocByte(this.map_size);
            float f = 0.0f;
            float f2 = 1.0f;
            if (fArray != null) {
                f = fArray[0];
                f2 = fArray[1] - fArray[0];
            }
            Function function = pDFColorParams.getTintTransform();
            PDFColorModel pDFColorModel = pDFColorParams.getBaseModel();
            float[] fArray2 = pDFColorModel.getParams().getDecode();
            int n5 = 0;
            while (n5 < this.map_size) {
                float f3;
                if (nArray != null && nArray[0] <= n5 && n5 <= nArray[1]) {
                    this.blue[n5] = 0;
                    this.green[n5] = 0;
                    this.red[n5] = 0;
                    this.alpha[n5] = 0;
                } else if (function != null) {
                    f3 = f + (float)n5 * f2 / (float)(this.map_size - 1);
                    float[] fArray3 = function.value(f3);
                    int n6 = pDFColorModel.getRGB(fArray3);
                    this.alpha[n5] = (byte)(n6 >>> 24);
                    this.red[n5] = (byte)(n6 >>> 16);
                    this.green[n5] = (byte)(n6 >>> 8);
                    this.blue[n5] = (byte)n6;
                } else {
                    f3 = f + (float)n5 * f2 / (float)(this.map_size - 1);
                    int n7 = pDFColorModel.getRGB(f3);
                    this.alpha[n5] = (byte)(n7 >>> 24);
                    this.red[n5] = (byte)(n7 >>> 16);
                    this.green[n5] = (byte)(n7 >>> 8);
                    this.blue[n5] = (byte)n7;
                }
                ++n5;
            }
            if (function != null) {
                function.flush();
            }
        }
    }

    public int getAlpha(int n) {
        int n2 = this.map_size - 1;
        return this.alpha[n & n2] & 0xFF;
    }

    public float[] getBlack() {
        int n = this.params.getNumComponents();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = 1.0f;
            ++n2;
        }
        return fArray;
    }

    public int getBlue(int n) {
        int n2 = this.map_size - 1;
        return this.blue[n & n2] & 0xFF;
    }

    public int getGreen(int n) {
        int n2 = this.map_size - 1;
        return this.green[n & n2] & 0xFF;
    }

    public ColorModel getJavaColorModel() {
        if (this.javaColorModel == null) {
            this.javaColorModel = this.params.getNumComponents() == 1 ? new IndexColorModel(this.params.getBitsPerComponent(), this.map_size, this.red, this.green, this.blue, this.alpha) : ColorModel.getRGBdefault();
        }
        return this.javaColorModel;
    }

    public int getRGB(float f) {
        return this.params.getBaseModel().getRGB(this.params.getTintTransform().value(f));
    }

    public int getRGB(int n) {
        int n2 = n & this.map_size - 1;
        return ((this.alpha[n2] & 0xFF) << 24) + ((this.red[n2] & 0xFF) << 16) + ((this.green[n2] & 0xFF) << 8) + (this.blue[n2] & 0xFF);
    }

    public int getRGB(float[] fArray) {
        return this.params.getBaseModel().getRGB(this.params.getTintTransform().value(fArray));
    }

    public int getRed(int n) {
        int n2 = this.map_size - 1;
        return this.red[n & n2] & 0xFF;
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = this.getNumComponents();
        if (n4 == 1) {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = byArray[n++] & 0xFF;
                nArray[n2++] = ((this.alpha[n6] & 0xFF) << 24) + ((this.red[n6] & 0xFF) << 16) + ((this.green[n6] & 0xFF) << 8) + (this.blue[n6] & 0xFF);
                ++n5;
            }
        } else {
            float[] fArray = new float[n4];
            int[] nArray2 = this.params.getAlphaMask();
            float[] fArray2 = this.params.getDecode();
            Function function = this.params.getTintTransform();
            PDFColorModel pDFColorModel = this.params.getBaseModel();
            if (nArray2 != null) {
                int[] nArray3 = new int[n4];
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = 0;
                    while (n8 < n4) {
                        nArray3[n8] = byArray[n++] & 0xFF;
                        ++n8;
                    }
                    boolean bl = true;
                    int n9 = 0;
                    while (n9 < n4 && bl) {
                        if (nArray2[2 * n9] <= nArray3[n9] && nArray3[n9] <= nArray2[2 * n9 + 1]) {
                            bl = false;
                        }
                        ++n9;
                    }
                    if (bl) {
                        int n10 = 0;
                        while (n10 < n4) {
                            fArray[n10] = (float)((double)(byArray[n++] & 0xFF) / 255.0);
                            if (fArray2 != null) {
                                fArray[n10] = fArray2[2 * n10] + fArray[n10] * (fArray2[2 * n10 + 1] - fArray2[2 * n10]);
                            }
                            ++n10;
                        }
                        nArray[n2++] = function != null ? pDFColorModel.getRGB(function.value(fArray)) : pDFColorModel.getRGB(fArray);
                    } else {
                        nArray[n2++] = 0;
                    }
                    ++n7;
                }
            } else {
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = 0;
                    while (n12 < n4) {
                        fArray[n12] = (float)((double)(byArray[n++] & 0xFF) / 255.0);
                        if (fArray2 != null) {
                            fArray[n12] = fArray2[2 * n12] + fArray[n12] * (fArray2[2 * n12 + 1] - fArray2[2 * n12]);
                        }
                        ++n12;
                    }
                    nArray[n2++] = function != null ? pDFColorModel.getRGB(function.value(fArray)) : pDFColorModel.getRGB(fArray);
                    ++n11;
                }
            }
            if (function != null) {
                function.flush();
            }
        }
    }

    public String toString() {
        return "Separation";
    }
}

