/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.DictEntryNFExc;
import com.adobe.acrobat.pdfobjstore.IndirectObjectNFExc;
import com.adobe.acrobat.pdfobjstore.LinearizerInfo;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFIndirectObj;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjMapEntry;
import com.adobe.acrobat.pdfobjstore.PDFObjMapFreeEntry;
import com.adobe.acrobat.pdfobjstore.PDFObjMapInUseEntry;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.XRefTable;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.util.Assert;
import java.util.Vector;

class PDFObjMap
extends VValue {
    Requester requester;
    private static final String Encrypt_K = "Encrypt";
    static final int kIndirectObjectNotPresent = -1;
    private PDFReference trailerDictRef;
    private int encryptDictID = 0;
    private Vector entries = new Vector();
    private int nInUseEntries;
    private PDFObjStore store;
    private ByteArray ba;

    PDFObjMap(PDFObjStore pDFObjStore, Requester requester) {
        this.requester = requester;
        this.store = pDFObjStore;
    }

    protected final void compute(Requester requester) throws Exception {
        this.ba = this.store.getVByteArray().byteArrayValue(requester);
        LinearizerInfo linearizerInfo = this.store.getVLinearizerInfo().linearizerInfoValue(requester);
        if (linearizerInfo.isLinearized()) {
            XRefTable xRefTable = new XRefTable(this.store, this, linearizerInfo.getXRefStart(), requester);
        } else {
            XRefTable xRefTable = new XRefTable(this.store, this, requester);
        }
        this.computeLengths();
    }

    private void computeLengths() {
        PDFObjMapInUseEntry[] pDFObjMapInUseEntryArray = new PDFObjMapInUseEntry[this.nInUseEntries];
        int n = 0;
        int n2 = 0;
        while (n2 < this.entries.size()) {
            PDFObjMapEntry pDFObjMapEntry = (PDFObjMapEntry)this.entries.elementAt(n2);
            if (pDFObjMapEntry instanceof PDFObjMapInUseEntry) {
                pDFObjMapInUseEntryArray[n++] = (PDFObjMapInUseEntry)pDFObjMapEntry;
            }
            ++n2;
        }
        PDFObjMap.quicksort(pDFObjMapInUseEntryArray, 0, pDFObjMapInUseEntryArray.length - 1);
        n2 = 0;
        while (n2 < this.nInUseEntries - 1) {
            pDFObjMapInUseEntryArray[n2].setLength(pDFObjMapInUseEntryArray[n2 + 1].getOffset() - pDFObjMapInUseEntryArray[n2].getOffset());
            ++n2;
        }
    }

    synchronized void fillFreeEntry(int n, int n2, short s) throws IndirectObjectNFExc {
        this.insureSpaceFor(n);
        PDFObjMapEntry pDFObjMapEntry = this.getEntry(n);
        if (pDFObjMapEntry == null) {
            this.entries.setElementAt(new PDFObjMapFreeEntry(n2, s), n);
            this.notifyAll();
        }
    }

    synchronized void fillInUseEntry(int n, short s, int n2) throws IndirectObjectNFExc {
        this.insureSpaceFor(n);
        PDFObjMapEntry pDFObjMapEntry = this.getEntry(n);
        if (pDFObjMapEntry == null) {
            ++this.nInUseEntries;
            this.entries.setElementAt(new PDFObjMapInUseEntry(n2, n, s), n);
            this.notifyAll();
        }
    }

    private PDFObjMapEntry getEntry(int n) throws IndirectObjectNFExc {
        if (n < 0 || n >= this.entries.size()) {
            return null;
        }
        return (PDFObjMapEntry)this.entries.elementAt(n);
    }

    synchronized int getIndirectObjectLength(int n, short s) throws Exception {
        this.handleRequest(this.requester);
        PDFObjMapEntry pDFObjMapEntry = this.getEntry(n);
        if (pDFObjMapEntry == null) {
            return -1;
        }
        return pDFObjMapEntry.getLength();
    }

    synchronized int getIndirectObjectOffset(int n, short s) throws Exception {
        this.handleRequest(this.requester);
        PDFObjMapEntry pDFObjMapEntry = this.getEntry(n);
        if (pDFObjMapEntry == null) {
            return -1;
        }
        return pDFObjMapEntry.getOffset();
    }

    synchronized PDFReference getTrailerDictRef() throws Exception {
        this.handleRequest(this.requester);
        if (this.trailerDictRef != null) {
            return this.trailerDictRef;
        }
        return null;
    }

    private void insureSpaceFor(int n) {
        if (this.entries.size() <= n) {
            this.entries.setSize(n + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void quicksort(PDFObjMapInUseEntry[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(var1_1 + var2_2) / 2];
            var6_6 = var5_5.getOffset();
            ** GOTO lbl19
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var0[var3_3].getOffset() < var6_6) continue block0;
                    while (var4_4 > var1_1 && var6_6 < var0[var4_4].getOffset()) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    var7_7 = var0[var3_3];
                    var0[var3_3] = var0[var4_4];
                    var0[var4_4] = var7_7;
                    ++var3_3;
                    --var4_4;
lbl19:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                PDFObjMap.quicksort(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                PDFObjMap.quicksort(var0, var3_3, var2_2);
            }
        }
    }

    synchronized void setTrailerRef(PDFReference pDFReference) {
        this.trailerDictRef = pDFReference;
        Assert.notFalse(pDFReference instanceof PDFDirectObj);
        PDFObj pDFObj = ((PDFDirectObj)pDFReference).resolve();
        Assert.notFalse(pDFObj instanceof PDFDict);
        PDFDict pDFDict = (PDFDict)pDFObj;
        if (pDFDict.hasKey(Encrypt_K)) {
            PDFObj pDFObj2;
            try {
                pDFObj2 = pDFDict.get(Encrypt_K);
            }
            catch (DictEntryNFExc dictEntryNFExc) {
                Assert.notFalse(false);
                throw new RuntimeException();
            }
            if (pDFObj2 instanceof PDFIndirectObj) {
                this.encryptDictID = ((PDFIndirectObj)pDFObj2).getID();
            }
        }
        this.notifyAll();
    }

    boolean shouldResistDecryption(int n) throws Exception {
        this.getTrailerDictRef();
        return n == this.encryptDictID;
    }
}

