/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdf.FileSpec;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFFilter;
import com.adobe.acrobat.pdfobjstore.PDFFilteredStreamFactory;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PDFUnfilteredStreamFactory;
import com.adobe.acrobat.pdfobjstore.VFilterRules;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VStreamFactory;
import com.adobe.util.Assert;

class VPDFStreamFactory
extends VStreamFactory {
    private static final String VInlineImageFilteredStreamFactory_K = "VInlineImageFilteredStreamFactory";
    private static final String VInlineImageUnfilteredStreamFactory_K = "VInlineImageUnfilteredStreamFactory";
    private static final String VFilteredStreamFactory_K = "VFilteredStreamFactory";
    private static final String VUnfilteredStreamFactory_K = "VUnfilteredStreamFactory";
    private static ExtensionDataProvider provider = null;
    private static final String Length_K = "Length";
    private static final String F_K = "F";
    private PDFReference pdfRef;
    private VFilterRules filterRules;
    private boolean inlineImage;

    VPDFStreamFactory(PDFReference pDFReference, boolean bl, boolean bl2) {
        this.pdfRef = pDFReference;
        this.inlineImage = bl2;
        this.filterRules = VFilterRules.getVFilterRules(pDFReference, bl, bl2);
    }

    protected StreamFactory computeStreamFactory(Requester requester) throws Exception {
        PDFDict pDFDict = this.pdfRef.dictValue(requester);
        ByteArray byteArray = pDFDict.getByteArray();
        if (byteArray == null) {
            return null;
        }
        int n = pDFDict.getByteArrayOffset();
        PDFFilter[] pDFFilterArray = null;
        if (this.filterRules != null && (pDFFilterArray = this.filterRules.filterRulesValue(requester)) != null && pDFFilterArray.length == 0) {
            pDFFilterArray = null;
        }
        StreamFactory streamFactory = null;
        if (pDFDict.hasKey(F_K)) {
            byteArray = FileSpec.getByteArraySource(pDFDict.get(F_K), this.pdfRef.getObjStore(), requester).getByteArray();
            streamFactory = new PDFUnfilteredStreamFactory(byteArray, 0);
        } else {
            int n2 = pDFDict.get(Length_K).integerValue(requester);
            boolean bl = true;
            streamFactory = new PDFUnfilteredStreamFactory(byteArray, n, n2, bl);
        }
        if (streamFactory != null && pDFFilterArray != null) {
            streamFactory = new PDFFilteredStreamFactory(streamFactory, pDFFilterArray);
        }
        return streamFactory;
    }

    static VStreamFactory getVPDFStreamFactory(PDFReference pDFReference) {
        return VPDFStreamFactory.getVPDFStreamFactory(pDFReference, false, true);
    }

    static VStreamFactory getVPDFStreamFactory(PDFReference pDFReference, boolean bl) {
        return VPDFStreamFactory.getVPDFStreamFactory(pDFReference, bl, true);
    }

    static VStreamFactory getVPDFStreamFactory(PDFReference pDFReference, boolean bl, boolean bl2) {
        VPDFStreamFactory.initProvider();
        if (bl) {
            if (bl2) {
                return (VStreamFactory)pDFReference.getExtensionData(VInlineImageFilteredStreamFactory_K);
            }
            return (VStreamFactory)pDFReference.getExtensionData(VInlineImageUnfilteredStreamFactory_K);
        }
        if (bl2) {
            return (VStreamFactory)pDFReference.getExtensionData(VFilteredStreamFactory_K);
        }
        return (VStreamFactory)pDFReference.getExtensionData(VUnfilteredStreamFactory_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFReference);
                    PDFReference pDFReference = (PDFReference)extensible;
                    boolean bl = string.equals(VPDFStreamFactory.VFilteredStreamFactory_K) || string.equals(VPDFStreamFactory.VInlineImageFilteredStreamFactory_K);
                    boolean bl2 = string.equals(VPDFStreamFactory.VInlineImageFilteredStreamFactory_K) || string.equals(VPDFStreamFactory.VInlineImageUnfilteredStreamFactory_K);
                    return new VPDFStreamFactory(pDFReference, bl, bl2);
                }
            };
            Extension.registerProvider(VInlineImageFilteredStreamFactory_K, provider);
            Extension.registerProvider(VInlineImageUnfilteredStreamFactory_K, provider);
            Extension.registerProvider(VFilteredStreamFactory_K, provider);
            Extension.registerProvider(VUnfilteredStreamFactory_K, provider);
        }
    }
}

