/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.BadXRefTableException;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFInteger;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjMap;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.pe.notify.Requester;
import java.io.InputStream;

class XRefSection {
    static final int kXRefEntrySize = 20;
    private static final String xref_K = "xref";
    private static final String trailer_K = "trailer";
    private static final String Prev_K = "Prev";
    private static final String f_K = "f";
    private static final String n_K = "n";
    PDFReference trailer;
    XRefSection prevSection;

    XRefSection(PDFObjStore pDFObjStore, PDFObjMap pDFObjMap, ByteArray byteArray, int n, boolean bl, Requester requester) throws Exception {
        PDFDict pDFDict;
        InputStream inputStream = byteArray.getByteStream(n);
        Tokenizer tokenizer = new Tokenizer(inputStream);
        try {
            tokenizer.nextToken();
            if (tokenizer.type() != 5 || !tokenizer.literalValue().equals(xref_K)) {
                throw new BadXRefTableException();
            }
            tokenizer.nextToken();
            this.loadMap(tokenizer, pDFObjMap);
            tokenizer.nextToken();
            pDFDict = PDFObj.read(pDFObjStore, tokenizer, byteArray, n, false).dictValue(requester);
        }
        finally {
            Object var11_10 = null;
            tokenizer.close();
        }
        this.trailer = new PDFDirectObj(pDFObjStore, pDFDict);
        if (bl) {
            pDFObjMap.setTrailerRef(this.trailer);
        }
        if (pDFDict.hasKey(Prev_K)) {
            PDFObj pDFObj = pDFDict.get(Prev_K);
            if (pDFObj != null) {
                if (!(pDFObj instanceof PDFInteger)) {
                    throw new BadXRefTableException();
                }
                int n2 = ((PDFInteger)pDFObj).integerValue();
                this.prevSection = new XRefSection(pDFObjStore, pDFObjMap, byteArray, n2, false, requester);
            }
        } else {
            this.prevSection = null;
        }
    }

    private void loadMap(Tokenizer tokenizer, PDFObjMap pDFObjMap) throws Exception {
        while (tokenizer.type() != 5 || !tokenizer.literalValue().equals(trailer_K)) {
            if (tokenizer.type() != 2) {
                throw new BadXRefTableException();
            }
            int n = tokenizer.integerValue();
            tokenizer.nextToken();
            if (tokenizer.type() != 2) {
                throw new BadXRefTableException();
            }
            int n2 = tokenizer.integerValue();
            int n3 = n;
            while (n3 < n + n2) {
                tokenizer.nextToken();
                if (tokenizer.type() != 2) {
                    throw new BadXRefTableException();
                }
                int n4 = tokenizer.integerValue();
                tokenizer.nextToken();
                if (tokenizer.type() != 2) {
                    throw new BadXRefTableException();
                }
                short s = (short)tokenizer.integerValue();
                tokenizer.nextToken();
                if (tokenizer.type() != 5) {
                    throw new BadXRefTableException();
                }
                if (tokenizer.literalValue().equals(f_K)) {
                    pDFObjMap.fillFreeEntry(n3, n4, s);
                } else if (tokenizer.literalValue().equals(n_K)) {
                    pDFObjMap.fillInUseEntry(n3, s, n4);
                } else {
                    throw new BadXRefTableException();
                }
                ++n3;
            }
            tokenizer.nextToken();
        }
    }
}

