/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.CantRebuildXRefException;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFIndirectObj;
import com.adobe.acrobat.pdfobjstore.PDFInteger;
import com.adobe.acrobat.pdfobjstore.PDFName;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjMap;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PDFString;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.WriteLockException;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Vector;

class XRefTableRebuilder {
    private static final String Root_K = "Root";
    private static final String Creator_K = "Creator";
    private static final String Pages_K = "Pages";
    private static final String Parent_K = "Parent";
    private static final String Producer_K = "Producer";
    private static final String obj_K = "obj";
    private static final String endobj_K = "endobj";
    private static final String Type_K = "Type";
    private static final String xref_K = "xref";
    private static final String trailer_K = "trailer";
    private static final String Size_K = "Size";
    private static final String Info_K = "Info";
    private static final String Catalog_K = "Catalog";
    private ByteArray ba;
    private PDFObjStore objStore;
    private PDFObjMap map;
    private int numEntries;
    private Requester requester;
    private Vector roots;
    private Vector infos;
    private Vector trailers;
    PDFReference trailer;

    public XRefTableRebuilder(ByteArray byteArray, PDFObjStore pDFObjStore, PDFObjMap pDFObjMap, Requester requester) throws Exception {
        Log.clog("Rebuilding xref table...");
        this.ba = byteArray;
        this.objStore = pDFObjStore;
        this.map = pDFObjMap;
        this.requester = requester;
        this.roots = new Vector(0);
        this.infos = new Vector(0);
        this.trailers = new Vector(0);
        this.rebuildXRefTable();
        Log.clog("Done rebuilding xref table.");
    }

    private PDFDict buildTrailerDict() throws Exception {
        PDFDict pDFDict;
        if (this.trailers.size() != 0) {
            pDFDict = ((PDFObj)this.trailers.lastElement()).dictValue(this.requester);
        } else {
            PDFIndirectObj pDFIndirectObj = null;
            if (this.roots.size() == 0) {
                throw new CantRebuildXRefException();
            }
            PDFIndirectObj pDFIndirectObj2 = this.guessRootDict();
            if (this.infos.size() != 0) {
                pDFIndirectObj = this.guessInfoDict();
            }
            String[] stringArray = new String[pDFIndirectObj == null ? 2 : 3];
            PDFObj[] pDFObjArray = new PDFObj[pDFIndirectObj == null ? 2 : 3];
            stringArray[0] = Root_K;
            pDFObjArray[0] = pDFIndirectObj2;
            stringArray[1] = Size_K;
            pDFObjArray[1] = new PDFInteger(this.numEntries);
            if (pDFIndirectObj != null) {
                stringArray[2] = Info_K;
                pDFObjArray[2] = pDFIndirectObj;
            }
            pDFDict = new PDFDict(stringArray, pDFObjArray);
        }
        return pDFDict.put(Size_K, new PDFInteger(this.numEntries));
    }

    PDFIndirectObj guessInfoDict() {
        if (this.infos.size() != 0) {
            return (PDFIndirectObj)this.infos.lastElement();
        }
        return null;
    }

    PDFIndirectObj guessRootDict() throws CantRebuildXRefException {
        if (this.roots.size() == 0) {
            throw new CantRebuildXRefException();
        }
        return (PDFIndirectObj)this.roots.lastElement();
    }

    private PDFIndirectObj readObjectForRebuild(Tokenizer tokenizer) throws Exception {
        int n = tokenizer.integerValue();
        tokenizer.nextToken();
        if (tokenizer.type() != 2) {
            return null;
        }
        short s = (short)tokenizer.integerValue();
        tokenizer.nextToken();
        if (tokenizer.type() != 5 || !tokenizer.literalValue().equals(obj_K)) {
            return null;
        }
        tokenizer.nextToken();
        PDFObj pDFObj = PDFObj.read(this.objStore, tokenizer, this.ba, 0, false);
        if (tokenizer.type() == 5 && tokenizer.literalValue().equals(endobj_K)) {
            tokenizer.nextToken();
        }
        PDFIndirectObj pDFIndirectObj = this.objStore.getPDFIndirectObj(n, s);
        if (pDFObj.type(this.requester) == 6) {
            PDFObj pDFObj2;
            PDFDict pDFDict = pDFObj.dictValue(this.requester);
            if (pDFDict.hasKey(Type_K) && (pDFObj2 = pDFDict.get(Type_K)) instanceof PDFName) {
                String string = ((PDFName)pDFObj2).nameValue();
                if (string.equals(Catalog_K)) {
                    this.roots.addElement(pDFIndirectObj);
                } else if (string.equals(Pages_K) && !pDFDict.hasKey(Parent_K)) {
                    this.roots.addElement(pDFIndirectObj);
                }
            }
            if (pDFDict.hasKey(Producer_K) && (pDFObj2 = pDFDict.get(Producer_K)) instanceof PDFString) {
                this.infos.addElement(pDFIndirectObj);
            }
            if (pDFDict.getByteArray() != null) {
                tokenizer.skipEndstream();
            }
        }
        return pDFIndirectObj;
    }

    private void rebuildXRefTable() throws Exception {
        InputStream inputStream = this.ba.getByteStream(0);
        Tokenizer tokenizer = new Tokenizer(inputStream);
        try {
            boolean bl = true;
            do {
                try {
                    PDFObj pDFObj;
                    if (bl) {
                        tokenizer.nextToken();
                        if (tokenizer.type() == 256) break;
                        bl = false;
                    }
                    int n = tokenizer.tokenStart();
                    if (tokenizer.type() == 2) {
                        pDFObj = this.readObjectForRebuild(tokenizer);
                        if (pDFObj == null) continue;
                        int n2 = ((PDFIndirectObj)pDFObj).getID();
                        short s = ((PDFIndirectObj)pDFObj).getGeneration();
                        this.map.fillInUseEntry(n2, s, n);
                        continue;
                    }
                    if (tokenizer.type() == 5) {
                        if (tokenizer.literalValue().equals(xref_K)) {
                            this.skipXRefSection(tokenizer);
                            continue;
                        }
                        if (tokenizer.literalValue().equals(trailer_K)) {
                            tokenizer.nextToken();
                            pDFObj = PDFObj.read(this.objStore, tokenizer, this.ba, 0, false);
                            if (pDFObj.type(this.requester) != 6) continue;
                            this.trailers.addElement(pDFObj);
                            continue;
                        }
                        tokenizer.nextToken();
                        continue;
                    }
                    tokenizer.nextToken();
                }
                catch (WriteLockException writeLockException) {
                    throw writeLockException;
                }
                catch (Exception exception) {
                    tokenizer.skipToToken();
                    try {
                        tokenizer.nextToken();
                    }
                    catch (Exception exception2) {
                        tokenizer.read();
                    }
                }
            } while (tokenizer.type() != 256);
            this.trailer = new PDFDirectObj(this.objStore, this.buildTrailerDict());
        }
        finally {
            Object var4_9 = null;
            tokenizer.close();
        }
    }

    private boolean skipXRefSection(Tokenizer tokenizer) throws Exception {
        try {
            tokenizer.nextToken();
            while (tokenizer.type() != 5 || !tokenizer.literalValue().equals(trailer_K)) {
                if (tokenizer.type() != 2) {
                    return false;
                }
                tokenizer.nextToken();
                if (tokenizer.type() != 2) {
                    return false;
                }
                int n = tokenizer.integerValue();
                tokenizer.skip(n * 20);
                tokenizer.nextToken();
            }
        }
        catch (EOFException eOFException) {
            return false;
        }
        return true;
    }
}

