/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PagedVM
extends InputStream {
    Vector pages;
    int[] offsets;
    int nextOffset;
    static final int pageSize = 4096;
    static final int defFlagsMask = -268435456;
    int flagsMask = -268435456;
    static final byte pvBytes = 1;
    static final byte pvShorts = 2;
    byte dataType;
    Object currPage;
    int elementsOnPage;
    int pageIndex = 0;
    int nextElement = 0;
    int totalElements = 0;
    static int nextVMID = 0;
    int vmID;
    static final boolean debug = false;
    int lastElement;
    int lastPageIndex;
    static int resetCount = 0;
    static Vector shortCache;
    static int nextPage;
    static int allocationCount;
    static int pageAllocCount;

    static {
        allocationCount = 0;
        pageAllocCount = 0;
    }

    public PagedVM(int n, byte by) {
        this.vmID = nextVMID++;
        this.dataType = by;
        this.pages = new Vector(5);
        this.offsets = MemUtil.allocInt(n + 1);
        this.offsets[0] = 0;
        ++this.nextOffset;
        this.pages.addElement(this.allocatePage(4096));
    }

    private PagedVM(PagedVM pagedVM) {
        this.pages = pagedVM.pages;
        this.offsets = pagedVM.offsets;
        this.nextOffset = pagedVM.nextOffset;
        this.flagsMask = pagedVM.flagsMask;
        this.dataType = pagedVM.dataType;
        this.currPage = pagedVM.currPage;
        this.elementsOnPage = pagedVM.elementsOnPage;
        this.pageIndex = pagedVM.pageIndex;
        this.nextElement = pagedVM.nextElement;
        this.totalElements = pagedVM.totalElements;
        this.vmID = nextVMID++;
    }

    public PagedVM(InputStream inputStream) {
        this.vmID = nextVMID++;
        int n = 0;
        this.dataType = 1;
        this.pages = new Vector(5, 10);
        this.offsets = MemUtil.allocInt(500);
        this.offsets[0] = 0;
        ++this.nextOffset;
        this.flagsMask = 0;
        this.pages.addElement((byte[])this.allocatePage(4096));
        boolean bl = false;
        while (!bl) {
            int n2 = this.reserveMemory(4096, 0);
            Object object = this.getStore(n2);
            byte[] byArray = (byte[])object;
            int n3 = 0;
            int n4 = 0;
            do {
                try {
                    n4 = 0;
                    n4 = inputStream.read((byte[])object, n3, 4096 - n3);
                }
                catch (Exception exception) {}
                if (n4 <= 0) continue;
                n3 += n4;
            } while (n4 > 0 && n3 < 4096);
            if (n3 < 4096) {
                bl = true;
            }
            n += n3;
        }
        this.elementsOnPage = this.pageIndex + 1 == this.pages.size() ? this.totalElements % 4096 : 4096;
        this.currPage = this.pages.elementAt(this.pageIndex);
        this.totalElements = n;
    }

    public Object allocatePage(int n) {
        ++allocationCount;
        if (this.dataType == 2) {
            if (nextPage > 0) {
                short[] sArray = (short[])shortCache.elementAt(--nextPage);
                shortCache.setElementAt(null, nextPage);
                return sArray;
            }
            return MemUtil.allocShort(n);
        }
        if (this.dataType == 1) {
            return MemUtil.allocByte(n);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        int n = this.pages.size();
        boolean bl = false;
        super.finalize();
    }

    public int getLastOffsetIndex() {
        return this.nextOffset - 1;
    }

    public int getOffset(int n) {
        return n & 0xFFFF;
    }

    public synchronized PagedVM getSharableVM() {
        PagedVM pagedVM = new PagedVM(this);
        pagedVM.pageIndex = 0;
        pagedVM.nextElement = 0;
        pagedVM.elementsOnPage = pagedVM.pageIndex == this.pages.size() ? this.totalElements % 4096 : 4096;
        pagedVM.currPage = this.pages.elementAt(this.pageIndex);
        pagedVM.lastElement = 0;
        pagedVM.lastPageIndex = 0;
        return pagedVM;
    }

    public Object getStore(int n) {
        return this.pages.elementAt((n & ~this.flagsMask) >> 16);
    }

    public static void initPageCache(int n) {
        int n2 = n / 4096;
        shortCache = new Vector(n2);
        nextPage = n2 - 1;
        int n3 = 0;
        while (n3 < n2) {
            shortCache.addElement(MemUtil.allocShort(4096));
            ++n3;
        }
    }

    public synchronized void mark(int n) {
        this.lastElement = this.nextElement;
        this.lastPageIndex = this.pageIndex;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n;
        if (this.dataType == 2) {
            n = ((short[])this.currPage)[this.nextElement++];
        } else {
            byte[] byArray = (byte[])this.currPage;
            n = ((byte[])this.currPage)[this.nextElement++] & 0xFF;
        }
        if (this.nextElement == this.elementsOnPage) {
            if (this.pageIndex >= this.pages.size() - 1) {
                return -1;
            }
            this.nextElement = 0;
            ++this.pageIndex;
            this.currPage = this.pages.elementAt(this.pageIndex);
            this.elementsOnPage = this.pageIndex == this.pages.size() ? this.totalElements % 4096 : 4096;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        try {
            while (n4 < n2) {
                n3 = this.read();
                if (n3 != -1) {
                    if (byArray != null) {
                        byArray[n + n4] = (byte)n3;
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return n4;
    }

    public int reserveMemory(int n, int n2) {
        if (n > 4096) {
            Log.clog("PageVM memory request too big! " + n + " vs " + 4096 + " max allowed");
            return 0;
        }
        int n3 = this.offsets[this.nextOffset - 1];
        int n4 = n3 >> 16;
        int n5 = n3 & 0xFFFF;
        int n6 = 4096 - n5;
        this.totalElements += n;
        if (this.nextOffset + 1 > this.offsets.length) {
            int[] nArray = MemUtil.allocInt(this.nextOffset + 100);
            System.arraycopy(this.offsets, 0, nArray, 0, this.nextOffset);
            this.offsets = nArray;
        }
        if (n6 < n) {
            ++pageAllocCount;
            this.pages.addElement(this.allocatePage(n > 4096 ? n : 4096));
            this.offsets[this.nextOffset - 1] = this.pages.size() - 1 << 16 | n2;
            this.offsets[this.nextOffset++] = (this.pages.size() - 1 << 16) + n;
            return this.offsets[this.nextOffset - 2];
        }
        if (n5 + n == 4096) {
            n5 = 0;
            this.pages.addElement(this.allocatePage(n > 4096 ? n : 4096));
            int n7 = this.nextOffset - 1;
            this.offsets[n7] = this.offsets[n7] | n2;
            this.offsets[this.nextOffset++] = (++n4 << 16) + n5;
        } else {
            int n8 = this.nextOffset - 1;
            this.offsets[n8] = this.offsets[n8] | n2;
            this.offsets[this.nextOffset++] = (n4 << 16) + n5 + n;
        }
        return this.offsets[this.nextOffset - 2];
    }

    public synchronized void reset() {
        ++resetCount;
        this.nextElement = this.lastElement;
        this.pageIndex = this.lastPageIndex;
        this.currPage = this.pages.elementAt(this.pageIndex);
        this.elementsOnPage = this.pageIndex + 1 == this.pages.size() ? this.totalElements % 4096 : 4096;
    }

    public int setFlags(int n, int n2) {
        this.offsets[n2] = this.offsets[n2] & ~this.flagsMask | n;
        return this.offsets[n2];
    }

    public void setPurgeable(int n) {
        Log.clog("Implement setPurgeable");
    }

    public long skip(long l) throws IOException {
        int n = this.pageIndex * 4096 + this.nextElement + (int)l;
        this.pageIndex = n / 4096;
        this.nextElement = n % 4096;
        this.currPage = this.pages.elementAt(this.pageIndex);
        this.elementsOnPage = this.pageIndex + 1 == this.pages.size() ? this.totalElements % 4096 : 4096;
        return l;
    }
}

