/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.ClipBitsImageFilter;
import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.pdf.image.ExpandBitsImageFilter;
import com.adobe.acrobat.pdf.image.ImageMaskColorModel;
import com.adobe.acrobat.pdf.image.IndexedColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ImageGraphics;
import com.adobe.pe.util.StreamFactory;
import com.adobe.util.MemUtil;
import com.adobe.util.WeakRef;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SidecarImage
extends Image
implements Cloneable,
ImageProducer,
ImageConsumer {
    public static final int STITCH_BAND = 65536;
    private int originX;
    private int originY;
    private int imageWidth;
    private int imageHeight;
    private int imageStatus;
    private Hashtable properties;
    private InputStream inStream;
    private StreamFactory inStreamFac;
    private SidecarImage maskImage;
    private boolean allocatedOwnStream = false;
    private ImageProducer src;
    private ImageProducer expandSrc;
    private PDFColorModel colorModel;
    private ColorModel cm;
    private boolean useJavaColorModel;
    private Vector observers;
    private Vector consumers;
    private int observerFlags;
    private WeakRef pixelStore;
    private int storeOffset;
    private int bitsPerPixel;
    private int pixelScanSize;
    private boolean premultipliedAlpha;
    private boolean stitchBand;

    protected SidecarImage() {
    }

    public SidecarImage(int n, int n2, ColorModel colorModel, StreamFactory streamFactory, SidecarImage sidecarImage) {
        this.imageInit(colorModel);
        this.inStreamFac = streamFactory;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.maskImage = sidecarImage;
        this.properties.put("Source", streamFactory.toString());
    }

    public SidecarImage(int n, int n2, ColorModel colorModel, InputStream inputStream) {
        this.imageInit(colorModel);
        this.inStream = inputStream;
        this.allocatedOwnStream = false;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.properties.put("Source", inputStream.toString());
    }

    public SidecarImage(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4) {
        this(n, n2, colorModel, byArray, n3, n4, (Hashtable)null);
    }

    public SidecarImage(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4, Hashtable hashtable) {
        this.imageInit(colorModel);
        this.imageWidth = n;
        this.imageHeight = n2;
        this.pixelStore.set(byArray);
        this.storeOffset = n3;
        this.pixelScanSize = n4;
        this.setProperties(hashtable);
        this.imageStatus = 3;
        this.observerFlags = 32;
    }

    public SidecarImage(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4) {
        this(n, n2, colorModel, nArray, n3, n4, null);
    }

    public SidecarImage(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.imageInit(colorModel);
        this.imageWidth = n;
        this.imageHeight = n2;
        this.pixelStore.set(nArray);
        this.storeOffset = n3;
        this.pixelScanSize = n4;
        this.setProperties(hashtable);
        this.imageStatus = 3;
        this.observerFlags = 32;
    }

    public SidecarImage(int n, int n2, int[] nArray, int n3, int n4) {
        this(n, n2, (ColorModel)DeviceRGBColorModel.DefaultColorModel, nArray, n3, n4, null);
    }

    public SidecarImage(Image image) {
        this(image.getSource(), null);
    }

    public SidecarImage(Image image, ColorModel colorModel) {
        this(image.getSource(), colorModel);
    }

    public SidecarImage(ImageProducer imageProducer) {
        this(imageProducer, null);
    }

    public SidecarImage(ImageProducer imageProducer, ColorModel colorModel) {
        this.imageInit(colorModel);
        this.src = imageProducer;
        if (imageProducer != null) {
            this.properties.put("Source", imageProducer.toString());
        }
    }

    public SidecarImage Resample(SidecarImage sidecarImage, boolean bl) throws InterruptedException {
        int n;
        PDFColorModel pDFColorModel = sidecarImage.colorModel;
        sidecarImage.startProduction(null);
        if (sidecarImage.imageWidth == 0 || sidecarImage.imageHeight == 0 || !(pDFColorModel instanceof ImageMaskColorModel)) {
            return this;
        }
        Object object = this.getPixels();
        Object object2 = sidecarImage.getPixels();
        if (object instanceof byte[] && !(this.colorModel instanceof ImageMaskColorModel)) {
            this.convertToRGB();
            object = this.getPixels();
        }
        if ((n = sidecarImage.originY - this.originY) > 0) {
            this.imageHeight -= n;
            this.originY += n;
            this.storeOffset += n * this.pixelScanSize;
        }
        if ((n = sidecarImage.originY + sidecarImage.imageHeight - (this.originY + this.imageHeight)) < 0) {
            this.imageHeight += n;
        }
        if ((n = sidecarImage.originX - this.originX) > 0) {
            this.imageWidth -= n;
            this.originX += n;
            this.storeOffset += n;
        }
        if ((n = sidecarImage.originX + sidecarImage.imageWidth - (this.originX + this.imageWidth)) < 0) {
            this.imageWidth += n;
        }
        int n2 = sidecarImage.storeOffset + (this.originY - sidecarImage.originY) * sidecarImage.pixelScanSize;
        int n3 = this.storeOffset;
        byte[] byArray = (byte[])object2;
        n2 += this.originX - sidecarImage.originX;
        if (object instanceof byte[]) {
            byte[] byArray2 = (byte[])object;
            int n4 = 0;
            while (n4 < this.imageHeight) {
                this.checkInterrupt();
                int n5 = 0;
                while (n5 < this.imageWidth) {
                    int n6 = byArray[n2 + n5] & 0xFF;
                    if (n6 == 0) {
                        byArray2[n3 + n5] = 0;
                    } else if (n6 < 255) {
                        int n7 = byArray2[n3 + n5] & 0xFF;
                        n6 = n7 * n6;
                        byArray2[n3 + n5] = (byte)(n6 + (n6 >>> 8) + 1 << 16 >>> 8);
                    }
                    ++n5;
                }
                n3 += this.pixelScanSize;
                n2 += sidecarImage.pixelScanSize;
                ++n4;
            }
        } else {
            int[] nArray = (int[])object;
            int n8 = 0;
            while (n8 < this.imageHeight) {
                this.checkInterrupt();
                int n9 = 0;
                while (n9 < this.imageWidth) {
                    int n10 = byArray[n2 + n9] & 0xFF;
                    if (n10 == 0) {
                        nArray[n3 + n9] = 0;
                    } else if (n10 < 255) {
                        int n11 = nArray[n3 + n9];
                        n10 = (n11 >>> 24) * n10;
                        n10 = n10 + (n10 >>> 8) + 1 << 16 & 0xFF000000;
                        nArray[n3 + n9] = (n11 & 0xFFFFFF) + n10;
                    }
                    ++n9;
                }
                n3 += this.pixelScanSize;
                n2 += sidecarImage.pixelScanSize;
                ++n8;
            }
        }
        return this;
    }

    public SidecarImage Resample8(SidecarImage sidecarImage) throws InterruptedException {
        int n;
        Object object = this.getPixels();
        Object object2 = sidecarImage.getPixels();
        Rectangle rectangle = sidecarImage.getRect();
        Rectangle rectangle2 = this.getRect().intersection(rectangle);
        int n2 = rectangle2.height;
        int n3 = n = rectangle2.width;
        int n4 = 0;
        byte[] byArray = MemUtil.allocByte(n2 * n3);
        byte[] byArray2 = (byte[])object;
        int n5 = this.storeOffset + (rectangle2.y - this.originY) * this.pixelScanSize + (rectangle2.x - this.originX);
        byte[] byArray3 = (byte[])object2;
        int n6 = sidecarImage.storeOffset + (rectangle2.y - sidecarImage.originY) * sidecarImage.pixelScanSize + (rectangle2.x - sidecarImage.originX);
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            while (n8 < n) {
                int n9 = (byArray2[n5 + n8] & 0xFF) * (byArray3[n6 + n8] & 0xFF);
                byArray[n4 + n8] = (byte)(n9 + (n9 >>> 8) + 1 >>> 8);
                ++n8;
            }
            n5 += this.pixelScanSize;
            n6 += sidecarImage.pixelScanSize;
            n4 += n3;
            ++n7;
        }
        SidecarImage sidecarImage2 = new SidecarImage(n, n2, (ColorModel)new ImageMaskColorModel(9), byArray, 0, n3, null);
        sidecarImage2.setOrigin(rectangle2.x, rectangle2.y);
        return sidecarImage2;
    }

    public SidecarImage Rotate(Rectangle rectangle, AffineTransform affineTransform, boolean bl) throws AffineException, InterruptedException {
        SidecarImage sidecarImage;
        block71: {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Object object;
            block70: {
                object = this.getPixels();
                if (this.imageStatus != 3 && this.imageStatus != 2) {
                    return this;
                }
                sidecarImage = (SidecarImage)this.clone();
                sidecarImage.originX = rectangle.x;
                sidecarImage.originY = rectangle.y;
                sidecarImage.imageHeight = rectangle.height;
                sidecarImage.pixelScanSize = sidecarImage.imageWidth = rectangle.width;
                sidecarImage.storeOffset = 0;
                AffineTransform affineTransform2 = affineTransform.getInverse();
                d6 = affineTransform2.geta();
                d5 = affineTransform2.getb();
                d4 = affineTransform2.getc();
                d3 = affineTransform2.getd();
                d2 = d6 * ((double)sidecarImage.originX + 0.5) + d4 * ((double)sidecarImage.originY + 0.5) + affineTransform2.getx();
                d = d5 * ((double)sidecarImage.originX + 0.5) + d3 * ((double)sidecarImage.originY + 0.5) + affineTransform2.gety();
                boolean bl2 = (d5 == 0.0 && d4 == 0.0 || d6 == 0.0 && d3 == 0.0) ^ true;
                double d7 = Math.sqrt(d6 * d6 + d5 * d5);
                double d8 = Math.sqrt(d4 * d4 + d3 * d3);
                if (d7 < 1.25 && d8 < 1.25) {
                    bl = false;
                }
                int n = -1;
                if (object instanceof byte[]) {
                    n = this.getAlpha0(this.colorModel);
                    if (bl2 && n < 0 || bl && !this.colorModel.canBlend()) {
                        this.convertToRGB();
                        object = this.getPixels();
                        sidecarImage.colorModel = this.colorModel;
                    }
                }
                int n2 = 0;
                if (!(object instanceof byte[])) break block70;
                byte[] byArray = (byte[])object;
                byte[] byArray2 = MemUtil.allocByte(sidecarImage.imageHeight * sidecarImage.pixelScanSize);
                sidecarImage.pixelStore.set(byArray2);
                int n3 = 0;
                while (n3 < sidecarImage.imageHeight) {
                    int n4;
                    int n5;
                    int n6;
                    this.checkInterrupt();
                    double d9 = d2;
                    double d10 = d;
                    if (bl) {
                        n6 = 0;
                        while (n6 < sidecarImage.imageWidth) {
                            n5 = (int)d10;
                            n4 = n5 + 1;
                            if (n4 < this.originY || n5 >= this.originY + this.imageHeight) {
                                byArray2[n2++] = (byte)n;
                                d9 += d6;
                                d10 += d5;
                            } else {
                                int n7 = (int)((d10 - (double)n5) * 256.0);
                                int n8 = 256 - n7;
                                if (n5 < this.originY) {
                                    n5 = n4;
                                } else if (n4 >= this.originY + this.imageHeight) {
                                    n4 = n5;
                                }
                                n5 = this.storeOffset + (n5 - this.originY) * this.pixelScanSize - this.originX;
                                n4 = this.storeOffset + (n4 - this.originY) * this.pixelScanSize - this.originX;
                                int n9 = (int)d9;
                                int n10 = n9 + 1;
                                if (n10 < this.originX || n9 >= this.originX + this.imageWidth) {
                                    byArray2[n2++] = (byte)n;
                                    d9 += d6;
                                    d10 += d5;
                                } else {
                                    int n11 = (int)((d9 - (double)n9) * 256.0);
                                    int n12 = 256 - n11;
                                    if (n9 < this.originX) {
                                        n9 = n10;
                                    } else if (n10 >= this.originX + this.imageWidth) {
                                        n10 = n9;
                                    }
                                    int n13 = (byArray[n5 + n9] & 0xFF) * n12 + (byArray[n5 + n10] & 0xFF) * n11;
                                    int n14 = (byArray[n4 + n9] & 0xFF) * n12 + (byArray[n4 + n10] & 0xFF) * n11;
                                    byArray2[n2++] = (byte)(n13 * n8 + n14 * n7 >>> 16);
                                    d9 += d6;
                                    d10 += d5;
                                }
                            }
                            ++n6;
                        }
                    } else if (d5 == 0.0) {
                        n6 = (int)Math.round(d10);
                        if (n6 == this.originY - 1) {
                            n6 = this.originY;
                        } else if (n6 == this.originY + this.imageHeight) {
                            n6 = this.originX + this.imageHeight - 1;
                        }
                        if (n6 >= this.originY && n6 < this.originY + this.imageHeight) {
                            n6 = this.storeOffset + (n6 - this.originY) * this.pixelScanSize - this.originX;
                            n5 = 0;
                            while (n5 < sidecarImage.imageWidth) {
                                n4 = (int)Math.round(d9);
                                if (n4 == this.originX - 1) {
                                    n4 = this.originX;
                                } else if (n4 == this.originX + this.imageWidth) {
                                    n4 = this.originX + this.imageWidth - 1;
                                }
                                byArray2[n2++] = n4 >= this.originX && n4 < this.originX + this.imageWidth ? byArray[n6 + n4] : (byte)n;
                                d9 += d6;
                                ++n5;
                            }
                        }
                    } else {
                        n6 = 0;
                        while (n6 < sidecarImage.imageWidth) {
                            n5 = (int)Math.round(d9);
                            n4 = (int)Math.round(d10);
                            if (n5 == this.originX - 1) {
                                n5 = this.originX;
                            } else if (n5 == this.originX + this.imageWidth) {
                                n5 = this.originX + this.imageWidth - 1;
                            }
                            if (n4 == this.originY - 1) {
                                n4 = this.originY;
                            } else if (n4 == this.originY + this.imageHeight) {
                                n4 = this.originX + this.imageHeight - 1;
                            }
                            byArray2[n2++] = n5 >= this.originX && n5 < this.originX + this.imageWidth && n4 >= this.originY && n4 < this.originY + this.imageHeight ? byArray[this.storeOffset + (n4 - this.originY) * this.pixelScanSize + (n5 - this.originX)] : (byte)n;
                            d9 += d6;
                            d10 += d5;
                            ++n6;
                        }
                    }
                    d2 += d4;
                    d += d3;
                    ++n3;
                }
                break block71;
            }
            if (!(object instanceof int[])) break block71;
            int[] nArray = (int[])object;
            int[] nArray2 = MemUtil.allocInt(sidecarImage.imageHeight * sidecarImage.pixelScanSize);
            sidecarImage.pixelStore.set(nArray2);
            int n = 0;
            while (n < sidecarImage.imageHeight) {
                int n15;
                int n16;
                int n17;
                this.checkInterrupt();
                double d11 = d2;
                double d12 = d;
                if (bl) {
                    n17 = 0;
                    while (n17 < sidecarImage.imageWidth) {
                        n16 = (int)d12;
                        n15 = n16 + 1;
                        if (n15 < this.originY || n16 >= this.originY + this.imageHeight) {
                            nArray2[n2++] = 0;
                            d11 += d6;
                            d12 += d5;
                        } else {
                            int n18 = (int)((d12 - (double)n16) * 256.0);
                            int n19 = 256 - n18;
                            if (n16 < this.originY) {
                                n16 = n15;
                            } else if (n15 >= this.originY + this.imageHeight) {
                                n15 = n16;
                            }
                            n16 = this.storeOffset + (n16 - this.originY) * this.pixelScanSize - this.originX;
                            n15 = this.storeOffset + (n15 - this.originY) * this.pixelScanSize - this.originX;
                            int n20 = (int)d11;
                            int n21 = n20 + 1;
                            if (n21 < this.originX || n20 >= this.originX + this.imageWidth) {
                                nArray2[n2++] = 0;
                                d11 += d6;
                                d12 += d5;
                            } else {
                                int n22;
                                int n23;
                                int n24;
                                int n25 = (int)((d11 - (double)n20) * 256.0);
                                int n26 = 256 - n25;
                                if (n20 < this.originX) {
                                    n20 = n21;
                                } else if (n21 >= this.originX + this.imageWidth) {
                                    n21 = n20;
                                }
                                int n27 = nArray[n16 + n20];
                                int n28 = nArray[n16 + n21];
                                int n29 = nArray[n15 + n20];
                                int n30 = nArray[n15 + n21];
                                int n31 = (n27 >>> 24) * n26 + (n28 >>> 24) * n25;
                                int n32 = (n29 >>> 24) * n26 + (n30 >>> 24) * n25;
                                int n33 = n31 * n19 + n32 * n18 >>> 16;
                                if (n33 == 255) {
                                    n31 = (n27 >>> 16 & 0xFF) * n26 + (n28 >>> 16 & 0xFF) * n25;
                                    n32 = (n29 >>> 16 & 0xFF) * n26 + (n30 >>> 16 & 0xFF) * n25;
                                    n24 = n31 * n19 + n32 * n18 >>> 16;
                                    n31 = (n27 >>> 8 & 0xFF) * n26 + (n28 >>> 8 & 0xFF) * n25;
                                    n32 = (n29 >>> 8 & 0xFF) * n26 + (n30 >>> 8 & 0xFF) * n25;
                                    n23 = n31 * n19 + n32 * n18 >>> 16;
                                    n31 = (n27 & 0xFF) * n26 + (n28 & 0xFF) * n25;
                                    n32 = (n29 & 0xFF) * n26 + (n30 & 0xFF) * n25;
                                    n22 = n31 * n19 + n32 * n18 >>> 16;
                                } else if (n33 != 0) {
                                    int n34 = n27 >>> 24;
                                    int n35 = n28 >>> 24;
                                    int n36 = n29 >>> 24;
                                    int n37 = n30 >>> 24;
                                    int n38 = n34 + n35 + n36 + n37;
                                    n31 = (n27 >>> 16 & 0xFF) * n26 * n34 + (n28 >>> 16 & 0xFF) * n25 * n35;
                                    n32 = (n29 >>> 16 & 0xFF) * n26 * n36 + (n30 >>> 16 & 0xFF) * n25 * n37;
                                    n24 = (n31 * n19 + n32 * n18 >>> 16) / n38;
                                    n31 = (n27 >>> 8 & 0xFF) * n26 * n34 + (n28 >>> 8 & 0xFF) * n25 * n35;
                                    n32 = (n29 >>> 8 & 0xFF) * n26 * n36 + (n30 >>> 8 & 0xFF) * n25 * n37;
                                    n23 = (n31 * n19 + n32 * n18 >>> 16) / n38;
                                    n31 = (n27 & 0xFF) * n26 * n34 + (n28 & 0xFF) * n25 * n35;
                                    n32 = (n29 & 0xFF) * n26 * n36 + (n30 & 0xFF) * n25 * n37;
                                    n22 = (n31 * n19 + n32 * n18 >>> 16) / n38;
                                } else {
                                    n22 = 0;
                                    n23 = 0;
                                    n24 = 0;
                                }
                                nArray2[n2++] = (n33 << 24) + (n24 << 16) + (n23 << 8) + n22;
                                d11 += d6;
                                d12 += d5;
                            }
                        }
                        ++n17;
                    }
                } else if (d5 == 0.0) {
                    n17 = (int)Math.round(d12);
                    if (n17 == this.originY - 1) {
                        n17 = this.originY;
                    } else if (n17 == this.originY + this.imageHeight) {
                        n17 = this.originX + this.imageHeight - 1;
                    }
                    if (n17 >= this.originY && n17 < this.originY + this.imageHeight) {
                        n17 = this.storeOffset + (n17 - this.originY) * this.pixelScanSize - this.originX;
                        n16 = 0;
                        while (n16 < sidecarImage.imageWidth) {
                            n15 = (int)Math.round(d11);
                            if (n15 == this.originX - 1) {
                                n15 = this.originX;
                            } else if (n15 == this.originX + this.imageWidth) {
                                n15 = this.originX + this.imageWidth - 1;
                            }
                            nArray2[n2++] = n15 >= this.originX && n15 < this.originX + this.imageWidth ? nArray[n17 + n15] : 0;
                            d11 += d6;
                            ++n16;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < sidecarImage.imageWidth) {
                        n16 = (int)Math.round(d11);
                        n15 = (int)Math.round(d12);
                        if (n16 == this.originX - 1) {
                            n16 = this.originX;
                        } else if (n16 == this.originX + this.imageWidth) {
                            n16 = this.originX + this.imageWidth - 1;
                        }
                        if (n15 == this.originY - 1) {
                            n15 = this.originY;
                        } else if (n15 == this.originY + this.imageHeight) {
                            n15 = this.originX + this.imageHeight - 1;
                        }
                        nArray2[n2++] = n16 >= this.originX && n16 < this.originX + this.imageWidth && n15 >= this.originY && n15 < this.originY + this.imageHeight ? nArray[this.storeOffset + (n15 - this.originY) * this.pixelScanSize + (n16 - this.originX)] : 0;
                        d11 += d6;
                        d12 += d5;
                        ++n17;
                    }
                }
                d2 += d4;
                d += d3;
                ++n;
            }
        }
        return sidecarImage;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != null && this.consumers.indexOf(imageConsumer) < 0) {
            this.consumers.addElement(imageConsumer);
        }
    }

    private synchronized void addObserver(ImageObserver imageObserver, int n) {
        if (imageObserver != null) {
            SidecarImageObserverState sidecarImageObserverState = this.getObserverState(imageObserver);
            if (sidecarImageObserverState == null) {
                sidecarImageObserverState = new SidecarImageObserverState(imageObserver, n);
                this.observers.addElement(sidecarImageObserverState);
            }
            sidecarImageObserverState.dataWanted |= n;
        }
    }

    public void applyImageMask(SidecarImage sidecarImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Object[] objectArray;
        this.convertToRGB();
        Object object = this.getPixels();
        Object object2 = sidecarImage.getPixels();
        int[] nArray = (int[])object;
        int n13 = this.storeOffset;
        int n14 = sidecarImage.storeOffset;
        if (object2 instanceof byte[]) {
            objectArray = (byte[])object2;
            PDFColorModel pDFColorModel = sidecarImage.getColorModel();
            n12 = pDFColorModel.getRGB(0) | 0xFF000000;
            n11 = pDFColorModel.getRed(0);
            n10 = pDFColorModel.getGreen(0);
            n9 = pDFColorModel.getBlue(0);
            n8 = 0;
            while (n8 < this.imageHeight) {
                n7 = 0;
                while (n7 < this.imageWidth) {
                    n6 = objectArray[n14 + n7] & 0xFF;
                    if (n6 == 255) {
                        nArray[n13 + n7] = n12;
                    } else if (n6 > 0) {
                        n5 = nArray[n13 + n7];
                        n4 = n5 >> 16 & 0xFF;
                        n3 = n5 >> 8 & 0xFF;
                        n2 = n5 & 0xFF;
                        n = 255 - n6;
                        n4 = n4 * n + n11 * n6;
                        n4 = n4 + (n4 >>> 8) + 1;
                        n3 = n3 * n + n10 * n6;
                        n3 = n3 + (n3 >>> 8) + 1;
                        n2 = n2 * n + n9 * n6;
                        n2 = n2 + (n2 >>> 8) + 1;
                        nArray[n13 + n7] = -16777216 + (n4 << 8 & 0xFF0000) + (n3 & 0xFF00) + (n2 >> 8);
                    }
                    ++n7;
                }
                n13 += this.pixelScanSize;
                n14 += sidecarImage.pixelScanSize;
                ++n8;
            }
        }
        if (object2 instanceof int[]) {
            objectArray = (int[])object2;
            boolean bl = sidecarImage.premultipliedAlpha;
            n12 = 0;
            while (n12 < this.imageHeight) {
                n11 = 0;
                while (n11 < this.imageWidth) {
                    n10 = objectArray[n14 + n11];
                    n9 = n10 >>> 24;
                    if (n9 == 255) {
                        nArray[n13 + n11] = n10;
                    } else if (n9 > 0) {
                        if (!bl) {
                            n8 = n10 >> 16 & 0xFF;
                            n8 *= n9;
                            n8 = n8 + (n8 >>> 8) + 1;
                            n7 = n10 >> 8 & 0xFF;
                            n7 *= n9;
                            n7 = n7 + (n7 >>> 8) + 1;
                            n6 = n10 & 0xFF;
                            n6 *= n9;
                            n6 = n6 + (n6 >>> 8) + 1;
                        } else {
                            n8 = n10 >> 8 & 0xFF00;
                            n7 = n10 & 0xFF00;
                            n6 = n10 << 8 & 0xFF00;
                        }
                        n5 = nArray[n13 + n11];
                        n4 = n5 >> 16 & 0xFF;
                        n3 = n5 >> 8 & 0xFF;
                        n2 = n5 & 0xFF;
                        n = 255 - n9;
                        n4 *= n;
                        n4 = n8 + n4 + (n4 >>> 8) + 1;
                        n3 *= n;
                        n3 = n7 + n3 + (n3 >>> 8) + 1;
                        n2 *= n;
                        n2 = n6 + n2 + (n2 >>> 8) + 1;
                        nArray[n13 + n11] = -16777216 + (n4 << 8 & 0xFF0000) + (n3 & 0xFF00) + (n2 >> 8 & 0xFF);
                    }
                    ++n11;
                }
                n13 += this.pixelScanSize;
                n14 += sidecarImage.pixelScanSize;
                ++n12;
            }
        }
    }

    public void applyOpacity(double d) {
        int n = (int)Math.round(255.0 * d);
        if (n < 255) {
            if (n <= 0) {
                this.erase();
            } else {
                this.convertToRGB();
                Object object = this.getPixels();
                int[] nArray = MemUtil.allocInt(256);
                int n2 = 0;
                while (n2 < 256) {
                    nArray[n2] = (int)Math.round((double)n2 * d);
                    ++n2;
                }
                int[] nArray2 = (int[])object;
                int n3 = this.storeOffset;
                int n4 = 0;
                while (n4 < this.imageHeight) {
                    int n5 = 0;
                    while (n5 < this.imageWidth) {
                        int n6 = nArray2[n3 + n5];
                        if (!this.premultipliedAlpha) {
                            nArray2[n3 + n5] = (nArray[n6 >>> 24] << 24) + (n6 & 0xFFFFFF);
                        } else {
                            int n7 = n6 >>> 24;
                            int n8 = n6 >> 16 & 0xFF;
                            int n9 = n6 >> 8 & 0xFF;
                            int n10 = n6 & 0xFF;
                            nArray2[n3 + n5] = (nArray[n7] << 24) + (nArray[n8] << 16) + (nArray[n9] << 8) + nArray[n10];
                        }
                        ++n5;
                    }
                    n3 += this.pixelScanSize;
                    ++n4;
                }
            }
        }
    }

    public boolean checkAntiAlias() {
        block10: {
            Object object;
            int n;
            block9: {
                int n2;
                n = this.storeOffset;
                object = this.getPixels();
                if (!(object instanceof byte[])) break block9;
                byte[] byArray = (byte[])object;
                int[] nArray = MemUtil.allocInt(256);
                boolean bl = false;
                int n3 = 0;
                while (n3 < 256) {
                    nArray[n3] = this.colorModel.getAlpha(n3);
                    n2 = nArray[n3];
                    if (n2 != 255 && n2 != 0) {
                        bl = true;
                    }
                    ++n3;
                }
                if (!bl) {
                    return false;
                }
                n3 = 0;
                while (n3 < this.imageHeight) {
                    int n4 = 0;
                    while (n4 < this.imageWidth) {
                        if ((n2 = nArray[byArray[n++] & 0xFF]) != 255 && n2 != 0) {
                            return true;
                        }
                        ++n4;
                    }
                    n += this.pixelScanSize - this.imageWidth;
                    ++n3;
                }
                break block10;
            }
            if (!(object instanceof int[])) break block10;
            int[] nArray = (int[])object;
            int n5 = 0;
            while (n5 < this.imageHeight) {
                int n6 = 0;
                while (n6 < this.imageWidth) {
                    int n7;
                    if ((n7 = nArray[n++] >>> 24) != 255 && n7 != 0) {
                        return true;
                    }
                    ++n6;
                }
                n += this.pixelScanSize - this.imageWidth;
                ++n5;
            }
        }
        return false;
    }

    private boolean checkColorModel(ColorModel colorModel) {
        DirectColorModel directColorModel;
        if (colorModel == DeviceRGBColorModel.DefaultColorModel) {
            return true;
        }
        return colorModel instanceof DirectColorModel && (directColorModel = (DirectColorModel)colorModel).getAlphaMask() == -16777216 && directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255;
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static SidecarImage clipFromImage(Image image) {
        SidecarImage sidecarImage = new SidecarImage(new FilteredImageSource(image.getSource(), ClipBitsImageFilter.theFilter));
        sidecarImage.startProduction(null);
        if (image instanceof SidecarImage) {
            sidecarImage.setOrigin(((SidecarImage)image).getOrigin());
        }
        image.flush();
        return sidecarImage;
    }

    public static SidecarImage clipFromImage(Image image, int n, int n2, int n3, int n4) {
        CropImageFilter cropImageFilter = new CropImageFilter(n, n2, n3, n4);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
        SidecarImage sidecarImage = new SidecarImage(new FilteredImageSource(filteredImageSource, ClipBitsImageFilter.theFilter));
        sidecarImage.startProduction(null);
        image.flush();
        return sidecarImage;
    }

    public Object clone() {
        SidecarImage sidecarImage = null;
        this.startProduction(null);
        if (this.expandSrc != null && this.expandSrc != this) {
            sidecarImage = new SidecarImage(this.expandSrc);
        } else {
            sidecarImage = new SidecarImage();
            sidecarImage.originX = this.originX;
            sidecarImage.originY = this.originY;
            sidecarImage.imageWidth = this.imageWidth;
            sidecarImage.imageHeight = this.imageHeight;
            sidecarImage.properties = new Hashtable(11);
            sidecarImage.setProperties(this.properties);
            sidecarImage.observers = new Vector(0, 1);
            sidecarImage.consumers = new Vector(0, 1);
            sidecarImage.observerFlags = this.observerFlags;
            sidecarImage.imageStatus = this.imageStatus;
            sidecarImage.inStream = null;
            sidecarImage.inStreamFac = null;
            sidecarImage.src = null;
            sidecarImage.maskImage = this.maskImage;
            sidecarImage.pixelStore = new WeakRef(this.getPixels());
            sidecarImage.storeOffset = this.storeOffset;
            sidecarImage.bitsPerPixel = this.bitsPerPixel;
            sidecarImage.pixelScanSize = this.pixelScanSize;
            sidecarImage.premultipliedAlpha = this.premultipliedAlpha;
            sidecarImage.stitchBand = this.stitchBand;
            if (this.colorModel != null) {
                sidecarImage.initColorModel(this.colorModel);
            } else if (this.cm != null) {
                sidecarImage.initColorModel(this.cm);
            }
            sidecarImage.sendJavaColorModel(this.useJavaColorModel);
        }
        return sidecarImage;
    }

    private void convertToRGB() {
        Object object = this.getPixels();
        if (object instanceof byte[]) {
            int n = this.storeOffset;
            int n2 = 0;
            byte[] byArray = (byte[])object;
            int[] nArray = MemUtil.allocInt(this.imageHeight * this.imageWidth);
            int[] nArray2 = MemUtil.allocInt(256);
            int n3 = 0;
            while (n3 < 256) {
                nArray2[n3] = this.colorModel.getRGB(n3);
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.imageHeight) {
                int n5 = 0;
                while (n5 < this.imageWidth) {
                    nArray[n2++] = nArray2[byArray[n + n5] & 0xFF];
                    ++n5;
                }
                n += this.pixelScanSize;
                ++n4;
            }
            this.src = null;
            this.inStreamFac = null;
            this.pixelScanSize = this.imageWidth;
            this.storeOffset = 0;
            this.bitsPerPixel = 32;
            this.pixelStore.set(nArray);
            this.colorModel = DeviceRGBColorModel.DefaultColorModel;
        }
    }

    public synchronized void erase() {
        Object object = this.pixelStore.get();
        if (object == null && this.imageWidth > 0 && this.imageHeight > 0) {
            if (this.colorModel == null) {
                this.setColorModel(DeviceRGBColorModel.DefaultColorModel);
            }
            if (this.bitsPerPixel <= 8) {
                this.pixelScanSize = this.imageWidth * this.bitsPerPixel + 7 >>> 3;
                object = MemUtil.allocByte(this.pixelScanSize * this.imageHeight);
            } else {
                this.pixelScanSize = this.imageWidth;
                object = MemUtil.allocInt(this.pixelScanSize * this.imageHeight);
            }
            this.pixelStore.set(object);
        }
        if (object != null) {
            if (object instanceof byte[]) {
                int n = Math.max(0, this.getAlpha0(this.colorModel));
                MemUtil.arraySet(object, new Byte((byte)n));
            } else if (object instanceof int[]) {
                MemUtil.arraySet(object, new Integer(0));
            }
        }
        this.src = null;
        this.inStreamFac = null;
    }

    public void flush() {
        boolean bl = this.src != null || this.inStreamFac != null;
    }

    private int getAlpha0(PDFColorModel pDFColorModel) {
        int n = -1;
        int n2 = 0;
        while (n2 < 256) {
            if (pDFColorModel.getAlpha(n2) == 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public PDFColorModel getColorModel() {
        return this.colorModel;
    }

    public Graphics getGraphics() {
        return new ImageGraphics(this);
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getHeight(ImageObserver imageObserver) {
        if (this.imageHeight == -1) {
            this.addObserver(imageObserver, 2);
        }
        return this.imageHeight;
    }

    public SidecarImage getMaskImage() {
        return this.maskImage;
    }

    private SidecarImageObserverState getObserverState(ImageObserver imageObserver) {
        int n = this.observers.size();
        while (n-- > 0) {
            try {
                SidecarImageObserverState sidecarImageObserverState = (SidecarImageObserverState)this.observers.elementAt(n);
                if (sidecarImageObserverState.io != imageObserver) continue;
                return sidecarImageObserverState;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return null;
    }

    public Point getOrigin() {
        return new Point(this.originX, this.originY);
    }

    public int getPixelOffset() {
        return this.storeOffset;
    }

    public int getPixelSize() {
        return this.bitsPerPixel;
    }

    protected Object getPixels() {
        Object object = this.pixelStore.get();
        if (object == null) {
            this.startProduction(null);
            object = this.pixelStore.get();
        }
        return object;
    }

    protected boolean getPremultipliedAlpha() {
        return this.premultipliedAlpha;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        Object object;
        if (this.properties == null || (object = this.properties.get(string)) == null) {
            this.addObserver(imageObserver, 4);
            object = Image.UndefinedProperty;
        }
        return object;
    }

    public Rectangle getRect() {
        return new Rectangle(this.originX, this.originY, this.imageWidth, this.imageHeight);
    }

    public int getScanSize() {
        return this.pixelScanSize;
    }

    public ImageProducer getSource() {
        return this.expandSrc;
    }

    public int getStatus(ImageObserver imageObserver) {
        if (this.imageStatus == 0) {
            this.addObserver(imageObserver, 24);
        }
        return this.imageStatus;
    }

    public boolean getStitchBand() {
        return this.stitchBand;
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getWidth(ImageObserver imageObserver) {
        if (this.imageWidth == -1) {
            this.addObserver(imageObserver, 1);
        }
        return this.imageWidth;
    }

    public synchronized void imageComplete(int n) {
        this.imageStatus = n;
        switch (this.imageStatus) {
            case 1: {
                this.observerFlags |= 0x40;
                break;
            }
            case 2: {
                this.observerFlags |= 0x10;
                break;
            }
            case 3: {
                this.observerFlags |= 0x20;
                break;
            }
            case 4: {
                this.observerFlags |= 0x80;
                break;
            }
        }
        if (this.imageStatus != 0) {
            this.src.removeConsumer(this);
        }
        this.notifyAll();
    }

    private void imageInit(ColorModel colorModel) {
        this.originY = 0;
        this.originX = 0;
        this.imageHeight = -1;
        this.imageWidth = -1;
        this.imageStatus = 0;
        this.observerFlags = 0;
        this.properties = new Hashtable(11);
        this.inStream = null;
        this.inStreamFac = null;
        this.maskImage = null;
        this.src = null;
        this.observers = new Vector(0, 1);
        this.consumers = new Vector(0, 1);
        this.pixelStore = new WeakRef();
        this.premultipliedAlpha = false;
        this.stitchBand = false;
        this.storeOffset = 0;
        this.colorModel = null;
        this.cm = null;
        this.initColorModel(colorModel);
    }

    private void initColorModel(ColorModel colorModel) {
        if (this.colorModel == null) {
            if (colorModel != null) {
                if (colorModel instanceof PDFColorModel) {
                    this.colorModel = (PDFColorModel)colorModel;
                    this.cm = null;
                } else if (colorModel instanceof IndexColorModel) {
                    this.cm = colorModel;
                    this.colorModel = IndexedColorModel.fromJavaColorModel(colorModel);
                } else {
                    this.cm = colorModel;
                    this.colorModel = DeviceRGBColorModel.DefaultColorModel;
                }
                this.premultipliedAlpha = this.colorModel.getAlphaPremultiplied();
                this.expandSrc = this.colorModel.addExpandFilter(this);
                this.properties.put("ColorModel", this.colorModel.toString());
                this.bitsPerPixel = this.colorModel.getPDFColorModelComponentSize();
                if (this.colorModel.getNumComponents() > 1) {
                    this.bitsPerPixel = 32;
                }
            } else {
                this.expandSrc = this;
            }
        }
    }

    public void insertTile(SidecarImage sidecarImage, int n, int n2) {
        block11: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            Object object;
            Object object2;
            block12: {
                object2 = this.getPixels();
                object = sidecarImage.getPixels();
                n8 = sidecarImage.imageWidth;
                n7 = sidecarImage.imageHeight;
                n6 = sidecarImage.storeOffset;
                n5 = sidecarImage.pixelScanSize;
                int n9 = this.storeOffset;
                if (n >= this.originX + this.imageWidth || n2 >= this.originY + this.imageHeight || n + n8 <= this.originX || n2 + n7 <= this.originY) {
                    return;
                }
                if ((n -= this.originX) < 0) {
                    n6 -= n;
                    n8 += n;
                    n = 0;
                }
                n9 += n;
                n4 = this.imageWidth - (n + n8);
                if (n4 < 0) {
                    n8 += n4;
                }
                if ((n2 -= this.originY) < 0) {
                    n6 -= n2 * n5;
                    n7 += n2;
                    n2 = 0;
                }
                n9 += n2 * this.pixelScanSize;
                n3 = this.imageHeight - (n2 + n7);
                if (n3 < 0) {
                    n7 += n3;
                }
                this.premultipliedAlpha = sidecarImage.premultipliedAlpha;
                if (object2 == null) break block11;
                if (!(object2 instanceof byte[])) break block12;
                byte[] byArray = (byte[])object2;
                byte[] byArray2 = (byte[])object;
                int n10 = this.getAlpha0(this.colorModel);
                n3 = 0;
                while (n3 < n7) {
                    n4 = 0;
                    while (n4 < n8) {
                        byte by = byArray2[n6 + n4];
                        if (n10 != (by & 0xFF)) {
                            byArray[n9 + n4] = by;
                        }
                        ++n4;
                    }
                    n6 += n5;
                    n9 += this.pixelScanSize;
                    ++n3;
                }
                break block11;
            }
            if (!(object2 instanceof int[])) break block11;
            int[] nArray = (int[])object2;
            int[] nArray2 = (int[])object;
            n3 = 0;
            while (n3 < n7) {
                n4 = 0;
                while (n4 < n8) {
                    int n11 = nArray2[n6 + n4];
                    if (n11 != 0) {
                        nArray[n9 + n4] = n11;
                    }
                    ++n4;
                }
                n6 += n5;
                n9 += this.pixelScanSize;
                ++n3;
            }
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer != null && this.consumers.indexOf(imageConsumer) >= 0;
    }

    public void mergeMask(SidecarImage sidecarImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        this.convertToRGB();
        Object object = this.getPixels();
        Object object2 = sidecarImage.getPixels();
        int[] nArray = (int[])object;
        int n6 = this.storeOffset;
        int n7 = sidecarImage.storeOffset;
        if (object2 instanceof byte[]) {
            objectArray = (byte[])object2;
            PDFColorModel pDFColorModel = sidecarImage.getColorModel();
            n5 = 0;
            while (n5 < this.imageHeight) {
                n4 = 0;
                while (n4 < this.imageWidth) {
                    n3 = objectArray[n7 + n4] & 0xFF;
                    if (n3 == 0) {
                        nArray[n6 + n4] = 0;
                    } else if (n3 < 255) {
                        n2 = nArray[n6 + n4];
                        n = (n2 >>> 24) * n3;
                        n = n * (n >>> 8) + 1;
                        nArray[n6 + n4] = (n << 16 & 0xFF000000) + (n2 & 0xFFFFFF);
                    }
                    ++n4;
                }
                n6 += this.pixelScanSize;
                n7 += sidecarImage.pixelScanSize;
                ++n5;
            }
        }
        if (object2 instanceof int[]) {
            objectArray = (int[])object2;
            boolean bl = sidecarImage.premultipliedAlpha;
            n5 = 0;
            while (n5 < this.imageHeight) {
                n4 = 0;
                while (n4 < this.imageWidth) {
                    n3 = objectArray[n7 + n4] >>> 24;
                    if (n3 == 0) {
                        nArray[n6 + n4] = 0;
                    } else if (n3 < 255) {
                        n2 = nArray[n6 + n4];
                        n = (n2 >>> 24) * n3;
                        n = n * (n >>> 8) + 1;
                        nArray[n6 + n4] = (n << 16 & 0xFF000000) + (n2 & 0xFFFFFF);
                    }
                    ++n4;
                }
                n6 += this.pixelScanSize;
                n7 += sidecarImage.pixelScanSize;
                ++n5;
            }
        }
    }

    private void produce(ImageConsumer imageConsumer) {
        Object object = this.getPixels();
        ColorModel colorModel = this.colorModel;
        if (this.useJavaColorModel) {
            if (this.cm == null) {
                this.cm = this.colorModel.getJavaColorModel();
            }
            colorModel = this.cm;
        } else if (object instanceof int[]) {
            colorModel = DeviceRGBColorModel.DefaultColorModel;
        }
        imageConsumer.setDimensions(this.imageWidth, this.imageHeight);
        if (this.properties != null && !this.properties.isEmpty()) {
            imageConsumer.setProperties(this.properties);
        }
        imageConsumer.setColorModel(colorModel);
        int n = 30;
        if (this.stitchBand) {
            n |= 0x10000;
        }
        imageConsumer.setHints(n);
        if (this.imageStatus != 1 && this.imageStatus != 4 && object != null) {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                imageConsumer.setPixels(0, 0, this.imageWidth, this.imageHeight, colorModel, byArray, this.storeOffset, this.pixelScanSize);
            } else {
                int[] nArray = (int[])object;
                imageConsumer.setPixels(0, 0, this.imageWidth, this.imageHeight, colorModel, nArray, this.storeOffset, this.pixelScanSize);
            }
        }
        if (this.imageStatus == 2) {
            imageConsumer.imageComplete(3);
        } else {
            imageConsumer.imageComplete(this.imageStatus);
        }
        this.consumers.removeElement(imageConsumer);
    }

    private void produceAll() {
        while (!this.consumers.isEmpty()) {
            try {
                ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(0);
                this.produce(imageConsumer);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    private void readImageFromStream() throws Exception {
        boolean bl;
        int n = this.colorModel.getPDFColorModelComponentSize();
        int n2 = this.colorModel.getNumComponents();
        byte[] byArray = null;
        if (this.inStreamFac != null) {
            this.inStream = this.inStreamFac.getInputStream();
            this.allocatedOwnStream = true;
        }
        if (this.inStream == null) {
            this.imageStatus = 1;
            return;
        }
        this.pixelScanSize = (n * n2 * this.imageWidth + 7 & 0xFFFFFFF8) >>> 3;
        boolean bl2 = bl = n <= 8 && n2 == 1;
        if (bl) {
            boolean bl3 = n == 8 && this.colorModel.canBlend();
            PDFColorModel pDFColorModel = bl3 ? this.colorModel.getBlendModel() : this.colorModel;
            int n3 = this.pixelScanSize * this.imageHeight;
            int n4 = 0;
            byArray = MemUtil.allocByte(n3);
            this.pixelStore.set(byArray);
            try {
                while (n3 > 0) {
                    this.checkInterrupt();
                    int n5 = this.inStream.read(byArray, n4, n3);
                    if (n5 <= 0) break;
                    if (bl3) {
                        this.colorModel.toBlend(byArray, n4, byArray, n4, n5);
                    }
                    n4 += n5;
                    n3 -= n5;
                }
                this.imageStatus = n3 != 0 ? 4 : 3;
            }
            catch (InterruptedException interruptedException) {
                this.imageStatus = 4;
            }
            catch (IOException iOException) {
                this.imageStatus = 1;
            }
            this.colorModel = pDFColorModel;
        } else {
            int[] nArray = MemUtil.allocInt(this.imageWidth * this.imageHeight);
            this.pixelStore.set(nArray);
            byte[] byArray2 = MemUtil.allocByte(this.pixelScanSize * 8 / n);
            int n6 = 0;
            if (n < 8) {
                byArray = MemUtil.allocByte(this.pixelScanSize);
            }
            this.imageStatus = 3;
            while (n6 < this.imageHeight) {
                block18: {
                    try {
                        int n7 = this.pixelScanSize;
                        int n8 = 0;
                        while (n7 > 0) {
                            this.checkInterrupt();
                            int n9 = n < 8 ? this.inStream.read(byArray, n8, n7) : this.inStream.read(byArray2, n8, n7);
                            if (n9 <= 0) break;
                            n8 += n9;
                            n7 -= n9;
                        }
                        if (n7 != 0) {
                            this.imageStatus = 4;
                        }
                        break block18;
                    }
                    catch (InterruptedException interruptedException) {
                        this.imageStatus = 4;
                    }
                    catch (IOException iOException) {
                        this.imageStatus = 1;
                    }
                    break;
                }
                if (n < 8) {
                    ExpandBitsImageFilter.bitsToBytes(byArray, 0, byArray2, 0, this.colorModel, this.imageWidth);
                }
                this.colorModel.toRGB(byArray2, 0, nArray, n6 * this.imageWidth, this.imageWidth);
                ++n6;
            }
            this.pixelScanSize = this.imageWidth;
            this.colorModel = DeviceRGBColorModel.DefaultColorModel;
        }
        if (this.allocatedOwnStream) {
            this.inStream.close();
        }
        this.inStream = null;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != null) {
            this.consumers.removeElement(imageConsumer);
        }
    }

    private synchronized void removeObserver(ImageObserver imageObserver) {
        SidecarImageObserverState sidecarImageObserverState = this.getObserverState(imageObserver);
        if (sidecarImageObserverState != null) {
            this.observers.removeElement(sidecarImageObserverState);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public void sendJavaColorModel() {
        this.sendJavaColorModel(true);
    }

    public void sendJavaColorModel(boolean bl) {
        this.useJavaColorModel = bl;
    }

    public void setAlphaFromUndercolor(SidecarImage sidecarImage) {
        this.convertToRGB();
        Object object = this.getPixels();
        sidecarImage.startProduction(null);
        sidecarImage.convertToRGB();
        Object object2 = sidecarImage.getPixels();
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        int n = this.storeOffset;
        int n2 = sidecarImage.storeOffset;
        this.premultipliedAlpha = true;
        int n3 = 0;
        while (n3 < this.imageHeight) {
            int n4 = 0;
            while (n4 < this.imageWidth) {
                int n5 = nArray2[n2 + n4];
                int n6 = nArray[n + n4];
                int n7 = n5 - n6 & 0xFF;
                if (n7 != 0) {
                    n6 = n7 == 255 ? 0 : (255 - n7 << 24) + (n6 & 0xFFFFFF);
                    nArray[n + n4] = n6;
                }
                ++n4;
            }
            n += this.pixelScanSize;
            n2 += sidecarImage.pixelScanSize;
            ++n3;
        }
    }

    public void setColorModel(ColorModel colorModel) {
        if (this.colorModel == null) {
            this.initColorModel(colorModel);
        }
    }

    public void setDimensions(int n, int n2) {
        if (n != -1) {
            this.imageWidth = n;
        }
        if (n2 != -1) {
            this.imageHeight = n2;
        }
    }

    public void setHints(int n) {
        if ((n & 0x10000) != 0) {
            this.stitchBand = true;
        }
    }

    public void setOrigin(int n, int n2) {
        this.originX = n;
        this.originY = n2;
    }

    public void setOrigin(Point point) {
        this.originX = point.x;
        this.originY = point.y;
    }

    public void setPaintColor(ColorValue colorValue) {
        if (this.colorModel != null && this.colorModel.setPaintColor(colorValue)) {
            this.cm = null;
        }
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        block9: {
            Object object;
            block10: {
                object = this.pixelStore.get();
                if (object == null && this.imageWidth > 0 && this.imageHeight > 0) {
                    this.setColorModel(colorModel);
                    if (this.bitsPerPixel <= 8) {
                        this.pixelScanSize = this.imageWidth * this.bitsPerPixel + 7 >>> 3;
                        object = MemUtil.allocByte(this.pixelScanSize * this.imageHeight);
                    } else {
                        this.pixelScanSize = this.imageWidth;
                        object = MemUtil.allocInt(this.pixelScanSize * this.imageHeight);
                    }
                    this.pixelStore.unlock();
                    this.pixelStore.set(object);
                }
                if (object == null) break block9;
                if (!(object instanceof byte[])) break block10;
                byte[] byArray2 = (byte[])object;
                int n7 = n * this.bitsPerPixel >>> 3;
                int n8 = (n + n3) * this.bitsPerPixel + 7 >>> 3;
                n8 = Math.min(n8, this.pixelScanSize) - n7;
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = n2 + n9;
                    if (n10 >= 0 && n10 < this.imageHeight) {
                        int n11 = n5 + n9 * n6;
                        int n12 = n10 * this.pixelScanSize + n7;
                        System.arraycopy(byArray, n11, byArray2, n12, n8);
                    }
                    ++n9;
                }
                break block9;
            }
            if (!(object instanceof int[])) break block9;
            int[] nArray = (int[])object;
            int[] nArray2 = MemUtil.allocInt(256);
            int n13 = 0;
            while (n13 < 256) {
                nArray2[n13] = colorModel.getRGB(n13);
                ++n13;
            }
            int n14 = 0;
            while (n14 < n4) {
                int n15 = n2 + n14;
                if (n15 >= 0 && n15 < this.imageHeight) {
                    int n16 = n5 + n14 * n6;
                    int n17 = n15 * this.imageWidth + n;
                    int n18 = Math.min(n3, this.imageWidth - n);
                    int n19 = 0;
                    while (n19 < n18) {
                        nArray[n17++] = nArray2[byArray[n16++] & 0xFF];
                        ++n19;
                    }
                }
                ++n14;
            }
        }
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        block11: {
            boolean bl;
            Object object;
            block12: {
                object = this.pixelStore.get();
                bl = this.checkColorModel(colorModel);
                if (object == null && this.imageWidth > 0 && this.imageHeight > 0) {
                    this.setColorModel(DeviceRGBColorModel.DefaultColorModel);
                    if (this.bitsPerPixel <= 8) {
                        this.pixelScanSize = this.imageWidth * this.bitsPerPixel + 7 >>> 3;
                        object = MemUtil.allocByte(this.pixelScanSize * this.imageHeight);
                    } else {
                        this.pixelScanSize = this.imageWidth;
                        object = MemUtil.allocInt(this.pixelScanSize * this.imageHeight);
                    }
                    this.pixelStore.unlock();
                    this.pixelStore.set(object);
                }
                if (object == null) break block11;
                if (!(object instanceof byte[])) break block12;
                byte[] byArray = (byte[])object;
                int n7 = n * this.bitsPerPixel >>> 3;
                int n8 = (n + n3) * this.bitsPerPixel + 7 >>> 3;
                n8 = Math.min(n8, this.pixelScanSize) - n7;
                byte[] byArray2 = MemUtil.allocByte(n8);
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = n2 + n9;
                    if (n10 >= 0 && n10 < this.imageHeight) {
                        int n11 = n5 + n9 * n6;
                        int n12 = n10 * this.pixelScanSize + n7;
                        int n13 = 0;
                        while (n13 < n8) {
                            byArray2[n13] = (byte)colorModel.getAlpha(nArray[n11++]);
                            ++n13;
                        }
                        System.arraycopy(byArray2, 0, byArray, n12, n8);
                    }
                    ++n9;
                }
                break block11;
            }
            if (!(object instanceof int[])) break block11;
            int[] nArray2 = (int[])object;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = n2 + n14;
                if (n15 >= 0 && n15 < this.imageHeight) {
                    int n16 = n5 + n14 * n6;
                    int n17 = n15 * this.imageWidth + n;
                    int n18 = Math.min(n3, this.imageWidth - n);
                    if (!bl) {
                        int n19 = 0;
                        while (n19 < n18) {
                            nArray2[n17 + n19] = colorModel.getRGB(nArray[n16 + n19]);
                            ++n19;
                        }
                    } else {
                        System.arraycopy(nArray, n16, nArray2, n17, n18);
                    }
                    n16 += n18;
                    n17 += n18;
                }
                ++n14;
            }
        }
    }

    public void setProperties(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.properties.put(k, hashtable.get(k));
            }
        }
    }

    public void setProperty(Object object, Object object2) {
        this.properties.put(object, object2);
    }

    public SidecarImage setRect(Rectangle rectangle) {
        Rectangle rectangle2 = this.getRect();
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        if (!rectangle3.equals(rectangle2)) {
            SidecarImage sidecarImage = (SidecarImage)this.clone();
            sidecarImage.storeOffset += (rectangle3.y - this.originY) * this.pixelScanSize + (rectangle3.x - this.originX);
            sidecarImage.originX = rectangle3.x;
            sidecarImage.originY = rectangle3.y;
            sidecarImage.imageWidth = rectangle3.width;
            sidecarImage.imageHeight = rectangle3.height;
            return sidecarImage;
        }
        return this;
    }

    public void setStitchBand() {
        this.setStitchBand(true);
    }

    public void setStitchBand(boolean bl) {
        this.stitchBand = bl;
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        block11: {
            Object object;
            this.addConsumer(imageConsumer);
            if (this.imageStatus != 0 && (object = this.pixelStore.get()) == null) {
                this.imageStatus = 0;
                this.observerFlags = 0;
            }
            if (this.imageStatus == 0) {
                if (this.src != null) {
                    this.src.startProduction(this);
                    try {
                        while (this.imageStatus == 0) {
                            this.wait();
                        }
                        break block11;
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.imageStatus == 0) {
                            this.imageStatus = 4;
                        }
                        break block11;
                    }
                }
                if (this.inStream != null || this.inStreamFac != null) {
                    try {
                        this.readImageFromStream();
                    }
                    catch (Exception exception) {
                        this.imageStatus = 1;
                    }
                } else {
                    this.imageStatus = 1;
                }
            }
        }
        this.produceAll();
        this.tellObservers();
    }

    private void tellObservers() {
        int n = this.observers.size();
        while (n-- > 0) {
            try {
                SidecarImageObserverState sidecarImageObserverState = (SidecarImageObserverState)this.observers.elementAt(n);
                if ((sidecarImageObserverState.dataWanted & this.observerFlags) == 0) continue;
                if (!sidecarImageObserverState.io.imageUpdate(this, this.observerFlags, this.originX, this.originY, this.imageWidth, this.imageHeight)) {
                    this.observers.removeElementAt(n);
                    continue;
                }
                if ((this.observerFlags & 0xE0) == 0) continue;
                this.observers.removeElementAt(n);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    class SidecarImageObserverState {
        ImageObserver io;
        int dataWanted;

        SidecarImageObserverState(ImageObserver imageObserver, int n) {
            this.io = imageObserver;
            this.dataWanted = n | 0x40 | 0x80 | 0x20;
        }
    }
}

