/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.util;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Util;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import netscape.security.PrivilegeManager;

public class Session {
    private Properties domains;
    private boolean isNetscapeSecurityRunning;
    private boolean isIESecurityRunning;
    private boolean isMacOS;
    private static Session theSession;

    private Session() {
        block5: {
            this.domains = new Properties();
            if (this.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
            } else if (this.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            }
            this.isMacOS = System.getProperty("os.name", "").toLowerCase().startsWith("mac");
            if (!this.isMacOS) break block5;
            try {
                Class.forName("com.apple.mrj.MRJApplicationUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.isMacOS = false;
            }
        }
    }

    public void addDomain(URL uRL, String string) {
        ((Hashtable)this.domains).put(uRL.getHost(), string);
    }

    public String getApplicationBaseURLAsString() {
        Session session = Session.getTheSession();
        if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        } else if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        }
        String string = System.getProperty("user.dir");
        string = string.replace(File.separatorChar, '/');
        return "file://localhost/" + string + "/";
    }

    public String getDomainAuth(URL uRL) {
        return (String)((Hashtable)this.domains).get(uRL.getHost());
    }

    public static Session getTheSession() {
        block4: {
            if (theSession != null) break block4;
            theSession = new Session();
            try {
                Class.forName("netscape.security.PrivilegeManager");
                Session.theSession.isNetscapeSecurityRunning = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Session.theSession.isNetscapeSecurityRunning = false;
            }
            try {
                Class.forName("com.ms.security.PolicyEngine");
                Session.theSession.isIESecurityRunning = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Session.theSession.isIESecurityRunning = false;
            }
        }
        return theSession;
    }

    public boolean isANewDomain(URL uRL) {
        return ((Hashtable)this.domains).get(uRL.getHost()) == null;
    }

    public boolean isDebugEnabled() {
        return Viewer.enabledDebug();
    }

    public boolean isIE() {
        return this.isIESecurityRunning;
    }

    public boolean isMacOS() {
        return this.isMacOS;
    }

    public boolean isNetscape() {
        return this.isNetscapeSecurityRunning;
    }

    public void removeDomain(URL uRL) {
        ((Hashtable)this.domains).remove(uRL.getHost());
    }

    public void showURL(String string) throws Exception {
        String string2 = ReaderPrefs.fBrowser;
        File file = new File(string2);
        if (!file.exists() || !file.isFile()) {
            throw new Exception(Util.getDialogString("Prefs:BrowserPathError"));
        }
        Runtime.getRuntime().exec(new String[]{ReaderPrefs.fBrowser, string});
    }
}

