/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.UIElement;
import com.adobe.pe.awt.UIElementGroup;
import com.adobe.pe.awt.UIElementVerb;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import com.adobe.util.Assert;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class ToolBar
extends Component
implements VObserver,
StrobeContainer,
MouseListener,
MouseMotionListener {
    private Graphics gBuf;
    private Image gImg;
    static final int kInitialOffset = 5;
    static final int kBorderInset = 1;
    static final int kSeparatorWidth = 10;
    static final int kButtonWidth = 28;
    static final int kButtonHeight = 26;
    static final int kImageWidth = 22;
    static final int kImageHeight = 22;
    static final int kImageInset = 2;
    static final Color BG = SystemColor.menu;
    ButtonInfo lastTipBI = null;
    static final int kTipOffset = 4;
    VStrobe strobe;
    VUIElement vuie;
    TransactionExecutionContext exContext;
    Vector groups = new Vector();
    int buttonOffset;
    ButtonInfo activeButton = null;
    int activeButtonState = 0;
    final int kTracking = 1;
    final int kTrackingOff = 2;
    final int kHovering = 3;

    public ToolBar(VUIElement vUIElement, TransactionExecutionContext transactionExecutionContext) {
        this.vuie = vUIElement;
        this.exContext = transactionExecutionContext;
        this.strobe = new VStrobe(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void change(Requester requester) throws WriteLockException {
        this.setActiveButton(null, 0);
        this.groups = new Vector();
        Vector vector = new Vector();
        this.groups.addElement(vector);
        try {
            this.buttonOffset = 6;
            this.populateFromElement(this.vuie.uiElementValue(requester), requester);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            Log.clog("ToolBar.change: " + exception.toString());
            Log.logStackTrace(exception);
        }
    }

    ButtonInfo findButton(Point point) {
        int n = 0;
        while (n < this.groups.size()) {
            Vector vector = (Vector)this.groups.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                ButtonInfo buttonInfo = (ButtonInfo)vector.elementAt(n2);
                if (buttonInfo.bbox.contains(point)) {
                    return buttonInfo;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    synchronized ButtonInfo findHoverButton(Point point) {
        ButtonInfo buttonInfo = this.findButton(point);
        this.setActiveButton(buttonInfo, 3);
        return buttonInfo;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized Dimension getPreferredSize() {
        int n = -8;
        int n2 = 0;
        while (n2 < this.groups.size()) {
            Vector vector = (Vector)this.groups.elementAt(n2);
            n += 10 + vector.size() * 28;
            ++n2;
        }
        return new Dimension(n, 28);
    }

    Point getTipLocation(Rectangle rectangle) {
        return new Point(rectangle.x + 4, rectangle.y + rectangle.height + 4);
    }

    void insureSeparator() {
        Vector vector = (Vector)this.groups.lastElement();
        if (vector.size() != 0) {
            this.groups.addElement(new Vector());
            this.buttonOffset += 10;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.activeButtonState != 1 && this.activeButtonState != 2) {
            return;
        }
        ButtonInfo buttonInfo = this.findButton(mouseEvent.getPoint());
        if (buttonInfo != this.activeButton) {
            this.setActiveButton(this.activeButton, 2);
        } else {
            this.setActiveButton(this.activeButton, 1);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseExited(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        switch (this.activeButtonState) {
            case 1: 
            case 2: {
                this.mouseDragged(mouseEvent);
                break;
            }
            default: {
                this.mouseMoved(mouseEvent);
            }
        }
        if (this.lastTipBI != null) {
            this.lastTipBI.tip.setVisible(false);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        ButtonInfo buttonInfo = this.findHoverButton(mouseEvent.getPoint());
        if (buttonInfo != null) {
            if (!buttonInfo.tip.isVisible()) {
                Point point = this.getTipLocation(buttonInfo.bbox);
                Point point2 = this.getLocationOnScreen();
                buttonInfo.tip.setLocation(point2.x + point.x, point2.y + this.getSize().height + 5);
                buttonInfo.tip.setVisible(true);
            }
            if (this.lastTipBI != buttonInfo) {
                if (this.lastTipBI != null) {
                    this.lastTipBI.tip.setVisible(false);
                }
                this.lastTipBI = buttonInfo;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ButtonInfo buttonInfo = this.findButton(mouseEvent.getPoint());
        if (buttonInfo != null && buttonInfo.enabled) {
            this.setActiveButton(buttonInfo, 1);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.activeButtonState != 1 && this.activeButtonState != 2) {
            return;
        }
        ButtonInfo buttonInfo = this.findButton(mouseEvent.getPoint());
        if (buttonInfo != this.activeButton) {
            this.setActiveButton(null, 0);
            return;
        }
        this.setActiveButton(null, 0);
        if (buttonInfo != null) {
            try {
                try {
                    buttonInfo.uie.getUIVerb().invoke(this.exContext);
                }
                catch (Exception exception) {
                }
                Object var4_3 = null;
                this.findHoverButton(mouseEvent.getPoint());
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.findHoverButton(mouseEvent.getPoint());
                throw throwable;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.gImg == null || this.gImg.getWidth(this) != this.getSize().width) {
            this.gImg = this.createImage(this.getSize().width, this.getSize().height);
            this.gBuf = this.gImg.getGraphics();
            this.gBuf.setColor(BG);
        }
        this.paintToolbar(this.gBuf);
        graphics.drawImage(this.gImg, 0, 0, this);
    }

    void paintButton(ButtonInfo buttonInfo, Graphics graphics, boolean bl) {
        Image image;
        boolean bl2;
        Rectangle rectangle = buttonInfo.bbox;
        int n = rectangle.x + 2;
        int n2 = 3;
        boolean bl3 = bl2 = buttonInfo.marked || this.activeButton == buttonInfo && this.activeButtonState == 1;
        if (bl) {
            graphics.setColor(BG);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (bl2) {
            graphics.setColor(BG.brighter());
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            graphics.setColor(BG.darker());
            graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
            graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 2);
            ++n;
            ++n2;
        }
        if ((image = buttonInfo.enabled ? (buttonInfo == this.activeButton && this.activeButtonState == 3 ? buttonInfo.icon : buttonInfo.monochromeIcon) : buttonInfo.disabledIcon) != null) {
            graphics.setColor(BG);
            graphics.drawImage(image, n, n2, this);
        }
        if (buttonInfo == this.activeButton && this.activeButtonState == 3 && buttonInfo.enabled) {
            graphics.setColor(BG.darker());
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(BG.brighter());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        }
    }

    private void paintToolbar(Graphics graphics) {
        int n = 6;
        Dimension dimension = this.getSize();
        graphics.setColor(BG);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(BG.darker());
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.setColor(BG.brighter());
        graphics.drawLine(0, 1, dimension.width, 1);
        graphics.setColor(BG.darker());
        graphics.drawLine(0, dimension.height - 2, dimension.width, dimension.height - 2);
        graphics.setColor(BG.brighter());
        graphics.drawLine(0, dimension.height - 1, dimension.width, dimension.height - 1);
        int n2 = 0;
        while (n2 < this.groups.size()) {
            Vector vector = (Vector)this.groups.elementAt(n2);
            int n3 = 0;
            while (n3 < vector.size()) {
                ButtonInfo buttonInfo = (ButtonInfo)vector.elementAt(n3);
                this.paintButton(buttonInfo, graphics, false);
                n += 28;
                ++n3;
            }
            n += 10;
            if (n2 < this.groups.size() - 2) {
                int n4 = n - 5;
                graphics.setColor(BG.darker());
                graphics.drawLine(n4 - 1, 5, n4 - 1, dimension.height - 6);
                graphics.setColor(BG.brighter());
                graphics.drawLine(n4, 5, n4, dimension.height - 6);
            }
            ++n2;
        }
    }

    void populateFromElement(UIElement uIElement, Requester requester) throws Exception {
        int n = uIElement.separationSelector;
        if (n != 0) {
            this.insureSeparator();
        }
        if (uIElement instanceof UIElementGroup) {
            UIElementGroup uIElementGroup = (UIElementGroup)uIElement;
            int n2 = 0;
            while (n2 < uIElementGroup.size()) {
                UIElement uIElement2 = uIElementGroup.getNthUIElement(n2);
                this.populateFromElement(uIElement2, requester);
                ++n2;
            }
        } else {
            Assert.notFalse(uIElement instanceof UIElementVerb);
            Vector vector = (Vector)this.groups.lastElement();
            ButtonInfo buttonInfo = new ButtonInfo((UIElementVerb)uIElement, this.buttonOffset, requester);
            vector.addElement(buttonInfo);
            this.buttonOffset += 28;
        }
        if (n != 0) {
            this.insureSeparator();
        }
    }

    synchronized void setActiveButton(ButtonInfo buttonInfo, int n) {
        if (buttonInfo == null) {
            n = 0;
        }
        if (buttonInfo != this.activeButton || n != this.activeButtonState) {
            Graphics graphics;
            block5: {
                ButtonInfo buttonInfo2 = this.activeButton;
                this.activeButton = buttonInfo;
                this.activeButtonState = n;
                graphics = this.getGraphics();
                try {
                    if (buttonInfo2 != null) {
                        this.paintButton(buttonInfo2, graphics, true);
                    }
                    if (buttonInfo2 == buttonInfo || buttonInfo == null) break block5;
                    this.paintButton(buttonInfo, graphics, true);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            Object var6_5 = null;
            graphics.dispose();
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
        int n = 0;
        while (n < this.groups.size()) {
            Vector vector = (Vector)this.groups.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                ButtonInfo buttonInfo = (ButtonInfo)vector.elementAt(n2);
                buttonInfo.biStrobe.setActive(transaction, bl);
                ++n2;
            }
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    class ButtonInfo
    implements VObserver,
    StrobeContainer {
        VStrobe biStrobe;
        Rectangle bbox;
        UIElementVerb uie;
        Image icon;
        Image monochromeIcon;
        Image disabledIcon;
        boolean marked;
        boolean enabled;
        Tip tip;

        ButtonInfo(UIElementVerb uIElementVerb, int n, Requester requester) throws Exception {
            this.bbox = new Rectangle(n, 2, 28, 24);
            this.uie = uIElementVerb;
            this.biStrobe = new VStrobe(this);
            this.biStrobe.setActive(ToolBar.this.strobe.getLastOwnerTransaction(), true);
            this.icon = uIElementVerb.getDefaultIcon();
            this.monochromeIcon = uIElementVerb.getGrayscaleIcon();
            this.disabledIcon = uIElementVerb.getDisabledIcon();
            this.prepareIcon();
            ToolBar toolBar2 = ToolBar.this;
            toolBar2.getClass();
            this.tip = toolBar2.new Tip(uIElementVerb.getVTipText().stringValue(requester), PEUtil.getFrame(ToolBar.this));
        }

        public void change(Requester requester) throws WriteLockException {
            boolean bl = this.marked;
            boolean bl2 = this.enabled;
            try {
                try {
                    this.marked = this.uie.getUIVerb().marked(requester);
                    this.enabled = this.uie.getUIVerb().enabled(requester);
                }
                catch (WriteLockException writeLockException) {
                    throw writeLockException;
                }
                catch (Exception exception) {
                    Log.clog("Toolbar$ButtonInfo.change: " + exception.toString());
                    this.marked = false;
                    this.enabled = false;
                }
                Object var5_6 = null;
                ToolBar.this.repaint(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ToolBar.this.repaint(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                throw throwable;
            }
        }

        private void prepareIcon() {
            MediaTracker mediaTracker = new MediaTracker(ToolBar.this);
            try {
                mediaTracker.addImage(this.icon, 0);
                mediaTracker.addImage(this.monochromeIcon, 1);
                mediaTracker.addImage(this.disabledIcon, 2);
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                Assert.notNull(null);
            }
        }

        public void setStrobeActive(Transaction transaction, boolean bl) {
            ToolBar.this.strobe.setActive(transaction, bl);
        }
    }

    public class Tip
    extends Window {
        private Font font;
        private Dimension dim;
        private String tip;
        private int y;

        public Tip(String string, Frame frame) {
            super(frame);
            this.setText(string);
            ((Component)this).setBackground(SystemColor.info);
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }

        public void paint(Graphics graphics) {
            if (this.tip == null) {
                return;
            }
            graphics.setFont(this.font);
            graphics.setColor(SystemColor.infoText);
            graphics.drawString(this.tip, 2, this.y);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }

        public void setLocation(int n, int n2) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = this.getSize().width;
            if (n + n3 > dimension.width) {
                n -= n + n3 - dimension.width;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > dimension.height) {
                n2 = dimension.height - this.getSize().height;
            }
            super.setLocation(n, n2);
        }

        public void setText(String string) {
            this.tip = string;
            if (this.tip == null) {
                return;
            }
            this.font = new Font("SansSerif", 0, 12);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.y = fontMetrics.getHeight();
            this.dim = new Dimension(fontMetrics.stringWidth(this.tip) + 4, this.y + 4);
            ((Component)this).setBounds(0, 0, this.dim.width, this.dim.height);
            this.repaint();
        }

        public void setVisible(boolean bl) {
            if (bl) {
                try {
                    Session session = Session.getTheSession();
                    if (session.isIE()) {
                        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                    } else if (session.isNetscape()) {
                        PrivilegeManager.enablePrivilege((String)"UniversalTopLevelWindow");
                    }
                }
                catch (Exception exception) {}
            }
            super.setVisible(bl);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

