/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static final int PARSE_POST_DATA_CHUNK_SIZE = 32;

    public static Hashtable parseQueryString(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable hashtable = new Hashtable();
        int n = 0;
        int n2 = string.indexOf(61, n);
        while (n < string.length()) {
            int n3 = string.indexOf(38, n);
            if (n3 == -1) {
                n3 = string.length();
            }
            if (n2 > n3 || n2 < 0) {
                HttpUtils.addParameter(hashtable, HttpUtils.urlDecode(string, n, n3), "");
            } else {
                HttpUtils.addParameter(hashtable, HttpUtils.urlDecode(string, n, n2), HttpUtils.urlDecode(string, n2 + 1, n3));
                n2 = string.indexOf(61, n3 + 1);
            }
            n = n3 + 1;
        }
        return hashtable;
    }

    private static void addParameter(Hashtable hashtable, String string, String string2) {
        try {
            String[] stringArray = (String[])hashtable.get(string);
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            hashtable.put(string, stringArray2);
        }
        catch (NullPointerException nullPointerException) {
            hashtable.put(string, new String[]{string2});
        }
    }

    private static String urlDecode(String string, int n, int n2) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '+') {
                stringBuffer.append(' ');
            } else if (c == '%') {
                try {
                    stringBuffer.append((char)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw new IllegalArgumentException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
                n3 += 2;
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream) throws IllegalArgumentException {
        try {
            if (n >= 0) {
                int n2;
                byte[] byArray = new byte[n];
                int n3 = n2 = servletInputStream.read(byArray, 0, byArray.length);
                while (n2 > 0 && n3 < n) {
                    n2 = servletInputStream.read(byArray, n3, n - n3);
                    n3 += n2;
                }
                if (n3 < n) {
                    throw new IllegalArgumentException("Amount of POST data doesn't match contentLength");
                }
                return HttpUtils.parseQueryString(new String(byArray));
            }
            throw new IllegalArgumentException("Missing or illegal content length in Post request");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error reading POST data:" + iOException.getMessage());
        }
    }

    public static StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        int n = httpServletRequest.getServerPort();
        if (n != 80) {
            stringBuffer.append(":");
            stringBuffer.append(n);
        }
        stringBuffer.append(httpServletRequest.getRequestURI());
        return stringBuffer;
    }
}

