/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef SOUNDSERVER_H
#define SOUNDSERVER_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"
#include "kmedia2.h"
#include "core.h"

namespace Arts {
enum RealtimeStatus {rtRealtime = 0, rtNoSupport = 1, rtNoWrapper = 2, rtNoRealtime = 3};
};
namespace Arts {
class SampleStorageEntry;
class SampleStorage;
class ByteSoundProducer;
class ByteSoundProducerV2;
class ByteSoundReceiver;
class SimpleSoundServer;
class SoundServer;
class SoundServerV2;
class WavPlayObject;

class SampleStorageEntry_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static SampleStorageEntry_base *_create(const std::string& subClass = "Arts::SampleStorageEntry");
	static SampleStorageEntry_base *_fromString(const std::string& objectref);
	static SampleStorageEntry_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SampleStorageEntry_base *_fromDynamicCast(const Arts::Object& object);
	inline SampleStorageEntry_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string name() = 0;
	virtual std::string filename() = 0;
	virtual bool completed() = 0;
	virtual void write(const std::vector<Arts::mcopbyte>& data) = 0;
	virtual void finish() = 0;
};

class SampleStorageEntry_stub : virtual public SampleStorageEntry_base, virtual public Arts::Object_stub {
protected:
	SampleStorageEntry_stub();

public:
	SampleStorageEntry_stub(Arts::Connection *connection, long objectID);

	std::string name();
	std::string filename();
	bool completed();
	void write(const std::vector<Arts::mcopbyte>& data);
	void finish();
};

class SampleStorageEntry_skel : virtual public SampleStorageEntry_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}
	inline void completed_changed(bool newValue) {
		_emit_changed("completed_changed",newValue);
	}

public:
	SampleStorageEntry_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SampleStorageEntry : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SampleStorageEntry_base *_cache;
	inline SampleStorageEntry_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SampleStorageEntry_base *)_pool->base->_cast(SampleStorageEntry_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SampleStorageEntry(SampleStorageEntry_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SampleStorageEntry_base _base_class;

	inline SampleStorageEntry() : Arts::Object(_Creator), _cache(0) {}
	inline SampleStorageEntry(const Arts::SubClass& s) :
		Arts::Object(SampleStorageEntry_base::_create(s.string())), _cache(0) {}
	inline SampleStorageEntry(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SampleStorageEntry_base::_fromString(r.string())):(SampleStorageEntry_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SampleStorageEntry(const Arts::DynamicCast& c) : Arts::Object(SampleStorageEntry_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SampleStorageEntry(const SampleStorageEntry& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SampleStorageEntry(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SampleStorageEntry null() {return SampleStorageEntry((SampleStorageEntry_base*)0);}
	inline static SampleStorageEntry _from_base(SampleStorageEntry_base* b) {return SampleStorageEntry(b);}
	inline SampleStorageEntry& operator=(const SampleStorageEntry& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline SampleStorageEntry_base* _base() {return _cache?_cache:_method_call();}

	inline std::string name();
	inline std::string filename();
	inline bool completed();
	inline void write(const std::vector<Arts::mcopbyte>& data);
	inline void finish();
};

class SampleStorage_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static SampleStorage_base *_create(const std::string& subClass = "Arts::SampleStorage");
	static SampleStorage_base *_fromString(const std::string& objectref);
	static SampleStorage_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SampleStorage_base *_fromDynamicCast(const Arts::Object& object);
	inline SampleStorage_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void constructor(const std::string& directory, bool clearOnInit) = 0;
	virtual Arts::SampleStorageEntry createEntry(const std::string& name) = 0;
	virtual void addEntry(Arts::SampleStorageEntry entry) = 0;
	virtual void removeEntry(Arts::SampleStorageEntry entry) = 0;
	virtual Arts::SampleStorageEntry findEntry(const std::string& name) = 0;
};

class SampleStorage_stub : virtual public SampleStorage_base, virtual public Arts::Object_stub {
protected:
	SampleStorage_stub();

public:
	SampleStorage_stub(Arts::Connection *connection, long objectID);

	void constructor(const std::string& directory, bool clearOnInit);
	Arts::SampleStorageEntry createEntry(const std::string& name);
	void addEntry(Arts::SampleStorageEntry entry);
	void removeEntry(Arts::SampleStorageEntry entry);
	Arts::SampleStorageEntry findEntry(const std::string& name);
};

class SampleStorage_skel : virtual public SampleStorage_base, virtual public Arts::Object_skel {
public:
	SampleStorage_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SampleStorage : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SampleStorage_base *_cache;
	inline SampleStorage_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SampleStorage_base *)_pool->base->_cast(SampleStorage_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SampleStorage(SampleStorage_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SampleStorage_base _base_class;

	inline SampleStorage() : Arts::Object(_Creator), _cache(0) {}
	inline SampleStorage(const Arts::SubClass& s) :
		Arts::Object(SampleStorage_base::_create(s.string())), _cache(0) {}
	inline SampleStorage(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SampleStorage_base::_fromString(r.string())):(SampleStorage_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SampleStorage(const Arts::DynamicCast& c) : Arts::Object(SampleStorage_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SampleStorage(const SampleStorage& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SampleStorage(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SampleStorage null() {return SampleStorage((SampleStorage_base*)0);}
	inline static SampleStorage _from_base(SampleStorage_base* b) {return SampleStorage(b);}
	inline SampleStorage& operator=(const SampleStorage& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline SampleStorage_base* _base() {return _cache?_cache:_method_call();}

	inline SampleStorage(const std::string& directory, bool clearOnInit);
	inline Arts::SampleStorageEntry createEntry(const std::string& name);
	inline void addEntry(Arts::SampleStorageEntry entry);
	inline void removeEntry(Arts::SampleStorageEntry entry);
	inline Arts::SampleStorageEntry findEntry(const std::string& name);
};

class ByteSoundProducer_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static ByteSoundProducer_base *_create(const std::string& subClass = "Arts::ByteSoundProducer");
	static ByteSoundProducer_base *_fromString(const std::string& objectref);
	static ByteSoundProducer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ByteSoundProducer_base *_fromDynamicCast(const Arts::Object& object);
	inline ByteSoundProducer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual long channels() = 0;
	virtual long bits() = 0;
};

class ByteSoundProducer_stub : virtual public ByteSoundProducer_base, virtual public Arts::SynthModule_stub {
protected:
	ByteSoundProducer_stub();

public:
	ByteSoundProducer_stub(Arts::Connection *connection, long objectID);

	long samplingRate();
	long channels();
	long bits();
};

class ByteSoundProducer_skel : virtual public ByteSoundProducer_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream outdata;            // outgoing stream

	// handler for asynchronous streams
	virtual void request_outdata(Arts::DataPacket<Arts::mcopbyte> *);

protected:
	// emitters for change notifications
	inline void samplingRate_changed(long newValue) {
		_emit_changed("samplingRate_changed",newValue);
	}
	inline void channels_changed(long newValue) {
		_emit_changed("channels_changed",newValue);
	}
	inline void bits_changed(long newValue) {
		_emit_changed("bits_changed",newValue);
	}

public:
	ByteSoundProducer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

};
#include "reference.h"
namespace Arts {
class ByteSoundProducer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ByteSoundProducer_base *_cache;
	inline ByteSoundProducer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteSoundProducer_base *)_pool->base->_cast(ByteSoundProducer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ByteSoundProducer(ByteSoundProducer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ByteSoundProducer_base _base_class;

	inline ByteSoundProducer() : Arts::Object(_Creator), _cache(0) {}
	inline ByteSoundProducer(const Arts::SubClass& s) :
		Arts::Object(ByteSoundProducer_base::_create(s.string())), _cache(0) {}
	inline ByteSoundProducer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ByteSoundProducer_base::_fromString(r.string())):(ByteSoundProducer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteSoundProducer(const Arts::DynamicCast& c) : Arts::Object(ByteSoundProducer_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ByteSoundProducer(const ByteSoundProducer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ByteSoundProducer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ByteSoundProducer null() {return ByteSoundProducer((ByteSoundProducer_base*)0);}
	inline static ByteSoundProducer _from_base(ByteSoundProducer_base* b) {return ByteSoundProducer(b);}
	inline ByteSoundProducer& operator=(const ByteSoundProducer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline ByteSoundProducer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long samplingRate();
	inline long channels();
	inline long bits();
};

class ByteSoundProducerV2_base : virtual public Arts::ByteSoundProducer_base {
public:
	static unsigned long _IID; // interface ID

	static ByteSoundProducerV2_base *_create(const std::string& subClass = "Arts::ByteSoundProducerV2");
	static ByteSoundProducerV2_base *_fromString(const std::string& objectref);
	static ByteSoundProducerV2_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ByteSoundProducerV2_base *_fromDynamicCast(const Arts::Object& object);
	inline ByteSoundProducerV2_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string title() = 0;
};

class ByteSoundProducerV2_stub : virtual public ByteSoundProducerV2_base, virtual public Arts::ByteSoundProducer_stub {
protected:
	ByteSoundProducerV2_stub();

public:
	ByteSoundProducerV2_stub(Arts::Connection *connection, long objectID);

	std::string title();
};

class ByteSoundProducerV2_skel : virtual public ByteSoundProducerV2_base, virtual public Arts::ByteSoundProducer_skel {
protected:
	// emitters for change notifications
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}

public:
	ByteSoundProducerV2_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class ByteSoundProducerV2 : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ByteSoundProducerV2_base *_cache;
	inline ByteSoundProducerV2_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteSoundProducerV2_base *)_pool->base->_cast(ByteSoundProducerV2_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ByteSoundProducerV2(ByteSoundProducerV2_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ByteSoundProducerV2_base _base_class;

	inline ByteSoundProducerV2() : Arts::Object(_Creator), _cache(0) {}
	inline ByteSoundProducerV2(const Arts::SubClass& s) :
		Arts::Object(ByteSoundProducerV2_base::_create(s.string())), _cache(0) {}
	inline ByteSoundProducerV2(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ByteSoundProducerV2_base::_fromString(r.string())):(ByteSoundProducerV2_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteSoundProducerV2(const Arts::DynamicCast& c) : Arts::Object(ByteSoundProducerV2_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ByteSoundProducerV2(const ByteSoundProducerV2& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ByteSoundProducerV2(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ByteSoundProducerV2 null() {return ByteSoundProducerV2((ByteSoundProducerV2_base*)0);}
	inline static ByteSoundProducerV2 _from_base(ByteSoundProducerV2_base* b) {return ByteSoundProducerV2(b);}
	inline ByteSoundProducerV2& operator=(const ByteSoundProducerV2& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::ByteSoundProducer() const { return Arts::ByteSoundProducer(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline ByteSoundProducerV2_base* _base() {return _cache?_cache:_method_call();}

	inline long samplingRate();
	inline long channels();
	inline long bits();
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string title();
};

class ByteSoundReceiver_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static ByteSoundReceiver_base *_create(const std::string& subClass = "Arts::ByteSoundReceiver");
	static ByteSoundReceiver_base *_fromString(const std::string& objectref);
	static ByteSoundReceiver_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ByteSoundReceiver_base *_fromDynamicCast(const Arts::Object& object);
	inline ByteSoundReceiver_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual long channels() = 0;
	virtual long bits() = 0;
	virtual std::string title() = 0;
};

class ByteSoundReceiver_stub : virtual public ByteSoundReceiver_base, virtual public Arts::SynthModule_stub {
protected:
	ByteSoundReceiver_stub();

public:
	ByteSoundReceiver_stub(Arts::Connection *connection, long objectID);

	long samplingRate();
	long channels();
	long bits();
	std::string title();
};

class ByteSoundReceiver_skel : virtual public ByteSoundReceiver_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream indata;             // incoming stream

	// handler for asynchronous streams
	virtual void process_indata(Arts::DataPacket<Arts::mcopbyte> *) = 0;

protected:
	// emitters for change notifications
	inline void samplingRate_changed(long newValue) {
		_emit_changed("samplingRate_changed",newValue);
	}
	inline void channels_changed(long newValue) {
		_emit_changed("channels_changed",newValue);
	}
	inline void bits_changed(long newValue) {
		_emit_changed("bits_changed",newValue);
	}
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}

public:
	ByteSoundReceiver_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

};
#include "reference.h"
namespace Arts {
class ByteSoundReceiver : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ByteSoundReceiver_base *_cache;
	inline ByteSoundReceiver_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteSoundReceiver_base *)_pool->base->_cast(ByteSoundReceiver_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ByteSoundReceiver(ByteSoundReceiver_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ByteSoundReceiver_base _base_class;

	inline ByteSoundReceiver() : Arts::Object(_Creator), _cache(0) {}
	inline ByteSoundReceiver(const Arts::SubClass& s) :
		Arts::Object(ByteSoundReceiver_base::_create(s.string())), _cache(0) {}
	inline ByteSoundReceiver(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ByteSoundReceiver_base::_fromString(r.string())):(ByteSoundReceiver_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteSoundReceiver(const Arts::DynamicCast& c) : Arts::Object(ByteSoundReceiver_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ByteSoundReceiver(const ByteSoundReceiver& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ByteSoundReceiver(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ByteSoundReceiver null() {return ByteSoundReceiver((ByteSoundReceiver_base*)0);}
	inline static ByteSoundReceiver _from_base(ByteSoundReceiver_base* b) {return ByteSoundReceiver(b);}
	inline ByteSoundReceiver& operator=(const ByteSoundReceiver& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline ByteSoundReceiver_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long samplingRate();
	inline long channels();
	inline long bits();
	inline std::string title();
};

class SimpleSoundServer_base : virtual public Arts::PlayObjectFactory_base {
public:
	static unsigned long _IID; // interface ID

	static SimpleSoundServer_base *_create(const std::string& subClass = "Arts::SimpleSoundServer");
	static SimpleSoundServer_base *_fromString(const std::string& objectref);
	static SimpleSoundServer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SimpleSoundServer_base *_fromDynamicCast(const Arts::Object& object);
	inline SimpleSoundServer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::StereoEffectStack outstack() = 0;
	virtual float minStreamBufferTime() = 0;
	virtual float serverBufferTime() = 0;
	virtual long play(const std::string& filename) = 0;
	virtual void attach(Arts::ByteSoundProducer producer) = 0;
	virtual void detach(Arts::ByteSoundProducer producer) = 0;
	virtual void attachRecorder(Arts::ByteSoundReceiver receiver) = 0;
	virtual void detachRecorder(Arts::ByteSoundReceiver receiver) = 0;
	virtual Arts::Object createObject(const std::string& name) = 0;
};

class SimpleSoundServer_stub : virtual public SimpleSoundServer_base, virtual public Arts::PlayObjectFactory_stub {
protected:
	SimpleSoundServer_stub();

public:
	SimpleSoundServer_stub(Arts::Connection *connection, long objectID);

	Arts::StereoEffectStack outstack();
	float minStreamBufferTime();
	float serverBufferTime();
	long play(const std::string& filename);
	void attach(Arts::ByteSoundProducer producer);
	void detach(Arts::ByteSoundProducer producer);
	void attachRecorder(Arts::ByteSoundReceiver receiver);
	void detachRecorder(Arts::ByteSoundReceiver receiver);
	Arts::Object createObject(const std::string& name);
};

class SimpleSoundServer_skel : virtual public SimpleSoundServer_base, virtual public Arts::PlayObjectFactory_skel {
protected:
	// emitters for change notifications
	inline void minStreamBufferTime_changed(float newValue) {
		_emit_changed("minStreamBufferTime_changed",newValue);
	}
	inline void serverBufferTime_changed(float newValue) {
		_emit_changed("serverBufferTime_changed",newValue);
	}

public:
	SimpleSoundServer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SimpleSoundServer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SimpleSoundServer_base *_cache;
	inline SimpleSoundServer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SimpleSoundServer_base *)_pool->base->_cast(SimpleSoundServer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SimpleSoundServer(SimpleSoundServer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SimpleSoundServer_base _base_class;

	inline SimpleSoundServer() : Arts::Object(_Creator), _cache(0) {}
	inline SimpleSoundServer(const Arts::SubClass& s) :
		Arts::Object(SimpleSoundServer_base::_create(s.string())), _cache(0) {}
	inline SimpleSoundServer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SimpleSoundServer_base::_fromString(r.string())):(SimpleSoundServer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SimpleSoundServer(const Arts::DynamicCast& c) : Arts::Object(SimpleSoundServer_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SimpleSoundServer(const SimpleSoundServer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SimpleSoundServer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SimpleSoundServer null() {return SimpleSoundServer((SimpleSoundServer_base*)0);}
	inline static SimpleSoundServer _from_base(SimpleSoundServer_base* b) {return SimpleSoundServer(b);}
	inline SimpleSoundServer& operator=(const SimpleSoundServer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObjectFactory() const { return Arts::PlayObjectFactory(*_pool); }
	inline SimpleSoundServer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::PlayObject createPlayObject(const std::string& filename);
	inline Arts::StereoEffectStack outstack();
	inline float minStreamBufferTime();
	inline float serverBufferTime();
	inline long play(const std::string& filename);
	inline void attach(Arts::ByteSoundProducer producer);
	inline void detach(Arts::ByteSoundProducer producer);
	inline void attachRecorder(Arts::ByteSoundReceiver receiver);
	inline void detachRecorder(Arts::ByteSoundReceiver receiver);
	inline Arts::Object createObject(const std::string& name);
};

class SoundServer_base : virtual public Arts::SimpleSoundServer_base {
public:
	static unsigned long _IID; // interface ID

	static SoundServer_base *_create(const std::string& subClass = "Arts::SoundServer");
	static SoundServer_base *_fromString(const std::string& objectref);
	static SoundServer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SoundServer_base *_fromDynamicCast(const Arts::Object& object);
	inline SoundServer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::RealtimeStatus realtimeStatus() = 0;
	virtual long secondsUntilSuspend() = 0;
	virtual bool suspend() = 0;
	virtual bool terminate() = 0;
};

class SoundServer_stub : virtual public SoundServer_base, virtual public Arts::SimpleSoundServer_stub {
protected:
	SoundServer_stub();

public:
	SoundServer_stub(Arts::Connection *connection, long objectID);

	Arts::RealtimeStatus realtimeStatus();
	long secondsUntilSuspend();
	bool suspend();
	bool terminate();
};

class SoundServer_skel : virtual public SoundServer_base, virtual public Arts::SimpleSoundServer_skel {
protected:
	// emitters for change notifications
	inline void realtimeStatus_changed(Arts::RealtimeStatus newValue) {
		_emit_changed("realtimeStatus_changed",newValue);
	}
	inline void secondsUntilSuspend_changed(long newValue) {
		_emit_changed("secondsUntilSuspend_changed",newValue);
	}

public:
	SoundServer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SoundServer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SoundServer_base *_cache;
	inline SoundServer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SoundServer_base *)_pool->base->_cast(SoundServer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SoundServer(SoundServer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SoundServer_base _base_class;

	inline SoundServer() : Arts::Object(_Creator), _cache(0) {}
	inline SoundServer(const Arts::SubClass& s) :
		Arts::Object(SoundServer_base::_create(s.string())), _cache(0) {}
	inline SoundServer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SoundServer_base::_fromString(r.string())):(SoundServer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SoundServer(const Arts::DynamicCast& c) : Arts::Object(SoundServer_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SoundServer(const SoundServer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SoundServer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SoundServer null() {return SoundServer((SoundServer_base*)0);}
	inline static SoundServer _from_base(SoundServer_base* b) {return SoundServer(b);}
	inline SoundServer& operator=(const SoundServer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SimpleSoundServer() const { return Arts::SimpleSoundServer(*_pool); }
	inline operator Arts::PlayObjectFactory() const { return Arts::PlayObjectFactory(*_pool); }
	inline SoundServer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::StereoEffectStack outstack();
	inline float minStreamBufferTime();
	inline float serverBufferTime();
	inline long play(const std::string& filename);
	inline void attach(Arts::ByteSoundProducer producer);
	inline void detach(Arts::ByteSoundProducer producer);
	inline void attachRecorder(Arts::ByteSoundReceiver receiver);
	inline void detachRecorder(Arts::ByteSoundReceiver receiver);
	inline Arts::Object createObject(const std::string& name);
	inline Arts::PlayObject createPlayObject(const std::string& filename);
	inline Arts::RealtimeStatus realtimeStatus();
	inline long secondsUntilSuspend();
	inline bool suspend();
	inline bool terminate();
};

class SoundServerV2_base : virtual public Arts::SoundServer_base,
	virtual public Arts::PlayObjectFactoryV2_base {
public:
	static unsigned long _IID; // interface ID

	static SoundServerV2_base *_create(const std::string& subClass = "Arts::SoundServerV2");
	static SoundServerV2_base *_fromString(const std::string& objectref);
	static SoundServerV2_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SoundServerV2_base *_fromDynamicCast(const Arts::Object& object);
	inline SoundServerV2_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long autoSuspendSeconds() = 0;
	virtual void autoSuspendSeconds(long newValue) = 0;
	virtual long bufferSizeMultiplier() = 0;
	virtual void bufferSizeMultiplier(long newValue) = 0;
	virtual float cpuUsage() = 0;
	virtual std::string audioMethod() = 0;
	virtual long samplingRate() = 0;
	virtual long channels() = 0;
	virtual long bits() = 0;
	virtual bool fullDuplex() = 0;
	virtual std::string audioDevice() = 0;
	virtual long fragments() = 0;
	virtual long fragmentSize() = 0;
	virtual std::string version() = 0;
	virtual Arts::StereoVolumeControl outVolume() = 0;
	virtual Arts::SampleStorage sampleStorage() = 0;
	virtual void checkNewObjects() = 0;
};

class SoundServerV2_stub : virtual public SoundServerV2_base, virtual public Arts::SoundServer_stub,
	virtual public Arts::PlayObjectFactoryV2_stub {
protected:
	SoundServerV2_stub();

public:
	SoundServerV2_stub(Arts::Connection *connection, long objectID);

	long autoSuspendSeconds();
	void autoSuspendSeconds(long newValue);
	long bufferSizeMultiplier();
	void bufferSizeMultiplier(long newValue);
	float cpuUsage();
	std::string audioMethod();
	long samplingRate();
	long channels();
	long bits();
	bool fullDuplex();
	std::string audioDevice();
	long fragments();
	long fragmentSize();
	std::string version();
	Arts::StereoVolumeControl outVolume();
	Arts::SampleStorage sampleStorage();
	void checkNewObjects();
};

class SoundServerV2_skel : virtual public SoundServerV2_base, virtual public Arts::SoundServer_skel,
	virtual public Arts::PlayObjectFactoryV2_skel {
protected:
	// emitters for change notifications
	inline void autoSuspendSeconds_changed(long newValue) {
		_emit_changed("autoSuspendSeconds_changed",newValue);
	}
	inline void bufferSizeMultiplier_changed(long newValue) {
		_emit_changed("bufferSizeMultiplier_changed",newValue);
	}
	inline void cpuUsage_changed(float newValue) {
		_emit_changed("cpuUsage_changed",newValue);
	}
	inline void audioMethod_changed(const std::string& newValue) {
		_emit_changed("audioMethod_changed",newValue);
	}
	inline void samplingRate_changed(long newValue) {
		_emit_changed("samplingRate_changed",newValue);
	}
	inline void channels_changed(long newValue) {
		_emit_changed("channels_changed",newValue);
	}
	inline void bits_changed(long newValue) {
		_emit_changed("bits_changed",newValue);
	}
	inline void fullDuplex_changed(bool newValue) {
		_emit_changed("fullDuplex_changed",newValue);
	}
	inline void audioDevice_changed(const std::string& newValue) {
		_emit_changed("audioDevice_changed",newValue);
	}
	inline void fragments_changed(long newValue) {
		_emit_changed("fragments_changed",newValue);
	}
	inline void fragmentSize_changed(long newValue) {
		_emit_changed("fragmentSize_changed",newValue);
	}
	inline void version_changed(const std::string& newValue) {
		_emit_changed("version_changed",newValue);
	}

public:
	SoundServerV2_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SoundServerV2 : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SoundServerV2_base *_cache;
	inline SoundServerV2_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SoundServerV2_base *)_pool->base->_cast(SoundServerV2_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SoundServerV2(SoundServerV2_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SoundServerV2_base _base_class;

	inline SoundServerV2() : Arts::Object(_Creator), _cache(0) {}
	inline SoundServerV2(const Arts::SubClass& s) :
		Arts::Object(SoundServerV2_base::_create(s.string())), _cache(0) {}
	inline SoundServerV2(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SoundServerV2_base::_fromString(r.string())):(SoundServerV2_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SoundServerV2(const Arts::DynamicCast& c) : Arts::Object(SoundServerV2_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SoundServerV2(const SoundServerV2& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SoundServerV2(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SoundServerV2 null() {return SoundServerV2((SoundServerV2_base*)0);}
	inline static SoundServerV2 _from_base(SoundServerV2_base* b) {return SoundServerV2(b);}
	inline SoundServerV2& operator=(const SoundServerV2& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SoundServer() const { return Arts::SoundServer(*_pool); }
	inline operator Arts::SimpleSoundServer() const { return Arts::SimpleSoundServer(*_pool); }
	inline operator Arts::PlayObjectFactory() const { return Arts::PlayObjectFactory(*_pool); }
	inline operator Arts::PlayObjectFactoryV2() const { return Arts::PlayObjectFactoryV2(*_pool); }
	inline SoundServerV2_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::RealtimeStatus realtimeStatus();
	inline long secondsUntilSuspend();
	inline bool suspend();
	inline bool terminate();
	inline Arts::StereoEffectStack outstack();
	inline float minStreamBufferTime();
	inline float serverBufferTime();
	inline long play(const std::string& filename);
	inline void attach(Arts::ByteSoundProducer producer);
	inline void detach(Arts::ByteSoundProducer producer);
	inline void attachRecorder(Arts::ByteSoundReceiver receiver);
	inline void detachRecorder(Arts::ByteSoundReceiver receiver);
	inline Arts::Object createObject(const std::string& name);
	inline Arts::PlayObject createPlayObject(const std::string& filename);
	inline Arts::PlayObject createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS);
	inline Arts::PlayObject createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS);
	inline long autoSuspendSeconds();
	inline void autoSuspendSeconds(long _newValue);
	inline long bufferSizeMultiplier();
	inline void bufferSizeMultiplier(long _newValue);
	inline float cpuUsage();
	inline std::string audioMethod();
	inline long samplingRate();
	inline long channels();
	inline long bits();
	inline bool fullDuplex();
	inline std::string audioDevice();
	inline long fragments();
	inline long fragmentSize();
	inline std::string version();
	inline Arts::StereoVolumeControl outVolume();
	inline Arts::SampleStorage sampleStorage();
	inline void checkNewObjects();
};

class WavPlayObject_base : virtual public Arts::PlayObject_base,
	virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static WavPlayObject_base *_create(const std::string& subClass = "Arts::WavPlayObject");
	static WavPlayObject_base *_fromString(const std::string& objectref);
	static WavPlayObject_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static WavPlayObject_base *_fromDynamicCast(const Arts::Object& object);
	inline WavPlayObject_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class WavPlayObject_stub : virtual public WavPlayObject_base, virtual public Arts::PlayObject_stub,
	virtual public Arts::SynthModule_stub {
protected:
	WavPlayObject_stub();

public:
	WavPlayObject_stub(Arts::Connection *connection, long objectID);

};

class WavPlayObject_skel : virtual public WavPlayObject_base, virtual public Arts::PlayObject_skel,
	virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

public:
	WavPlayObject_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class WavPlayObject : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	WavPlayObject_base *_cache;
	inline WavPlayObject_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(WavPlayObject_base *)_pool->base->_cast(WavPlayObject_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline WavPlayObject(WavPlayObject_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef WavPlayObject_base _base_class;

	inline WavPlayObject() : Arts::Object(_Creator), _cache(0) {}
	inline WavPlayObject(const Arts::SubClass& s) :
		Arts::Object(WavPlayObject_base::_create(s.string())), _cache(0) {}
	inline WavPlayObject(const Arts::Reference &r) :
		Arts::Object(r.isString()?(WavPlayObject_base::_fromString(r.string())):(WavPlayObject_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline WavPlayObject(const Arts::DynamicCast& c) : Arts::Object(WavPlayObject_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline WavPlayObject(const WavPlayObject& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline WavPlayObject(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static WavPlayObject null() {return WavPlayObject((WavPlayObject_base*)0);}
	inline static WavPlayObject _from_base(WavPlayObject_base* b) {return WavPlayObject(b);}
	inline WavPlayObject& operator=(const WavPlayObject& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObject() const { return Arts::PlayObject(*_pool); }
	inline operator Arts::PlayObject_private() const { return Arts::PlayObject_private(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline WavPlayObject_base* _base() {return _cache?_cache:_method_call();}

	inline std::string description();
	inline Arts::poTime currentTime();
	inline Arts::poTime overallTime();
	inline Arts::poCapabilities capabilities();
	inline std::string mediaName();
	inline Arts::poState state();
	inline void play();
	inline void seek(const Arts::poTime& newTime);
	inline void pause();
	inline void halt();
	inline bool loadMedia(const std::string& filename);
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

};
// Forward wrapper calls to _base classes:

inline std::string Arts::SampleStorageEntry::name()
{
	return _cache?static_cast<Arts::SampleStorageEntry_base*>(_cache)->name():static_cast<Arts::SampleStorageEntry_base*>(_method_call())->name();
}

inline std::string Arts::SampleStorageEntry::filename()
{
	return _cache?static_cast<Arts::SampleStorageEntry_base*>(_cache)->filename():static_cast<Arts::SampleStorageEntry_base*>(_method_call())->filename();
}

inline bool Arts::SampleStorageEntry::completed()
{
	return _cache?static_cast<Arts::SampleStorageEntry_base*>(_cache)->completed():static_cast<Arts::SampleStorageEntry_base*>(_method_call())->completed();
}

inline void Arts::SampleStorageEntry::write(const std::vector<Arts::mcopbyte>& data)
{
	 _cache?static_cast<Arts::SampleStorageEntry_base*>(_cache)->write(data):static_cast<Arts::SampleStorageEntry_base*>(_method_call())->write(data);
}

inline void Arts::SampleStorageEntry::finish()
{
	 _cache?static_cast<Arts::SampleStorageEntry_base*>(_cache)->finish():static_cast<Arts::SampleStorageEntry_base*>(_method_call())->finish();
}

inline Arts::SampleStorage::SampleStorage(const std::string& directory, bool clearOnInit)
		: Arts::Object(SampleStorage_base::_create())
{
	static_cast<Arts::SampleStorage_base*>(_method_call())->constructor(directory, clearOnInit);
}

inline Arts::SampleStorageEntry Arts::SampleStorage::createEntry(const std::string& name)
{
	return _cache?static_cast<Arts::SampleStorage_base*>(_cache)->createEntry(name):static_cast<Arts::SampleStorage_base*>(_method_call())->createEntry(name);
}

inline void Arts::SampleStorage::addEntry(Arts::SampleStorageEntry entry)
{
	 _cache?static_cast<Arts::SampleStorage_base*>(_cache)->addEntry(entry):static_cast<Arts::SampleStorage_base*>(_method_call())->addEntry(entry);
}

inline void Arts::SampleStorage::removeEntry(Arts::SampleStorageEntry entry)
{
	 _cache?static_cast<Arts::SampleStorage_base*>(_cache)->removeEntry(entry):static_cast<Arts::SampleStorage_base*>(_method_call())->removeEntry(entry);
}

inline Arts::SampleStorageEntry Arts::SampleStorage::findEntry(const std::string& name)
{
	return _cache?static_cast<Arts::SampleStorage_base*>(_cache)->findEntry(name):static_cast<Arts::SampleStorage_base*>(_method_call())->findEntry(name);
}

inline Arts::AutoSuspendState Arts::ByteSoundProducer::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::ByteSoundProducer::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::ByteSoundProducer::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::ByteSoundProducer::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::ByteSoundProducer::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::ByteSoundProducer::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::ByteSoundProducer::samplingRate()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->samplingRate():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->samplingRate();
}

inline long Arts::ByteSoundProducer::channels()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->channels():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->channels();
}

inline long Arts::ByteSoundProducer::bits()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->bits():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->bits();
}

inline long Arts::ByteSoundProducerV2::samplingRate()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->samplingRate():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->samplingRate();
}

inline long Arts::ByteSoundProducerV2::channels()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->channels():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->channels();
}

inline long Arts::ByteSoundProducerV2::bits()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->bits():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->bits();
}

inline Arts::AutoSuspendState Arts::ByteSoundProducerV2::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::ByteSoundProducerV2::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::ByteSoundProducerV2::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::ByteSoundProducerV2::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::ByteSoundProducerV2::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::ByteSoundProducerV2::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::ByteSoundProducerV2::title()
{
	return _cache?static_cast<Arts::ByteSoundProducerV2_base*>(_cache)->title():static_cast<Arts::ByteSoundProducerV2_base*>(_method_call())->title();
}

inline Arts::AutoSuspendState Arts::ByteSoundReceiver::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::ByteSoundReceiver::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::ByteSoundReceiver::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::ByteSoundReceiver::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::ByteSoundReceiver::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::ByteSoundReceiver::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::ByteSoundReceiver::samplingRate()
{
	return _cache?static_cast<Arts::ByteSoundReceiver_base*>(_cache)->samplingRate():static_cast<Arts::ByteSoundReceiver_base*>(_method_call())->samplingRate();
}

inline long Arts::ByteSoundReceiver::channels()
{
	return _cache?static_cast<Arts::ByteSoundReceiver_base*>(_cache)->channels():static_cast<Arts::ByteSoundReceiver_base*>(_method_call())->channels();
}

inline long Arts::ByteSoundReceiver::bits()
{
	return _cache?static_cast<Arts::ByteSoundReceiver_base*>(_cache)->bits():static_cast<Arts::ByteSoundReceiver_base*>(_method_call())->bits();
}

inline std::string Arts::ByteSoundReceiver::title()
{
	return _cache?static_cast<Arts::ByteSoundReceiver_base*>(_cache)->title():static_cast<Arts::ByteSoundReceiver_base*>(_method_call())->title();
}

inline Arts::PlayObject Arts::SimpleSoundServer::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::StereoEffectStack Arts::SimpleSoundServer::outstack()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->outstack():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->outstack();
}

inline float Arts::SimpleSoundServer::minStreamBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->minStreamBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->minStreamBufferTime();
}

inline float Arts::SimpleSoundServer::serverBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->serverBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->serverBufferTime();
}

inline long Arts::SimpleSoundServer::play(const std::string& filename)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->play(filename):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->play(filename);
}

inline void Arts::SimpleSoundServer::attach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attach(producer);
}

inline void Arts::SimpleSoundServer::detach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detach(producer);
}

inline void Arts::SimpleSoundServer::attachRecorder(Arts::ByteSoundReceiver receiver)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attachRecorder(receiver):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attachRecorder(receiver);
}

inline void Arts::SimpleSoundServer::detachRecorder(Arts::ByteSoundReceiver receiver)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detachRecorder(receiver):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detachRecorder(receiver);
}

inline Arts::Object Arts::SimpleSoundServer::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->createObject(name):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->createObject(name);
}

inline Arts::StereoEffectStack Arts::SoundServer::outstack()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->outstack():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->outstack();
}

inline float Arts::SoundServer::minStreamBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->minStreamBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->minStreamBufferTime();
}

inline float Arts::SoundServer::serverBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->serverBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->serverBufferTime();
}

inline long Arts::SoundServer::play(const std::string& filename)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->play(filename):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->play(filename);
}

inline void Arts::SoundServer::attach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attach(producer);
}

inline void Arts::SoundServer::detach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detach(producer);
}

inline void Arts::SoundServer::attachRecorder(Arts::ByteSoundReceiver receiver)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attachRecorder(receiver):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attachRecorder(receiver);
}

inline void Arts::SoundServer::detachRecorder(Arts::ByteSoundReceiver receiver)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detachRecorder(receiver):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detachRecorder(receiver);
}

inline Arts::Object Arts::SoundServer::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->createObject(name):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->createObject(name);
}

inline Arts::PlayObject Arts::SoundServer::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::RealtimeStatus Arts::SoundServer::realtimeStatus()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->realtimeStatus():static_cast<Arts::SoundServer_base*>(_method_call())->realtimeStatus();
}

inline long Arts::SoundServer::secondsUntilSuspend()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->secondsUntilSuspend():static_cast<Arts::SoundServer_base*>(_method_call())->secondsUntilSuspend();
}

inline bool Arts::SoundServer::suspend()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->suspend():static_cast<Arts::SoundServer_base*>(_method_call())->suspend();
}

inline bool Arts::SoundServer::terminate()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->terminate():static_cast<Arts::SoundServer_base*>(_method_call())->terminate();
}

inline Arts::RealtimeStatus Arts::SoundServerV2::realtimeStatus()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->realtimeStatus():static_cast<Arts::SoundServer_base*>(_method_call())->realtimeStatus();
}

inline long Arts::SoundServerV2::secondsUntilSuspend()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->secondsUntilSuspend():static_cast<Arts::SoundServer_base*>(_method_call())->secondsUntilSuspend();
}

inline bool Arts::SoundServerV2::suspend()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->suspend():static_cast<Arts::SoundServer_base*>(_method_call())->suspend();
}

inline bool Arts::SoundServerV2::terminate()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->terminate():static_cast<Arts::SoundServer_base*>(_method_call())->terminate();
}

inline Arts::StereoEffectStack Arts::SoundServerV2::outstack()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->outstack():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->outstack();
}

inline float Arts::SoundServerV2::minStreamBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->minStreamBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->minStreamBufferTime();
}

inline float Arts::SoundServerV2::serverBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->serverBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->serverBufferTime();
}

inline long Arts::SoundServerV2::play(const std::string& filename)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->play(filename):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->play(filename);
}

inline void Arts::SoundServerV2::attach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attach(producer);
}

inline void Arts::SoundServerV2::detach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detach(producer);
}

inline void Arts::SoundServerV2::attachRecorder(Arts::ByteSoundReceiver receiver)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attachRecorder(receiver):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attachRecorder(receiver);
}

inline void Arts::SoundServerV2::detachRecorder(Arts::ByteSoundReceiver receiver)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detachRecorder(receiver):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detachRecorder(receiver);
}

inline Arts::Object Arts::SoundServerV2::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->createObject(name):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->createObject(name);
}

inline Arts::PlayObject Arts::SoundServerV2::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::PlayObject Arts::SoundServerV2::createPlayObjectForURL(const std::string& url, const std::string& mimetype, bool createBUS)
{
	return _cache?static_cast<Arts::PlayObjectFactoryV2_base*>(_cache)->createPlayObjectForURL(url, mimetype, createBUS):static_cast<Arts::PlayObjectFactoryV2_base*>(_method_call())->createPlayObjectForURL(url, mimetype, createBUS);
}

inline Arts::PlayObject Arts::SoundServerV2::createPlayObjectForStream(Arts::InputStream instream, const std::string& mimetype, bool createBUS)
{
	return _cache?static_cast<Arts::PlayObjectFactoryV2_base*>(_cache)->createPlayObjectForStream(instream, mimetype, createBUS):static_cast<Arts::PlayObjectFactoryV2_base*>(_method_call())->createPlayObjectForStream(instream, mimetype, createBUS);
}

inline long Arts::SoundServerV2::autoSuspendSeconds()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->autoSuspendSeconds():static_cast<Arts::SoundServerV2_base*>(_method_call())->autoSuspendSeconds();
}

inline void Arts::SoundServerV2::autoSuspendSeconds(long _newValue)
{
	 _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->autoSuspendSeconds(_newValue):static_cast<Arts::SoundServerV2_base*>(_method_call())->autoSuspendSeconds(_newValue);
}

inline long Arts::SoundServerV2::bufferSizeMultiplier()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->bufferSizeMultiplier():static_cast<Arts::SoundServerV2_base*>(_method_call())->bufferSizeMultiplier();
}

inline void Arts::SoundServerV2::bufferSizeMultiplier(long _newValue)
{
	 _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->bufferSizeMultiplier(_newValue):static_cast<Arts::SoundServerV2_base*>(_method_call())->bufferSizeMultiplier(_newValue);
}

inline float Arts::SoundServerV2::cpuUsage()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->cpuUsage():static_cast<Arts::SoundServerV2_base*>(_method_call())->cpuUsage();
}

inline std::string Arts::SoundServerV2::audioMethod()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->audioMethod():static_cast<Arts::SoundServerV2_base*>(_method_call())->audioMethod();
}

inline long Arts::SoundServerV2::samplingRate()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->samplingRate():static_cast<Arts::SoundServerV2_base*>(_method_call())->samplingRate();
}

inline long Arts::SoundServerV2::channels()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->channels():static_cast<Arts::SoundServerV2_base*>(_method_call())->channels();
}

inline long Arts::SoundServerV2::bits()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->bits():static_cast<Arts::SoundServerV2_base*>(_method_call())->bits();
}

inline bool Arts::SoundServerV2::fullDuplex()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->fullDuplex():static_cast<Arts::SoundServerV2_base*>(_method_call())->fullDuplex();
}

inline std::string Arts::SoundServerV2::audioDevice()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->audioDevice():static_cast<Arts::SoundServerV2_base*>(_method_call())->audioDevice();
}

inline long Arts::SoundServerV2::fragments()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->fragments():static_cast<Arts::SoundServerV2_base*>(_method_call())->fragments();
}

inline long Arts::SoundServerV2::fragmentSize()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->fragmentSize():static_cast<Arts::SoundServerV2_base*>(_method_call())->fragmentSize();
}

inline std::string Arts::SoundServerV2::version()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->version():static_cast<Arts::SoundServerV2_base*>(_method_call())->version();
}

inline Arts::StereoVolumeControl Arts::SoundServerV2::outVolume()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->outVolume():static_cast<Arts::SoundServerV2_base*>(_method_call())->outVolume();
}

inline Arts::SampleStorage Arts::SoundServerV2::sampleStorage()
{
	return _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->sampleStorage():static_cast<Arts::SoundServerV2_base*>(_method_call())->sampleStorage();
}

inline void Arts::SoundServerV2::checkNewObjects()
{
	 _cache?static_cast<Arts::SoundServerV2_base*>(_cache)->checkNewObjects():static_cast<Arts::SoundServerV2_base*>(_method_call())->checkNewObjects();
}

inline std::string Arts::WavPlayObject::description()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->description():static_cast<Arts::PlayObject_base*>(_method_call())->description();
}

inline Arts::poTime Arts::WavPlayObject::currentTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->currentTime():static_cast<Arts::PlayObject_base*>(_method_call())->currentTime();
}

inline Arts::poTime Arts::WavPlayObject::overallTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->overallTime():static_cast<Arts::PlayObject_base*>(_method_call())->overallTime();
}

inline Arts::poCapabilities Arts::WavPlayObject::capabilities()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->capabilities():static_cast<Arts::PlayObject_base*>(_method_call())->capabilities();
}

inline std::string Arts::WavPlayObject::mediaName()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->mediaName():static_cast<Arts::PlayObject_base*>(_method_call())->mediaName();
}

inline Arts::poState Arts::WavPlayObject::state()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->state():static_cast<Arts::PlayObject_base*>(_method_call())->state();
}

inline void Arts::WavPlayObject::play()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->play():static_cast<Arts::PlayObject_base*>(_method_call())->play();
}

inline void Arts::WavPlayObject::seek(const Arts::poTime& newTime)
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->seek(newTime):static_cast<Arts::PlayObject_base*>(_method_call())->seek(newTime);
}

inline void Arts::WavPlayObject::pause()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->pause():static_cast<Arts::PlayObject_base*>(_method_call())->pause();
}

inline void Arts::WavPlayObject::halt()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->halt():static_cast<Arts::PlayObject_base*>(_method_call())->halt();
}

inline bool Arts::WavPlayObject::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline Arts::AutoSuspendState Arts::WavPlayObject::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::WavPlayObject::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::WavPlayObject::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::WavPlayObject::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::WavPlayObject::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::WavPlayObject::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

#endif /* SOUNDSERVER_H */
