Chapter 1


The Eiffel/S Compiler
=====================


1.1   Introduction

Eiffel/S is a compiler developed by SiG Computer GmbH together with a library
of reusable classes for the language Eiffel 3.  The programs belonging to the
package were written almost entirely in Eiffel. We have given platform indepen-
dence a very high priority during the development of this product. This makes
it possible to supply Eiffel/S for many popular operating systems and computers
right from the beginning. It also means that your programs should run without
change on all these systems.

We would like to express our special thanks to Bertrand Meyer who has been
most cooperative in keeping us informed on the newest developments in the
language Eiffel.



1.2   Survey
============

This manual describes how to translate Eiffel programs, how to bind external
C functions and libraries into Eiffel programs and how to use the Eiffel runtime
system. In the last chapter you will find a summary of the restrictions imposed
by the current release.

You should begin by reading the section `How to compile a program' in this chap-
ter and then try out some of the example programs supplied with the compiler.

After that we recommend that you read Chapter 2 - at least the beginning. In
Chapter 3 you will learn how to turn pre- and postconditions, invariants and
debug instructions on and off.

The remaining chapters are for those of you who want to combine Eiffel with C
routines. Although that is not difficult, we recommend that you first make sure
you are thoroughly familiar with the language Eiffel, with the libraries and 
with the compilation of Eiffel programs.



1.3  Installation
=================


Since Eiffel/S is supplied for a wide variety of platforms we cannot give 
directions for installation in this general manual. Please consult the 
'install' file that describes how to install Eiffel/S on your system.



1.4   Conventions
=================

Thia manual describes all aspects of the Eiffel/S compiler and the runtime system;
but it does assume a certain amount of familiarity with the language Eiffel. In
particular we will not describe the language Eiffel and we will sometimes use
concepts explained in [me9l] without explicitly referring to that source.  This
seems appropriate inasmuch aa you muat read the book Eiffel:  The Language
anyway in order to be able to program in Eiffel 3.

However, a few concepts that are repeatedly used will be briefly explained here:

We use the concept `cluster' at many places in this manual. What a `cluster' is
can depend on the operating system. In most cases this is merely a directory
(UNIX, ULTRIX, SUN-OS, MS-DOS, OS/2).

All path names having to do with cluaters that belong to the original Eiffel/S
package are relative to the inatallation cluater.


Example.

Suppose Eiffel/S has been installed in the cluster /usr/eiffel. Then a path
like

    examples

is to be understand as

    /uar/eiffel/examples

In Eiffel/S paths may be given either in the uaual UNIX or in the MS-DOS
convention. The compiler resp. the runtime system always converts them to the
correct form.



1.5   How to compile an Eiffel program
======================================

Go to one of the subclusters of the cluster examples. There you will find several
files whose names end with .pdl. These files tell the compiler how to translate
and link Eiffel programs.  For the moment you need not be concerned with
the contents of these files. You will also find a file README. There all example
programs belonging to the particular group (cluster) are described briefly. Pick
one that seems interesting to you.

Suppose you have picked psdo_sh (a pseudo shell). To compile this program you
enter

ecc -0 psdo_sh

ecc is the name of the Eiffel/S compiler; psdosh is the name of the example
(and also the name of the .pdl file).

Now you can lean back (but not for long!)  and watch the compiler at work.
Assuming you did not make any mistakes while installing the Eiffel/S system
the compiler will produce the following:

    * A subcluster psdo_sh.op ('op' for `optimized package').

    * A subcluster psdo_sh.pdb (`pdb' for `package database').

    * An executable program psdosh in the current cluster.

The contents of the subclusters psdo_sh. op and psdosh.pdb are of no interest
to us at this moment.

Now start the example program psdo_sh; it will itself tell you how to use it.

Naturally you can do the same with any of the other example programs.




1.6   The compiler
==================

The Eiffel/S compiler consists of several parts that are called one after another
by ecc. Depending on the operating system ecc may be a shell script, a batch
program or some other mechanism.  For you as user it does not really matter
what it is.

However we must warn you never to call the individual parts of the compiler
directly (i.e. circumventing ecc). This can in some cases lead to bizarre behavior.

The compiler is called as follows:

    ecc progname
or
    ecc -o progname


You must supply a program name on the command line. The compiler looks in
the current cluster for a file with the name progname . pdl. If it finds the file it
begins with the translation. Otherwise the compiler will ask you for the names
of the root class and the root creation procedure to be used; then it produces a
.pdl file and begins translation.

The option -o instructs the compiler to produce an optimized version. Without
this option it produces a version suitable for debugging.

Example:

You call the compiler with the command line

    ecc my_prog

The compiler does not find the PDL file my_prog.pdl, so you are asked to fill in
the second and third lines of the following table.

   Name of executable program : my_prog
   Name of root class         : TEST
   Name of creation procedure : make

(we have already entered plausible answers in this example). If you want to stop
compilation simply press the Break key (the accompanying installation leaflet
reveals which key that is).

The compiler then produces the PDL file my_prog.pdl, which looks as follows:

program my_prog

root
   TEST : make

cluster

    "."
    end

    -- All Eiffel/S clusters

end


(Here the comment `All Eiffel/S clusters' stands for a list of all clusters belonging
to the original Eiffel/S package.)

After producing the PDL file the compiler begins with the actual translation.

Please see Chapter 2 for more information about the structure of a PDL file.

Important Remark
================

Eiffel/S does not permit the creation procedure of the root class to have ar-
guments.  That would be redundant anyway given the facilities of the class
ENVIRONMENT (see Chapter 7 and the Eiffel/S library manual).




1.7  Compiler messages
======================

After the compiler has been started the first thing to appear on the screen is
the logo. Then the various compiler passes report in with `Pass 0', `Pass 1' etc.
Following the name of the pass the name of the class currently being translated
is shown.  Eiffel/S has four passes; the first one (`Pass 0') merely analyzes the
PDL file and reads the clusters.

All error messages are written to STDERR and to the file ecc . err.  Whenever
possible the compiler includes with an error message a code of the form V???,
where `???'  is a three character code.  This means a validity rule has been
violated. You can readily find the corresponding validity rule by consulting the
index of Eiffel: The Language.

After successful translation you will find the executable program in the current
cluster.  Moreover the compiler will have created two subclusters in which the
following files can be found:

  * Several .db files; these are databases generated by the compiler containing
    all the information about your program.
  * C files and .h files.

The name of the subclusters are the name of the PDL file with the extensions
`.p' (or `.op') and `.pdb'.

In this release the database is only used by the compiler.  In later releases,
however, it will be the basis for a programmer's workbench. If you do not want
to make any further changes in your program you may delete the corresponding
subclusters.  This should be done with the utility eclean which is part of the
Eiffel/S package.



Important Remark
================

Eiffel/S always translates complete programs - never single classes. We do not
want to go into the reasons for this here. Suffice it to say that a separate compi-
lation of single classes is only possible or reasonable in very simple constellations.
This does not, however, mean that Eiffel/S will translate all classes every time
you make a change - Eiffel/S is an incremental compiler that always tries to
minimize the amount of recompilation.



1.8   Compiler options
======================

The Eiffel/S compiler has only one option: -o.

This option tturns optimization on and has the following effect:
   * All assertion checks are removed.
   * Attribute accesses are optimized.
   * Array accesses are optimized.
   * The history mechanism is removed.
   * Dead code is eliminated.


Remark.

When optimization is turned off (i.e.  no -o option) the compiler produces a
debugging version of the program.  This allows you to check assertions, void
references, etc.  But unfortunately we cannot get this for free:  the code of a
debugging version is about three to five times bigger and executes much slower
than the optimized version. You should also keep this in mind when you want
to compare Eiffel/S with other compilers or languages.



1.9   C compilation and linking
===============================


Eiffel/S generates C code as output. This code must then be compiled by a C
compiler and linked with a linker.  In addition the Eiffel compiler can call the
utility make - for example to do automatic compilation of external C routines
(see Chapter 2).

Which C compiler, which linker and which make utility is to be used is specified
in the file eif2bin (Eiffel to binary).  This ASCII file is to be found in the
subcluster bin of the installation cluster. You can, however, put an eif2bin file
in the current cluster (working directory). The compiler will then use the `local'
file instead of the `global' file in the bin cluster. The structure of this file is very
simple:

   compiler : cc -o
   linker   . cc -s
   make     :  make

After the entry 'compiler' you enter the name of the C compiler, after 'linker'
the name of the linker and finally after 'make' the name of the make utility. In
each case you can list options that are to be passed to the respective program.
In the case of the make utility you can give further options in the PDL file (see
Chapter 2). You can also put the word 'ansi' on a separate line. This will cause
the Eiffel/S compiler to produce ANSI C. This C code cannot be translated with
older C compilers - it requires an ANSI C compiler.

Remark.

The options -c resp. -o are appended automatically.




We hope Eiffel/S will prove to be a useful tool for your work.
==============================================================
