-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class PSDO_ED

inherit
    INTERACT
        end

    ENVIRONMENT 
        end

creation
    make

feature

    tf   : TEXTFILE 
    done : BOOLEAN
    path : STRING

-----------------------------------------------------------

    make is

        local
            cmd : CHARACTER
        do
            if arg_count > 0 then
                path := arg_item (1)
            else
                get_a_string ("Enter name of file to edit :")
                path := the_string
            end

            if not fs.file_exists (path) then
                fs.add_file (path, "rw.r.r")
            end

            !!tf.connect_to (fs.access_file (path, "r", false)) 
            io.put_string ("Use 'h' for help%N")

            from
                get_a_character (">")
                cmd := the_character
            until
                done
            loop
                inspect cmd

                when 'h' then
                    show_commands

                when 'd' then
                    display_line
                
                when 'e' then
                    edit_line

                when 'i' then
                    insert_line

                when 'q' then
                    quit

                when 'r' then
                    remove_line

                when 'w' then
                    show_window

                when 'x' then
                    exit

                else
                    io.put_string ("Unknown command; use 'h' for help%N")
                end

                if not done then
                    get_a_character (">") 
                    cmd := the_character
                end
            end
        end
-----------------------------------------------------------

    show_commands is

        do
            io.put_string ("d : display a line%N")
            io.put_string ("w : show a window (23 lines)%N") 
            io.put_string ("e : edit a line%N")
            io.put_string ("i : insert a line%N")
            io.put_string ("r : remove a line%N")
            io.put_string ("q : quit (ignore changes)%N")
            io.put_string ("x : exit (save changes)%N")
            io.put_newline
        end
-----------------------------------------------------------

    display_line is

        local
            lno : INTEGER

        do
            lno := get_line_number (1, tf.count)
            io.put_string (tf.item (lno))
            io.put_newline
        end
-----------------------------------------------------------

    show_window is

        local
            lno : INTEGER
            i   : INTEGER 

        do
            from
                lno := get_line_number (1, tf.count)
                i   := lno
            until
                i > tf.count or else i > lno + 23
            loop
                io.put_string (fmt.i2s ("4", i))
                io.put_string (": ")
                io.put_string (tf.item (i))
                io.put_newline

                i := i + 1
            end
        end
-----------------------------------------------------------

    edit_line is

        local
            lno : INTEGER

        do
            lno := get_line_number (1, tf.count)
            io.put_string ("old line: ")
            io.put_string (tf.item (lno))
            io.put_newline
            get_a_string (" new line: ") 
            tf.put (the_string, lno)
        end
-----------------------------------------------------------

    insert_line is

        local
            lno : INTEGER

        do
            lno := get_line_number (0, tf.count)
            get_a_string ("new line: ")
            tf.insert (the_string, lno)
        end
-----------------------------------------------------------

    remove_line is

        local
            lno : INTEGER

        do
            lno := get_line_number (1, tf.count)
            tf.remove (lno)
        end
-----------------------------------------------------------

    quit is

        do
            tf.abort
            done := true
        end
-----------------------------------------------------------

    exit is
 
        do
            tf.disconnect 
            done := true
        end
-----------------------------------------------------------

    get_line_number (min, max : INTEGER) : INTEGER is

        do
            io.put_string ("line number (min = ")
            io.put_int (min)
            io.put_string (", max = ")
            io.put_int (max)
            io.put_string (") ")
            get_an_integer (": ") 
            result := the_integer
        end
            
end -- class PSDO_ED

