/*
 * Decompiled with CFR 0.152.
 */
import com.oroinc.net.ftp.FTPFile;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class LocalContext {
    private String currentWorkingDirectoryName;
    private File currentWorkingDirectoryFile;

    public LocalContext() throws IOException {
        this.currentWorkingDirectoryName = System.getProperty("user.dir", "");
        this.currentWorkingDirectoryFile = new File(this.currentWorkingDirectoryName);
        try {
            if (!this.currentWorkingDirectoryFile.isDirectory()) {
                throw new IOException("Not a directory name: " + this.currentWorkingDirectoryFile);
            }
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        this.currentWorkingDirectoryName = this.currentWorkingDirectoryFile.getCanonicalPath();
    }

    public LocalContext(File file) throws IOException {
        this.currentWorkingDirectoryFile = new File(file.getCanonicalPath());
        try {
            if (!this.currentWorkingDirectoryFile.isDirectory()) {
                throw new IOException("Not a directory name: " + this.currentWorkingDirectoryFile);
            }
            this.currentWorkingDirectoryName = this.currentWorkingDirectoryFile.getCanonicalPath();
            return;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectoryName;
    }

    public boolean changeToParentDirectory() throws IOException {
        int n = this.currentWorkingDirectoryName.lastIndexOf(File.separator);
        try {
            if (n == -1) {
                return false;
            }
            String string = this.currentWorkingDirectoryName.substring(0, n);
            if (string.length() <= 0) {
                return false;
            }
            File file = new File(string);
            if (!file.isDirectory()) {
                return false;
            }
            this.currentWorkingDirectoryFile = file;
            this.currentWorkingDirectoryName = this.currentWorkingDirectoryFile.getCanonicalPath();
            return true;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public boolean changeWorkingDirectory(String string) throws IOException {
        try {
            File file = new File(this.currentWorkingDirectoryName, string);
            if (!file.exists()) {
                file = new File(string);
            }
            if (file.isDirectory()) {
                this.currentWorkingDirectoryFile = file;
                this.currentWorkingDirectoryName = this.currentWorkingDirectoryFile.getCanonicalPath();
                return true;
            }
            return false;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public FTPFile[] listFiles() throws IOException {
        String[] stringArray = this.currentWorkingDirectoryFile.list();
        FTPFile[] fTPFileArray = new FTPFile[stringArray.length];
        try {
            int n = 0;
            while (n < fTPFileArray.length) {
                String string = stringArray[n];
                String string2 = "";
                File file = new File(this.currentWorkingDirectoryFile, string);
                FTPFile fTPFile = new FTPFile();
                fTPFile.setType(file.isDirectory() ? 1 : (file.isFile() ? 0 : 3));
                string2 = String.valueOf(string2) + (file.isDirectory() ? "d " : (file.isFile() ? "f " : "u "));
                if (file.canRead()) {
                    fTPFile.setPermission(0, 0, true);
                    string2 = String.valueOf(string2) + "r";
                } else {
                    fTPFile.setPermission(0, 0, false);
                    string2 = String.valueOf(string2) + "-";
                }
                if (file.canWrite()) {
                    fTPFile.setPermission(0, 1, true);
                    string2 = String.valueOf(string2) + "w";
                } else {
                    string2 = String.valueOf(string2) + "-";
                    fTPFile.setPermission(0, 1, false);
                }
                long l = file.lastModified();
                Date date = new Date(l);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                fTPFile.setTimestamp((Calendar)gregorianCalendar);
                long l2 = file.length();
                String string3 = Long.toString(l2);
                fTPFile.setSize(l2);
                int n2 = 12 - string3.length();
                if (n2 <= 0) {
                    n2 = 1;
                }
                string2 = String.valueOf(string2) + "             ".substring(13 - n2) + string3;
                fTPFile.setName(string);
                string2 = String.valueOf(string2) + " " + string;
                fTPFile.setRawListing(string2);
                fTPFileArray[n] = fTPFile;
                ++n;
            }
            return fTPFileArray;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public boolean makeDirectory(String string) throws IOException {
        try {
            File file = new File(this.currentWorkingDirectoryName, string);
            return file.mkdir();
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public boolean renameFile(String string, String string2) throws IOException {
        try {
            boolean bl;
            File file = new File(this.currentWorkingDirectoryName, string);
            if (!file.exists()) {
                file = new File(string);
            }
            if (!(bl = file.renameTo(new File(this.currentWorkingDirectoryName, string2)))) {
                bl = file.renameTo(new File(string2));
            }
            return bl;
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public boolean deleteFile(String string) throws IOException {
        try {
            File file = new File(this.currentWorkingDirectoryName, string);
            if (!file.exists()) {
                file = new File(string);
            }
            if (!file.isFile()) {
                throw new IOException(String.valueOf(string) + " is not a standard file");
            }
            return file.delete();
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    public boolean removeDirectory(String string) throws IOException {
        try {
            File file = new File(this.currentWorkingDirectoryName, string);
            if (!file.exists()) {
                file = new File(string);
            }
            if (!file.isDirectory()) {
                throw new IOException(String.valueOf(string) + " is not a directory");
            }
            return file.delete();
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }
}

