/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassConstant;
import FESI.ClassFile.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;

class Exceptions
extends Attribute {
    private ClassConstant[] exceptions;

    Exceptions(ClassConstant[] classConstantArray, ClassFile classFile) {
        super("Exceptions", classFile);
        this.exceptions = classConstantArray;
    }

    Exceptions(Class[] classArray, ClassFile classFile) {
        super("Exceptions", classFile);
        ClassConstant[] classConstantArray = new ClassConstant[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            classConstantArray[n] = classFile.addClassConstant(classArray[n].getName());
            ++n;
        }
        this.exceptions = classConstantArray;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getNameConstantPoolIndex());
        dataOutputStream.writeInt(this.getLength());
        if (this.exceptions != null && this.exceptions.length > 0) {
            dataOutputStream.writeShort(this.exceptions.length);
            int n = 0;
            while (n < this.exceptions.length) {
                dataOutputStream.writeShort(this.exceptions[n].getConstantPoolIndex());
                ++n;
            }
            return;
        }
        dataOutputStream.writeShort(0);
    }

    public boolean equals(Object object) {
        if (object instanceof Exceptions) {
            Exceptions exceptions = (Exceptions)object;
            if (this.exceptions.length == exceptions.exceptions.length) {
                int n = 0;
                while (n < this.exceptions.length) {
                    if (!this.exceptions[n].equals(exceptions.exceptions[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    int getLength() {
        return this.exceptions.length * 2 + 2;
    }

    void addException(ClassConstant classConstant) {
        if (this.exceptions == null) {
            this.exceptions = new ClassConstant[1];
            this.exceptions[0] = classConstant;
            return;
        }
        ClassConstant[] classConstantArray = new ClassConstant[this.exceptions.length + 1];
        int n = 0;
        while (n < this.exceptions.length) {
            classConstantArray[n] = this.exceptions[n];
            ++n;
        }
        classConstantArray[n] = classConstant;
        this.exceptions = classConstantArray;
    }
}

