/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayPrototype;
import FESI.Data.CompatibilityDescriptor;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectObject;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.ClassInfo;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.EventAdaptor;
import FESI.Interpreter.ScopeChain;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class ESWrapper
extends ESObject {
    static boolean debugEvent;
    private Object javaObject;
    private boolean asBean = false;
    private static ESObject noPropertyMarker;
    private Hashtable eventHandlers;
    private Hashtable eventAdaptors;
    static final int stepClass = 0;
    static final int stepConstructors = 1;
    static final int stepMethods = 2;
    static final int stepBeanMethods = 3;
    static final int stepFields = 4;
    static final int stepBeanProperties = 5;
    static final int stepEvents = 6;
    static final int stepNoMore = 7;
    static /* synthetic */ Class class$java$lang$Void;

    public static void setDebugEvent(boolean bl) {
        debugEvent = bl;
    }

    public static boolean isDebugEvent() {
        return debugEvent;
    }

    public ESWrapper(Object object, Evaluator evaluator) {
        super(null, evaluator);
        this.javaObject = object;
        if (object.getClass().isArray()) {
            throw new ProgrammingError("Object wrapper used on array object");
        }
        if (noPropertyMarker == null) {
            noPropertyMarker = new ObjectObject(null, evaluator);
        }
    }

    public ESWrapper(Object object, Evaluator evaluator, boolean bl) {
        super(null, evaluator);
        this.javaObject = object;
        this.asBean = bl;
        if (object.getClass().isArray()) {
            throw new ProgrammingError("Object wrapper used on array object");
        }
        if (noPropertyMarker == null) {
            noPropertyMarker = new ObjectObject(null, evaluator);
        }
    }

    public Object getJavaObject() {
        return this.javaObject;
    }

    public boolean isBean() {
        return this.asBean;
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Wrapper");
    }

    public String getESClassName() {
        return "Java Object";
    }

    public int getTypeOf() {
        return 6;
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        ESValue eSValue;
        if (this.asBean) {
            eSValue = this.getBeanProperty(string, n);
            if (eSValue != noPropertyMarker) {
                return eSValue;
            }
        } else {
            eSValue = this.getObjectProperty(string, n);
            if (eSValue == noPropertyMarker) {
                eSValue = this.getBeanProperty(string, n);
            }
            if (eSValue == noPropertyMarker) {
                eSValue = this.getCorbaProperty(string, n);
            }
        }
        if (eSValue == noPropertyMarker) {
            if (scopeChain == null) {
                throw new EcmaScriptException("global variable '" + string + "' does not have a value");
            }
            eSValue = scopeChain.getValue(string, n);
        }
        return eSValue;
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        ESValue eSValue;
        if (this.asBean) {
            eSValue = this.getBeanProperty(string, n);
            if (eSValue == noPropertyMarker) {
                throw new EcmaScriptException("Property '" + string + "' does not exists in bean " + this);
            }
        } else {
            eSValue = this.getObjectProperty(string, n);
            if (eSValue == noPropertyMarker) {
                eSValue = this.getBeanProperty(string, n);
            }
            if (eSValue == noPropertyMarker && this.javaObject instanceof Class) {
                String string2 = String.valueOf(((Class)this.javaObject).getName()) + "$" + string;
                if (ESLoader.debugJavaAccess) {
                    System.out.println("** Check if inside class: " + string2);
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new EcmaScriptException("Subclass, field or property '" + string + "' does not exists in class " + this);
                }
                return new ESWrapper(clazz, this.evaluator);
            }
            if (eSValue == noPropertyMarker) {
                eSValue = this.getCorbaProperty(string, n);
            }
            if (eSValue == noPropertyMarker) {
                throw new EcmaScriptException("Field or property '" + string + "' does not exists in object " + this);
            }
        }
        return eSValue;
    }

    private ESValue getBeanProperty(String string, int n) throws EcmaScriptException {
        GenericDeclaration genericDeclaration;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Bean property searched: " + string);
        }
        Class<?> clazz = null;
        Object object = null;
        if (this.javaObject instanceof Class) {
            clazz = (Class<?>)this.javaObject;
        } else {
            clazz = this.javaObject.getClass();
            object = this.javaObject;
        }
        PropertyDescriptor propertyDescriptor = ClassInfo.lookupBeanField(string, clazz);
        if (propertyDescriptor == null) {
            return noPropertyMarker;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && (genericDeclaration = propertyDescriptor.getPropertyType()) == null) {
            throw new EcmaScriptException("Bean property '" + string + "' does not have an array access method");
        }
        genericDeclaration = propertyDescriptor.getReadMethod();
        if (genericDeclaration == null) {
            throw new EcmaScriptException("No read method for property " + string);
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Read method found for: " + string);
        }
        Object object2 = null;
        try {
            object2 = ((Method)genericDeclaration).invoke(this.javaObject, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EcmaScriptException("Error int the getter for " + string, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Access error invoking getter for " + string + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProgrammingError("Inconsistent type of argument for property " + string + ": " + illegalArgumentException.getMessage());
        }
        return ESLoader.normalizeValue(object2, this.evaluator);
    }

    private ESValue getCorbaProperty(String string, int n) throws EcmaScriptException {
        Class<?> clazz;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** CORBA property searched: " + string);
        }
        Class<?> clazz2 = this.javaObject.getClass();
        Method method = null;
        try {
            method = clazz2.getMethod(string, null);
            if (method == null) {
                return noPropertyMarker;
            }
            clazz = method.getReturnType();
            if (clazz == null || clazz == Void.TYPE || method.getParameterTypes().length != 0) {
                return noPropertyMarker;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return noPropertyMarker;
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** CORBA read method found for: " + string);
        }
        clazz = null;
        try {
            clazz = method.invoke(this.javaObject, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EcmaScriptException("Error in the CORBA getter function for " + string, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Access error invoking CORBA getter for " + string + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProgrammingError("Inconsistent type of argument for property " + string + ": " + illegalArgumentException.getMessage());
        }
        return ESLoader.normalizeValue(clazz, this.evaluator);
    }

    private ESValue getObjectProperty(String string, int n) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Java object field searched: " + string);
        }
        try {
            Field field;
            Class<?> clazz = null;
            Object object = null;
            if (this.javaObject instanceof Class) {
                clazz = (Class<?>)this.javaObject;
            } else {
                clazz = this.javaObject.getClass();
                object = this.javaObject;
            }
            try {
                field = object == null ? clazz.getDeclaredField(string) : clazz.getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return noPropertyMarker;
            }
            int n2 = field.getModifiers();
            if (object == null != Modifier.isStatic(n2)) {
                throw new EcmaScriptException("Field mode (static) not correct for " + string);
            }
            if (!Modifier.isPublic(n2)) {
                throw new EcmaScriptException("Field " + string + " not public");
            }
            Object object2 = field.get(object);
            return ESLoader.normalizeValue(object2, this.evaluator);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Cannot access java field " + string + " in " + this + ", error: " + illegalAccessException.toString());
        }
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        try {
            this.getProperty(string, n);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isHiddenProperty(String string, int n) {
        return false;
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (eSValue == ESUndefined.theUndefined) {
            throw new EcmaScriptException("Cannot set the field or property " + string + " of a non EcmaScript object field to undefined");
        }
        if (this.asBean) {
            if (!this.putBeanProperty(string, eSValue, n)) {
                throw new EcmaScriptException("Cannot put value in property '" + string + "' which does not exists in Java Bean '" + this + "'");
            }
        } else {
            if (this.putObjectProperty(string, eSValue, n)) {
                return;
            }
            if (this.putBeanProperty(string, eSValue, n)) {
                return;
            }
            if (this.putCorbaProperty(string, eSValue, n)) {
                return;
            }
            throw new EcmaScriptException("Cannot put value in field or property '" + string + "' which does not exists in Java or Corba object '" + this + "'");
        }
    }

    private boolean putBeanProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Bean property searched: " + string);
        }
        if (eSValue == ESUndefined.theUndefined) {
            throw new ProgrammingError("Cannot set bean property " + string + " to undefined");
        }
        Class<?> clazz = null;
        Object object = null;
        if (this.javaObject instanceof Class) {
            clazz = (Class<?>)this.javaObject;
        } else {
            clazz = this.javaObject.getClass();
            object = this.javaObject;
        }
        PropertyDescriptor propertyDescriptor = ClassInfo.lookupBeanField(string, clazz);
        if (propertyDescriptor == null) {
            if (object != null && string.startsWith("on")) {
                this.putEventHandler(string, eSValue);
                return true;
            }
            return false;
        }
        Class<?> clazz2 = propertyDescriptor.getPropertyType();
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && clazz2 == null) {
            throw new EcmaScriptException("Bean property '" + string + "' does not have an array access method");
        }
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new EcmaScriptException("No write method for Java property '" + string + "'");
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Write method found for: " + string);
        }
        Object[] objectArray = new Object[1];
        if (clazz2.isArray()) {
            if (!(eSValue instanceof ArrayPrototype)) {
                throw new EcmaScriptException("Argument should be Array for property '" + string + "'");
            }
            ArrayPrototype arrayPrototype = (ArrayPrototype)eSValue;
            objectArray[0] = arrayPrototype.toJavaArray(clazz2.getComponentType());
        } else {
            objectArray[0] = eSValue.toJavaObject();
        }
        try {
            method.invoke(this.javaObject, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EcmaScriptException("Error in the setter for " + string, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Access error invoking setter for " + string + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EcmaScriptException("Type of argument not suitable for property " + string + ": " + illegalArgumentException.getMessage());
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Property set: " + string);
        }
        return true;
    }

    private boolean putCorbaProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Corba property searched: " + string);
        }
        if (eSValue == ESUndefined.theUndefined) {
            throw new ProgrammingError("Cannot set non EcmaScript property " + string + " to undefined");
        }
        Object[] objectArray = new Object[]{eSValue.toJavaObject()};
        Method method = null;
        try {
            method = this.lookupMethod(this.evaluator, string, objectArray, false);
            if (method == null) {
                return false;
            }
            Class<?> clazz = method.getReturnType();
            if (clazz != null && clazz == (class$java$lang$Void != null ? class$java$lang$Void : (class$java$lang$Void = ESWrapper.class$("java.lang.Void")))) {
                return false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** CORBA write method found for: " + string);
        }
        try {
            method.invoke(this.javaObject, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EcmaScriptException("Error in the CORBA setter for " + string, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Access error invoking CORBA setter for " + string + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EcmaScriptException("Type of argument not suitable for CORBA property " + string + ": " + illegalArgumentException.getMessage());
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Property set: " + string);
        }
        return true;
    }

    private boolean putObjectProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        Field field;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Object field searched: " + string);
        }
        if (eSValue == ESUndefined.theUndefined) {
            throw new ProgrammingError("Cannot set java object field " + string + " to undefined");
        }
        Object object = null;
        Class<?> clazz = null;
        if (this.javaObject instanceof Class) {
            clazz = (Class<?>)this.javaObject;
        } else {
            clazz = this.javaObject.getClass();
            object = this.javaObject;
        }
        try {
            field = object == null ? clazz.getDeclaredField(string) : clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (object != null && string.startsWith("on")) {
                this.putEventHandler(string, eSValue);
                return true;
            }
            return false;
        }
        int n2 = field.getModifiers();
        if (object == null != Modifier.isStatic(n2)) {
            throw new EcmaScriptException("Field mode (static) not correct for " + string);
        }
        if (!Modifier.isPublic(n2)) {
            throw new EcmaScriptException("Field " + string + " not public");
        }
        try {
            field.set(object, eSValue.toJavaObject());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EcmaScriptException("Field " + string + " of " + this + " cannot be set with " + eSValue + ", error: " + illegalArgumentException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Access error setting field " + string + " of " + this + ", error: " + illegalAccessException.toString());
        }
        return true;
    }

    public void putHiddenProperty(String string, ESValue eSValue) throws EcmaScriptException {
        throw new ProgrammingError("Cannot put hidden property in " + this);
    }

    public boolean deleteProperty(String string, int n) throws EcmaScriptException {
        return false;
    }

    public boolean isDirectEnumerator() {
        return true;
    }

    public Enumeration getProperties() {
        if (this.javaObject instanceof Enumeration) {
            return (Enumeration)this.javaObject;
        }
        return new 1();
    }

    public Enumeration getAllProperties() {
        return this.getProperties();
    }

    private EventAdaptor getEventAdaptor(Class clazz) throws EcmaScriptException {
        EventAdaptor eventAdaptor;
        if (this.eventAdaptors == null) {
            this.eventAdaptors = new Hashtable();
        }
        if ((eventAdaptor = (EventAdaptor)this.eventAdaptors.get(clazz)) == null) {
            if (debugEvent) {
                System.out.println("** Creating new adaptor for '" + clazz.getName() + "'");
            }
            try {
                eventAdaptor = EventAdaptor.getEventAdaptor(clazz, this.javaObject, this);
            }
            catch (Exception exception) {
                throw new EcmaScriptException("Cannot build adaptor for '" + clazz.getName() + "', error: " + exception);
            }
            this.eventAdaptors.put(clazz, eventAdaptor);
        }
        if (debugEvent) {
            System.out.println("** Adaptor found: " + eventAdaptor);
        }
        return eventAdaptor;
    }

    private void putEventHandler(String string, ESValue eSValue) throws EcmaScriptException {
        Object object;
        Object object2;
        Object object3;
        String string2 = string.substring(2);
        if (debugEvent) {
            System.out.println("** Attempt to set event '" + string + "'");
        }
        ESObject eSObject = null;
        if (eSValue != ESNull.theNull) {
            if (eSValue instanceof FunctionPrototype) {
                eSObject = (ESObject)eSValue;
            } else {
                object3 = eSValue.toESString();
                object2 = this.evaluator.getFunctionObject();
                object = new ESString("event");
                ESValue[] eSValueArray = new ESValue[]{object, object3};
                try {
                    eSObject = ((ESObject)object2).doConstruct(null, eSValueArray);
                }
                catch (EcmaScriptException ecmaScriptException) {
                    throw new EcmaScriptException("Error creating function anonymous(event){" + object3 + "}\n" + ecmaScriptException);
                }
            }
        }
        object3 = this.javaObject.getClass();
        try {
            object2 = Introspector.getBeanInfo(object3);
        }
        catch (IntrospectionException introspectionException) {
            throw new EcmaScriptException("BeanInfo not found for java class '" + object3 + "', error: " + introspectionException.getMessage());
        }
        object = object2.getEventSetDescriptors();
        int n = 0;
        while (n < ((EventSetDescriptor[])object).length) {
            Object object4;
            Method[] methodArray;
            EventSetDescriptor eventSetDescriptor = object[n];
            String string3 = eventSetDescriptor.getName();
            if (string3.equalsIgnoreCase(string2)) {
                if (debugEvent) {
                    System.out.println("** Event '" + string + "' found");
                }
                if ((methodArray = eventSetDescriptor.getListenerMethods()).length != 1) {
                    throw new EcmaScriptException("Only 1 listener supported, there are " + methodArray.length + " listeners for event '" + string2 + "'");
                }
                Class<?> clazz = eventSetDescriptor.getListenerType();
                object4 = String.valueOf(clazz.getName()) + ":" + methodArray[0].getName();
                this.getEventAdaptor(clazz);
                if (this.eventHandlers == null) {
                    this.eventHandlers = new Hashtable();
                }
                if (eSValue == ESNull.theNull) {
                    if (debugEvent) {
                        System.out.println(" ** Handler removed for key: " + (String)object4);
                    }
                    this.eventHandlers.remove(object4);
                    return;
                }
                if (debugEvent) {
                    System.out.println(" ** Handler added for key: " + (String)object4);
                }
                this.eventHandlers.put(object4, eSObject);
                return;
            }
            methodArray = eventSetDescriptor.getListenerMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                object4 = methodArray[n2];
                String string4 = ((Method)object4).getName();
                if (string4.equalsIgnoreCase(string2)) {
                    if (debugEvent) {
                        System.out.println("** Event method '" + string + "' found");
                    }
                    Class<?> clazz = eventSetDescriptor.getListenerType();
                    String string5 = String.valueOf(clazz.getName()) + ":" + ((Method)object4).getName();
                    this.getEventAdaptor(clazz);
                    if (this.eventHandlers == null) {
                        this.eventHandlers = new Hashtable();
                    }
                    if (eSValue == ESNull.theNull) {
                        if (debugEvent) {
                            System.out.println(" ** Handler removed for key: " + string5);
                        }
                        this.eventHandlers.remove(string5);
                        return;
                    }
                    if (debugEvent) {
                        System.out.println(" ** Handler added for key: " + string5);
                    }
                    this.eventHandlers.put(string5, eSObject);
                    return;
                }
                ++n2;
            }
            ++n;
        }
        throw new EcmaScriptException("Event '" + string2 + "' not found for java class " + object3);
    }

    public ESValue getDefaultValue(int n) throws EcmaScriptException {
        if (n == 5) {
            return new ESString(this.javaObject.toString());
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + n);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method lookupMethod(Evaluator evaluator, String string, Object[] objectArray, boolean bl) throws EcmaScriptException, NoSuchMethodException {
        int n = objectArray.length;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** " + (this.asBean ? "Bean" : "Class") + " method lookup: " + (bl ? "static " : "") + string);
        }
        Class clazz = null;
        Object object = null;
        if (bl) {
            if (!(this.javaObject instanceof Class)) throw new ProgrammingError("Cannot lookup for static method if not class");
            clazz = (Class)this.javaObject;
        } else {
            clazz = this.javaObject.getClass();
            object = this.javaObject;
        }
        Method[] methodArray = null;
        methodArray = this.asBean ? ClassInfo.lookupBeanMethod(string, clazz) : ClassInfo.lookupPublicMethod(string, clazz);
        if (methodArray == null || methodArray.length == 0) {
            if (!bl) throw new NoSuchMethodException("No method named '" + string + "' found in " + this);
            return null;
        }
        boolean bl2 = false;
        Method method = null;
        CompatibilityDescriptor compatibilityDescriptor = null;
        int n2 = -1;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < methodArray.length) {
            Method method2 = methodArray[n3];
            if (ESLoader.debugJavaAccess) {
                System.out.println("** Method to validate: " + method2.toString());
            }
            int n4 = method2.getModifiers();
            if (!bl || Modifier.isStatic(n4)) {
                CompatibilityDescriptor compatibilityDescriptor2;
                int n5;
                bl2 = true;
                Class[] classArray = method2.getParameterTypes();
                if (classArray.length == n && (n5 = (compatibilityDescriptor2 = ESLoader.areParametersCompatible(classArray, objectArray)).getDistance()) >= 0) {
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Method acceptable(" + n5 + " : " + Modifier.toString(n4) + " " + methodArray[n3].toString());
                    }
                    if (n5 == 0 && !ESLoader.debugJavaAccess) {
                        compatibilityDescriptor2.convert(objectArray);
                        return method2;
                    }
                    if (method == null) {
                        method = method2;
                        compatibilityDescriptor = compatibilityDescriptor2;
                        n2 = n5;
                    } else if (n5 < n2) {
                        method = method2;
                        compatibilityDescriptor = compatibilityDescriptor2;
                        n2 = n5;
                        bl3 = false;
                    } else if (n5 == n2) {
                        if (ESLoader.debugJavaAccess) {
                            System.out.println("** Same distance as previous method!");
                        }
                        if (n5 != 0) {
                            bl3 = true;
                        }
                    }
                }
            }
            ++n3;
        }
        if (method != null) {
            if (bl3) {
                throw new EcmaScriptException("Ambiguous method '" + string + "' matching parameters in " + this);
            }
            compatibilityDescriptor.convert(objectArray);
            return method;
        }
        if (bl2) {
            throw new EcmaScriptException("No method '" + string + "' matching parameters in " + this);
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Method rejected - did not match attribute or parameters");
        }
        if (!bl) throw new EcmaScriptException("No method named '" + string + "' found in " + this);
        return null;
    }

    public ESValue doIndirectCall(Evaluator evaluator, ESObject eSObject, String string, ESValue[] eSValueArray) throws EcmaScriptException, NoSuchMethodException {
        int n = eSValueArray.length;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Method searched: " + string + " in object of class " + this.javaObject.getClass());
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            if (eSValueArray[n2] == ESUndefined.theUndefined) {
                throw new EcmaScriptException("Cannot use undefined as parameter for java method " + string + ", use 'null'");
            }
            objectArray[n2] = eSValueArray[n2].toJavaObject();
            ++n2;
        }
        Method method = null;
        if (this.javaObject instanceof Class) {
            method = this.lookupMethod(evaluator, string, objectArray, true);
        }
        if (method == null) {
            method = this.lookupMethod(evaluator, string, objectArray, false);
        }
        Object object = null;
        Class<?> clazz = method.getReturnType();
        try {
            object = method.invoke(this.javaObject, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EcmaScriptException("Error in java method " + string, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EcmaScriptException("Access error invoking java method " + string + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProgrammingError("Inconsistent type of argument for method " + string + ": " + illegalArgumentException.getMessage());
        }
        ESValue eSValue = clazz != Void.TYPE ? ESLoader.normalizeValue(object, evaluator) : ESUndefined.theUndefined;
        return eSValue;
    }

    public ESValue doIndirectCallInScope(Evaluator evaluator, ScopeChain scopeChain, ESObject eSObject, String string, int n, ESValue[] eSValueArray) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Method searched (indirect): " + string);
        }
        try {
            return this.doIndirectCall(evaluator, eSObject, string, eSValueArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (scopeChain == null) {
                throw new EcmaScriptException("no global function named '" + string + "'");
            }
            return scopeChain.doIndirectCall(evaluator, eSObject, string, n, eSValueArray);
        }
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        return this.constructOrCall(eSObject, eSValueArray, true);
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        return this.constructOrCall(eSObject, eSValueArray, false);
    }

    private ESObject constructOrCall(ESObject eSObject, ESValue[] eSValueArray, boolean bl) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Constructor searched for: " + this.javaObject.toString());
        }
        if (this.javaObject instanceof Class) {
            int n = eSValueArray.length;
            try {
                Constructor<?> constructor;
                Class clazz = (Class)this.javaObject;
                Constructor<?>[] constructorArray = clazz.getConstructors();
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    if (eSValueArray[n2] == ESUndefined.theUndefined) {
                        throw new EcmaScriptException("Cannot use undefined as parameter for java constructor " + clazz.toString());
                    }
                    objectArray[n2] = eSValueArray[n2].toJavaObject();
                    ++n2;
                }
                boolean bl2 = false;
                Constructor<?> constructor2 = null;
                CompatibilityDescriptor compatibilityDescriptor = null;
                int n3 = -1;
                boolean bl3 = false;
                int n4 = 0;
                while (n4 < constructorArray.length) {
                    constructor = constructorArray[n4];
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Contructor examined: " + constructor.toString());
                    }
                    Class[] classArray = constructor.getParameterTypes();
                    int n5 = constructor.getModifiers();
                    if (Modifier.isPublic(n5)) {
                        CompatibilityDescriptor compatibilityDescriptor2;
                        int n6;
                        bl2 = true;
                        if (classArray.length == n && (n6 = (compatibilityDescriptor2 = ESLoader.areParametersCompatible(classArray, objectArray)).getDistance()) >= 0) {
                            if (ESLoader.debugJavaAccess) {
                                System.out.println("** Constructor acceptable(" + n6 + " : " + Modifier.toString(n5) + " " + constructorArray[n4].toString());
                            }
                            if (n6 == 0 && !ESLoader.debugJavaAccess) {
                                constructor2 = constructor;
                                compatibilityDescriptor = compatibilityDescriptor2;
                                n3 = n6;
                                break;
                            }
                            if (constructor2 == null) {
                                constructor2 = constructor;
                                compatibilityDescriptor = compatibilityDescriptor2;
                                n3 = n6;
                            } else if (n6 < n3) {
                                constructor2 = constructor;
                                compatibilityDescriptor = compatibilityDescriptor2;
                                n3 = n6;
                                bl3 = false;
                            } else if (n6 == n3) {
                                if (ESLoader.debugJavaAccess) {
                                    System.out.println("** Same distance as previous constructor!");
                                }
                                if (n6 != 0) {
                                    bl3 = true;
                                }
                            }
                        }
                    }
                    ++n4;
                }
                if (constructor2 != null) {
                    if (bl3) {
                        throw new EcmaScriptException("Ambiguous constructor for " + this.javaObject.toString());
                    }
                    compatibilityDescriptor.convert(objectArray);
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Contructor called: " + constructor2.toString());
                    }
                    constructor = null;
                    try {
                        constructor = constructor2.newInstance(objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new EcmaScriptException("Error creating " + this.javaObject + ": " + invocationTargetException.getTargetException());
                    }
                    if (ESLoader.isBasicClass(clazz) && !bl) {
                        return new ESWrapper(constructor, this.evaluator);
                    }
                    return ESLoader.normalizeObject(constructor, this.evaluator);
                }
                if (bl2) {
                    throw new EcmaScriptException("No constructor matching parameters in: " + this);
                }
                throw new EcmaScriptException("No public constructor in: " + this);
            }
            catch (Exception exception) {
                throw new EcmaScriptException("Cannot build new " + this + ", error: " + exception.toString());
            }
        }
        throw new EcmaScriptException("Not a java class: " + this);
    }

    public double doubleValue() {
        double d = Double.NaN;
        return d;
    }

    public boolean booleanValue() {
        return true;
    }

    public String toString() {
        if (this.javaObject == null) {
            return "<?Wrapper to null?>";
        }
        return this.javaObject.toString();
    }

    public Object toJavaObject() {
        return this.javaObject;
    }

    public void dispatchEvent(Object[] objectArray, Class clazz, Method method) {
        ESObject eSObject;
        if (debugEvent) {
            System.out.println(" ** Dispatch event: " + method.getName() + " for " + clazz.getName());
        }
        if (this.eventHandlers == null) {
            return;
        }
        String string = String.valueOf(clazz.getName()) + ":" + method.getName();
        if (debugEvent) {
            System.out.println(" ** Event key: " + string);
        }
        if ((eSObject = (ESObject)this.eventHandlers.get(string)) == null) {
            return;
        }
        if (debugEvent) {
            System.out.println(" ** Handler found: " + eSObject);
        }
        try {
            this.evaluator.evaluateEvent(this, eSObject, objectArray);
            return;
        }
        catch (EcmaScriptException ecmaScriptException) {
            System.err.println("Exception in FESI event handler: " + ecmaScriptException);
            return;
        }
    }

    public String toDetailString() {
        if (this.asBean) {
            return "ES:[BEAN:" + this.getESClassName() + ":" + this.javaObject.toString() + "]";
        }
        return "ES:[OBJ:" + this.getESClassName() + ":" + this.javaObject.toString() + "]";
    }

    private EventSetDescriptor[] getEvents(Class clazz) {
        EventSetDescriptor[] eventSetDescriptorArray = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {}
        if (beanInfo != null) {
            eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        }
        if (eventSetDescriptorArray == null) {
            eventSetDescriptorArray = new EventSetDescriptor[]{};
        }
        return eventSetDescriptorArray;
    }

    public Enumeration getAllDescriptions() {
        return new 2();
    }

    public ValueDescription getDescription(String string) {
        return new ValueDescription(string, "JAVAOBJ", this.toString());
    }

    private static String typename(Class clazz) {
        String string = "";
        while (clazz.isArray()) {
            string = String.valueOf(string) + "[]";
            clazz = clazz.getComponentType();
        }
        return String.valueOf(clazz.getName()) + string;
    }

    private static String modifiers(int n) {
        if (n == 0) {
            return "";
        }
        return String.valueOf(Modifier.toString(n)) + " ";
    }

    private static String describe_field(Field field, Object object) {
        String string = String.valueOf(ESWrapper.modifiers(field.getModifiers())) + ESWrapper.typename(field.getType()) + " " + field.getName();
        try {
            field.get(object);
            string = String.valueOf(string) + " = " + object.toString();
        }
        catch (IllegalAccessException illegalAccessException) {}
        return String.valueOf(string) + ";";
    }

    private static String describe_bean_property(PropertyDescriptor propertyDescriptor, Object object) {
        String string = propertyDescriptor instanceof IndexedPropertyDescriptor ? "[]" : "";
        String string2 = String.valueOf(propertyDescriptor.getName()) + string + " (" + propertyDescriptor.getShortDescription() + ")";
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            try {
                Object object2 = method.invoke(object, null);
                string2 = String.valueOf(string2) + " = " + object2.toString();
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return String.valueOf(string2) + ";";
    }

    private static String describe_method_or_constructor(Member member) {
        Class<?>[] classArray;
        Class<?>[] classArray2;
        Executable executable;
        Class<?> clazz = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (member instanceof Method) {
            executable = (Method)member;
            clazz = ((Method)executable).getReturnType();
            classArray2 = ((Method)executable).getParameterTypes();
            classArray = ((Method)executable).getExceptionTypes();
        } else {
            executable = (Constructor)member;
            classArray2 = ((Constructor)executable).getParameterTypes();
            classArray = ((Constructor)executable).getExceptionTypes();
        }
        stringBuffer.append(ESWrapper.modifiers(member.getModifiers()) + (clazz != null ? String.valueOf(ESWrapper.typename(clazz)) + " " : "") + member.getName() + "(");
        int n = 0;
        while (n < classArray2.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ESWrapper.typename(classArray2[n]));
            ++n;
        }
        stringBuffer.append(")");
        if (classArray.length > 0) {
            stringBuffer.append(" throws ");
        }
        int n2 = 0;
        while (n2 < classArray.length) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ESWrapper.typename(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private static String describe_bean_method(MethodDescriptor methodDescriptor) {
        Class<?> clazz = null;
        StringBuffer stringBuffer = new StringBuffer();
        Method method = methodDescriptor.getMethod();
        clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = method.getExceptionTypes();
        stringBuffer.append(String.valueOf(methodDescriptor.getName()) + ": " + ESWrapper.modifiers(method.getModifiers()) + (clazz != null ? String.valueOf(ESWrapper.typename(clazz)) + " " : "") + method.getName() + "(");
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ESWrapper.typename(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        if (classArray2.length > 0) {
            stringBuffer.append(" throws ");
        }
        int n2 = 0;
        while (n2 < classArray2.length) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ESWrapper.typename(classArray2[n2]));
            ++n2;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private static String describe_class_or_interface(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        if (clazz.isInterface()) {
            stringBuffer.append(String.valueOf(Modifier.toString(clazz.getModifiers())) + " " + clazz.getName());
        } else if (clazz.getSuperclass() != null) {
            stringBuffer.append(String.valueOf(Modifier.toString(clazz.getModifiers())) + " class " + clazz.getName() + " extends " + clazz.getSuperclass().getName());
        } else {
            stringBuffer.append(String.valueOf(Modifier.toString(clazz.getModifiers())) + " class " + clazz.getName());
        }
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null && classArray.length > 0) {
            if (clazz.isInterface()) {
                stringBuffer.append(" extends ");
            } else {
                stringBuffer.append(" implements ");
            }
            int n = 0;
            while (n < classArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[n].getName());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private static String describe_event(EventSetDescriptor eventSetDescriptor) {
        Class<?> clazz = eventSetDescriptor.getListenerType();
        return String.valueOf(eventSetDescriptor.getName()) + " " + clazz.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        noPropertyMarker = null;
    }

    private final class 1
    implements Enumeration {
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Enumeration {
        Class clazz;
        int step;
        Constructor[] constructors;
        Method[] methods;
        Field[] fields;
        PropertyDescriptor[] beanProperties;
        MethodDescriptor[] beanMethods;
        EventSetDescriptor[] events;
        int index;

        private PropertyDescriptor[] getBeanPropertyDescriptors() {
            PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[]{};
            if (ESWrapper.this.asBean) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                    propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                }
                catch (Exception exception) {}
            } else {
                Field[] fieldArray;
                PropertyDescriptor[] propertyDescriptorArray2 = null;
                try {
                    fieldArray = Introspector.getBeanInfo(this.clazz);
                    propertyDescriptorArray2 = fieldArray.getPropertyDescriptors();
                }
                catch (Exception exception) {}
                if (propertyDescriptorArray2 != null) {
                    int n;
                    fieldArray = this.clazz.getFields();
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < propertyDescriptorArray2.length) {
                        String string = propertyDescriptorArray2[n3].getName();
                        n = 0;
                        while (n < fieldArray.length) {
                            String string2 = fieldArray[n].getName();
                            if (string.equals(string2)) {
                                propertyDescriptorArray2[n3] = null;
                                break;
                            }
                            ++n;
                        }
                        if (propertyDescriptorArray2[n3] != null) {
                            ++n2;
                        }
                        ++n3;
                    }
                    if (n2 > 0) {
                        propertyDescriptorArray = new PropertyDescriptor[n2];
                        int n4 = 0;
                        n = 0;
                        while (n < propertyDescriptorArray2.length) {
                            if (propertyDescriptorArray2[n] != null) {
                                propertyDescriptorArray[n4++] = propertyDescriptorArray2[n];
                            }
                            ++n;
                        }
                    }
                }
            }
            return propertyDescriptorArray;
        }

        private MethodDescriptor[] getBeanMethodDescriptors() {
            MethodDescriptor[] methodDescriptorArray;
            block2: {
                methodDescriptorArray = new MethodDescriptor[]{};
                if (!ESWrapper.this.asBean) break block2;
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                    methodDescriptorArray = beanInfo.getMethodDescriptors();
                }
                catch (Exception exception) {}
            }
            return methodDescriptorArray;
        }

        public boolean hasMoreElements() {
            if (this.step == 0) {
                return true;
            }
            if (this.step == 1) {
                if (this.constructors.length > this.index) {
                    return true;
                }
                ++this.step;
                this.index = 0;
            }
            if (this.step == 2) {
                if (this.methods.length > this.index) {
                    return true;
                }
                ++this.step;
                this.index = 0;
            }
            if (this.step == 3) {
                if (this.beanMethods.length > this.index) {
                    return true;
                }
                ++this.step;
                this.index = 0;
            }
            if (this.step == 4) {
                if (this.fields.length > this.index) {
                    return true;
                }
                ++this.step;
                this.index = 0;
            }
            if (this.step == 5) {
                if (this.beanProperties.length > this.index) {
                    return true;
                }
                ++this.step;
                this.index = 0;
            }
            if (this.step == 6) {
                if (this.events.length > this.index) {
                    return true;
                }
                ++this.step;
                this.index = 0;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                switch (this.step) {
                    case 0: {
                        ++this.step;
                        if (ESWrapper.this.asBean) {
                            return new ValueDescription("BEAN", ESWrapper.describe_class_or_interface(this.clazz));
                        }
                        return new ValueDescription("CLASS", ESWrapper.describe_class_or_interface(this.clazz));
                    }
                    case 1: {
                        if (ESWrapper.this.asBean) {
                            String string = "[[error]]";
                            ++this.index;
                            try {
                                BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                                string = String.valueOf(beanDescriptor.getName()) + " (" + beanDescriptor.getShortDescription() + ")";
                            }
                            catch (Exception exception) {}
                            return new ValueDescription("BEANINFO", string);
                        }
                        return new ValueDescription("CONSTR", ESWrapper.describe_method_or_constructor(this.constructors[this.index++]));
                    }
                    case 2: {
                        return new ValueDescription("FUNC", ESWrapper.describe_method_or_constructor(this.methods[this.index++]));
                    }
                    case 3: {
                        return new ValueDescription("METHOD", ESWrapper.describe_bean_method(this.beanMethods[this.index++]));
                    }
                    case 4: {
                        return new ValueDescription("FIELD", ESWrapper.describe_field(this.fields[this.index++], ESWrapper.this.javaObject));
                    }
                    case 5: {
                        return new ValueDescription("PROPS", ESWrapper.describe_bean_property(this.beanProperties[this.index++], ESWrapper.this.javaObject));
                    }
                    case 6: {
                        return new ValueDescription("EVENT", ESWrapper.describe_event(this.events[this.index++]));
                    }
                }
                throw new ProgrammingError("Inconsistent step");
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 2() {
            this.clazz = ESWrapper.this.javaObject.getClass();
            this.step = 0;
            this.constructors = this.clazz.getConstructors();
            this.methods = ESWrapper.this.asBean ? new Method[]{} : this.clazz.getMethods();
            this.fields = ESWrapper.this.asBean ? new Field[]{} : this.clazz.getFields();
            this.beanProperties = this.getBeanPropertyDescriptors();
            this.beanMethods = this.getBeanMethodDescriptors();
            this.events = ESWrapper.this.getEvents(this.clazz);
        }
    }
}

