/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.RESyntax;

class ESGNURegExp
extends ESObject {
    private String regExpString;
    private boolean ignoreCase = false;
    private boolean global = false;
    private RE pattern;
    private int groups;
    private static final String IGNORECASEstring = "ignoreCase";
    private static final int IGNORECASEhash = "ignoreCase".hashCode();
    private static final String GLOBALstring = "global";
    private static final int GLOBALhash = "global".hashCode();

    ESGNURegExp(ESObject eSObject, Evaluator evaluator, String string) {
        super(eSObject, evaluator);
        this.regExpString = string;
    }

    ESGNURegExp(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
        this.regExpString = "";
    }

    public RE getPattern() throws EcmaScriptException {
        if (this.pattern == null) {
            this.compile();
        }
        return this.pattern;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void compile() throws EcmaScriptException {
        try {
            this.pattern = new RE(this.regExpString, (this.ignoreCase ? 2 : 0) | 8, RESyntax.RE_SYNTAX_PERL5);
            return;
        }
        catch (REException rEException) {
            throw new EcmaScriptException(this.toString(), rEException);
        }
    }

    public String getESClassName() {
        return "RegExp";
    }

    public String toString() {
        return "/" + (this.regExpString == null ? "<null>" : this.regExpString) + "/";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        if (IGNORECASEstring.equals(string)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (GLOBALstring.equals(string)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getPropertyInScope(string, scopeChain, n);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (IGNORECASEstring.equals(string)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (GLOBALstring.equals(string)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getProperty(string, n);
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (n == IGNORECASEhash && IGNORECASEstring.equals(string)) {
            boolean bl = this.ignoreCase;
            this.ignoreCase = ((ESPrimitive)eSValue).booleanValue();
            if (bl != this.ignoreCase) {
                this.pattern = null;
                return;
            }
        } else {
            if (n == GLOBALhash && GLOBALstring.equals(string)) {
                this.global = ((ESPrimitive)eSValue).booleanValue();
                return;
            }
            super.putProperty(string, eSValue, n);
        }
    }

    public String[] getSpecialPropertyNames() {
        String[] stringArray = new String[]{GLOBALstring, IGNORECASEstring};
        return stringArray;
    }
}

